/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd;

import java.awt.Color;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.openmicroscopy.shoola.env.rnd.ChannelBindingsProxy;

public class RndProxyDef {
    private int defaultZ;
    private int defaultT;
    private int bitResolution;
    private int cdStart;
    private int cdEnd;
    private String colorModel;
    private Map<Integer, ChannelBindingsProxy> channels = new HashMap<Integer, ChannelBindingsProxy>();
    private boolean typeSigned;
    private double compression = 1.0;
    private Timestamp lastModified;

    RndProxyDef() {
    }

    void setLastModified(Timestamp lastModified) {
        this.lastModified = lastModified;
    }

    int getNumberOfChannels() {
        return this.channels.size();
    }

    void setChannel(int index, ChannelBindingsProxy c) {
        this.channels.put(new Integer(index), c);
    }

    ChannelBindingsProxy getChannel(int index) {
        return this.channels.get(new Integer(index));
    }

    void setDefaultZ(int z) {
        this.defaultZ = z;
    }

    void setDefaultT(int t) {
        this.defaultT = t;
    }

    int getBitResolution() {
        return this.bitResolution;
    }

    void setBitResolution(int bitResolution) {
        this.bitResolution = bitResolution;
    }

    int getCdEnd() {
        return this.cdEnd;
    }

    void setCodomain(int cdStart, int cdEnd) {
        this.cdStart = cdStart;
        this.cdEnd = cdEnd;
    }

    int getCdStart() {
        return this.cdStart;
    }

    String getColorModel() {
        return this.colorModel;
    }

    void setColorModel(String colorModel) {
        this.colorModel = colorModel;
    }

    void setTypeSigned(boolean b) {
        this.typeSigned = b;
    }

    boolean isTypeSigned() {
        return this.typeSigned;
    }

    double getCompression() {
        return this.compression;
    }

    void setCompression(double compression) {
        if (compression <= 0.0) {
            compression = 0.1;
        } else if (compression > 1.0) {
            compression = 1.0;
        }
        this.compression = compression;
    }

    RndProxyDef copy() {
        RndProxyDef copy = new RndProxyDef();
        copy.setLastModified(this.getLastModified());
        copy.setCompression(this.getCompression());
        copy.setTypeSigned(this.isTypeSigned());
        copy.setDefaultZ(this.getDefaultZ());
        copy.setDefaultT(this.getDefaultT());
        copy.setBitResolution(this.getBitResolution());
        copy.setColorModel(this.getColorModel());
        copy.setCodomain(this.getCdStart(), this.getCdEnd());
        for (int index : this.channels.keySet()) {
            copy.setChannel(index, this.getChannel(index).copy());
        }
        return copy;
    }

    public int getDefaultT() {
        return this.defaultT;
    }

    public int getDefaultZ() {
        return this.defaultZ;
    }

    public Color getChannelColor(int index) {
        ChannelBindingsProxy channel = this.getChannel(index);
        if (channel == null) {
            return null;
        }
        int[] rgba = channel.getRGBA();
        return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public Timestamp getLastModified() {
        return this.lastModified;
    }
}

