/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd.roi;

import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.env.rnd.data.DataSink;
import org.openmicroscopy.shoola.env.rnd.data.DataSourceException;
import org.openmicroscopy.shoola.env.rnd.roi.PointIterator;
import org.openmicroscopy.shoola.env.rnd.roi.ROIShapeStats;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;

public class ROIAnalyser {
    private PointIterator runner;
    private int sizeZ;
    private int sizeT;
    private int sizeC;

    private boolean checkPlane(int z, int t) {
        if (z < 0 || this.sizeZ <= z) {
            return false;
        }
        return t >= 0 && this.sizeT > t;
    }

    private boolean checkChannel(int w) {
        return w >= 0 && this.sizeC > w;
    }

    public ROIAnalyser(DataSink source, int sizeZ, int sizeT, int sizeC, int sizeX, int sizeY) {
        this.runner = new PointIterator(source, sizeZ, sizeT, sizeC, sizeX, sizeY);
        this.sizeZ = sizeZ;
        this.sizeT = sizeT;
        this.sizeC = sizeC;
    }

    public Map analyze(ROIShape[] shapes, List channels) throws DataSourceException {
        if (shapes == null) {
            throw new NullPointerException("No shapes.");
        }
        if (shapes.length == 0) {
            throw new IllegalArgumentException("No shapes defined.");
        }
        if (channels == null || channels.size() == 0) {
            throw new IllegalArgumentException("No channels defined.");
        }
        HashMap r = new HashMap();
        int n = channels.size();
        for (int i = 0; i < shapes.length; ++i) {
            ROIShape shape = shapes[i];
            if (!this.checkPlane(shape.getZ(), shape.getT())) continue;
            HashMap<Integer, ROIShapeStats> stats = new HashMap<Integer, ROIShapeStats>(n);
            Iterator j = channels.iterator();
            List<Point> points = shape.getFigure().getPoints();
            while (j.hasNext()) {
                Integer w = (Integer)j.next();
                if (!this.checkChannel(w)) continue;
                ROIShapeStats computer = new ROIShapeStats();
                this.runner.register(computer);
                this.runner.iterate(shape, points, w);
                this.runner.remove(computer);
                stats.put(w, computer);
            }
            r.put(shape, stats);
        }
        return r;
    }
}

