/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd.roi;

import java.awt.Point;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openmicroscopy.shoola.env.rnd.roi.PointIteratorObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROIShapeStats
implements PointIteratorObserver {
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_VALUE;
    private double sum;
    private double sumOfSquares;
    private double mean;
    private double standardDeviation;
    private int pointsCount;
    private Map<Point, Double> pixelsValue;

    void setMin(double min) {
        this.min = min;
    }

    void setMax(double max) {
        this.max = max;
    }

    void addToSum(double value) {
        this.sum += value;
    }

    void addToSumOfSquares(double value) {
        this.sumOfSquares += value * value;
    }

    void setMean(double mean) {
        this.mean = mean;
    }

    void setPointsCount(int pointsCount) {
        this.pointsCount = pointsCount;
    }

    double getSumOfSquares() {
        return this.sumOfSquares;
    }

    void setStandardDeviation(double standardDeviation) {
        this.standardDeviation = standardDeviation;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public double getSum() {
        return this.sum;
    }

    public int getPointsCount() {
        return this.pointsCount;
    }

    public Map<Point, Double> getPixelsValue() {
        return this.pixelsValue;
    }

    @Override
    public void onEndPlane(int z, int c, int t, int pointsCount) {
        double sigmaSquare;
        if (pointsCount <= 0) {
            return;
        }
        this.mean = this.sum / (double)pointsCount;
        this.pointsCount = pointsCount;
        if (0 < pointsCount - 1 && (sigmaSquare = (this.sumOfSquares - this.sum * this.sum / (double)pointsCount) / (double)(pointsCount - 1)) > 0.0) {
            this.standardDeviation = Math.sqrt(sigmaSquare);
        }
    }

    @Override
    public void update(double pixelValue, int z, int w, int t, Point loc) {
        this.min = Math.min(pixelValue, this.min);
        this.max = Math.max(pixelValue, this.max);
        this.sum += pixelValue;
        this.sumOfSquares += pixelValue * pixelValue;
        this.pixelsValue.put(loc, new Double(pixelValue));
    }

    @Override
    public void onStartPlane(int z, int w, int t, int pointsCount) {
        this.pixelsValue = new LinkedHashMap<Point, Double>(pointsCount);
    }

    @Override
    public void iterationStarted() {
    }

    @Override
    public void iterationFinished() {
    }
}

