/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.DownloadArchivedActivityParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.ArchivedLoader;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class DownloadArchivedActivity
extends ActivityComponent {
    private static final String DESCRIPTION_CREATED = "Archived Image downloaded";
    private static final String DESCRIPTION_CANCEL = "Download Archived Image cancelled";
    private DownloadArchivedActivityParam parameters;

    DownloadArchivedActivity(UserNotifier viewer, Registry registry, DownloadArchivedActivityParam parameters) {
        super(viewer, registry, "Downloaded Archived Image", parameters.getIcon());
        this.messageLabel.setText("in " + parameters.getLocation());
        this.parameters = parameters;
    }

    protected UserNotifierLoader createLoader() {
        this.loader = new ArchivedLoader(this.viewer, this.registry, this.parameters.getImage(), this.parameters.getLocation(), this);
        return this.loader;
    }

    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    protected void notifyActivityEnd() {
        this.type.setText(DESCRIPTION_CREATED);
        int v = (Integer)this.result;
        String value = null;
        if (v > 1) {
            value = "All " + v + " files downloaded in " + this.parameters.getLocation();
        }
        if (value != null) {
            this.messageLabel.setText(value);
        }
    }

    protected void notifyActivityError() {
    }
}

