/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.ExportActivityParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.ExportLoader;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class ExportActivity
extends ActivityComponent {
    private static final String CREATION_AS_XML = "Export image as XML";
    private static final String CREATION_AS_OME_TIFF = "Export image as OME-TIFF";
    private static final String DESCRIPTION_CREATED = "Image exported";
    private static final String DESCRIPTION_CANCEL = "Export cancelled";
    private ExportActivityParam parameters;

    private String getFileName() {
        File folder = this.parameters.getFolder();
        String extension = "";
        String path = folder.getAbsolutePath();
        switch (this.parameters.getIndex()) {
            case 0: {
                if (path.endsWith("ome.tif") && path.endsWith("ome.tiff")) break;
                extension = ".ome.tif";
            }
        }
        File parent = folder.getParentFile();
        String name = folder.getAbsolutePath();
        if (parent != null) {
            name = this.getFileName(parent.listFiles(), folder.getName() + extension, folder.getName() + extension, parent.getAbsolutePath() + File.separator, 1, extension);
            return parent + File.separator + name;
        }
        return name + extension;
    }

    public ExportActivity(UserNotifier viewer, Registry registry, ExportActivityParam parameters) {
        super(viewer, registry, CREATION_AS_OME_TIFF, parameters.getIcon());
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters not valid.");
        }
        this.parameters = parameters;
        this.messageLabel.setText(this.getFileName());
        switch (parameters.getIndex()) {
            case 0: {
                this.type.setText(CREATION_AS_OME_TIFF);
            }
        }
    }

    protected UserNotifierLoader createLoader() {
        this.loader = new ExportLoader(this.viewer, this.registry, this.parameters.getImage(), new File(this.getFileName()), 0, this);
        return this.loader;
    }

    protected void notifyActivityEnd() {
        this.viewButton.setText("View");
        this.viewButton.setVisible(true);
        this.type.setText(DESCRIPTION_CREATED);
    }

    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    protected void notifyActivityError() {
    }
}

