/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.data.model.AnalysisActivityParam;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.model.DeleteActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadArchivedActivityParam;
import org.openmicroscopy.shoola.env.data.model.ExportActivityParam;
import org.openmicroscopy.shoola.env.data.model.FigureActivityParam;
import org.openmicroscopy.shoola.env.data.model.MovieActivityParam;
import org.openmicroscopy.shoola.env.data.model.ScriptActivityParam;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.AbstractIconManager;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.ActivityProcessEvent;
import org.openmicroscopy.shoola.env.ui.AnalysisActivity;
import org.openmicroscopy.shoola.env.ui.ChangesDialog;
import org.openmicroscopy.shoola.env.ui.DeleteActivity;
import org.openmicroscopy.shoola.env.ui.DownloadActivity;
import org.openmicroscopy.shoola.env.ui.DownloadArchivedActivity;
import org.openmicroscopy.shoola.env.ui.ExportActivity;
import org.openmicroscopy.shoola.env.ui.FigureActivity;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.MovieActivity;
import org.openmicroscopy.shoola.env.ui.ScriptActivity;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.env.ui.UserNotifierManager;
import org.openmicroscopy.shoola.util.ui.MessengerDialog;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserNotifierImpl
implements UserNotifier,
PropertyChangeListener {
    private static final String DEFAULT_ERROR_TITLE = "Error";
    private static final String DEFAULT_WARNING_TITLE = "Warning";
    private static final String DEFAULT_INFO_TITLE = "Information";
    private static JFrame SHARED_FRAME = null;
    private UserNotifierManager manager;
    private ChangesDialog dialog;

    private String printErrorText(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private void showNotificationDialog(String title, String message, Icon icon) {
        NotificationDialog dialog = new NotificationDialog(SHARED_FRAME, title, message, icon);
        dialog.pack();
        UIUtilities.centerAndShow(dialog);
    }

    private String getEmail(String email) {
        if (email != null && email.trim().length() != 0) {
            return email;
        }
        ExperimenterData exp = this.manager.getExperimenter();
        if (exp != null) {
            email = exp.getEmail();
        }
        if (email == null) {
            email = "";
        }
        return email;
    }

    private void showErrorDialog(String title, String summary, String detail, String email) {
        Exception e = detail == null ? new Exception(summary) : new Exception(detail);
        if (title == null || title.length() == 0) {
            title = DEFAULT_ERROR_TITLE;
        }
        MessengerDialog d = new MessengerDialog(SHARED_FRAME, title, this.getEmail(email), e);
        d.setServerVersion(this.manager.getServerVersion());
        d.addPropertyChangeListener(this.manager);
        d.setModal(true);
        UIUtilities.centerAndShow(d);
    }

    UserNotifierImpl(Container c) {
        this.manager = new UserNotifierManager(this, c);
        if (SHARED_FRAME == null) {
            SHARED_FRAME = new JFrame();
            SHARED_FRAME.setIconImage(AbstractIconManager.getOMEImageIcon());
        }
    }

    void showActivity() {
        this.manager.showActivity();
    }

    void notifySaving(List<Object> nodes, PropertyChangeListener listener) {
        this.dialog = new ChangesDialog(SHARED_FRAME, nodes);
        this.dialog.addPropertyChangeListener(this);
        if (listener != null) {
            this.dialog.addPropertyChangeListener(listener);
        }
        UIUtilities.centerAndShow(this.dialog);
    }

    @Override
    public void notifyError(String title, String summary) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_ERROR_TITLE;
        }
        this.showNotificationDialog(title, summary, IconManager.getDefaultErrorIcon());
    }

    @Override
    public void notifyError(String title, String summary, Throwable detail) {
        this.notifyError(title, summary, detail == null ? null : this.printErrorText(detail));
    }

    @Override
    public void notifyError(String title, String summary, String email, Map toSubmit) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_ERROR_TITLE;
        }
        if (email == null) {
            email = "";
        }
        MessengerDialog d = new MessengerDialog(SHARED_FRAME, title, this.getEmail(email), toSubmit);
        d.setServerVersion(this.manager.getServerVersion());
        d.addPropertyChangeListener(this.manager);
        d.setModal(true);
        UIUtilities.centerAndShow(d);
    }

    @Override
    public void notifyError(String title, String summary, String detail) {
        this.showErrorDialog(title, summary, detail, null);
    }

    @Override
    public void notifyWarning(String title, String message) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_WARNING_TITLE;
        }
        this.showNotificationDialog(title, message, IconManager.getDefaultWarnIcon());
    }

    @Override
    public void notifyWarning(String title, String summary, String detail) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_WARNING_TITLE;
        }
        this.showErrorDialog(title, summary, detail, null);
    }

    @Override
    public void notifyWarning(String title, String summary, Throwable detail) {
        this.notifyWarning(title, summary, detail == null ? null : detail.getMessage());
    }

    @Override
    public void notifyInfo(String title, String message) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_INFO_TITLE;
        }
        this.showNotificationDialog(title, message, IconManager.getDefaultInfoIcon());
    }

    @Override
    public void notifyInfo(String title, String message, Icon icon) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_INFO_TITLE;
        }
        if (icon == null) {
            icon = IconManager.getDefaultInfoIcon();
        }
        this.showNotificationDialog(title, message, icon);
    }

    @Override
    public void submitMessage(String email, String comment) {
        MessengerDialog d = this.manager.getCommentDialog(SHARED_FRAME, this.getEmail(email));
        d.setComment(comment);
        UIUtilities.centerAndShow(d);
    }

    @Override
    public void notifyActivity(Object activity) {
        Object p;
        if (activity == null) {
            return;
        }
        ActivityComponent comp = null;
        boolean register = true;
        if (activity instanceof MovieActivityParam) {
            p = (MovieActivityParam)activity;
            comp = new MovieActivity(this, this.manager.getRegistry(), (MovieActivityParam)p);
        } else if (activity instanceof ExportActivityParam) {
            p = (ExportActivityParam)activity;
            comp = new ExportActivity(this, this.manager.getRegistry(), (ExportActivityParam)p);
        } else if (activity instanceof DownloadActivityParam) {
            p = (DownloadActivityParam)activity;
            register = ((DownloadActivityParam)p).getResults() != null ? false : ((DownloadActivityParam)p).getApplicationData() == null;
            comp = new DownloadActivity(this, this.manager.getRegistry(), (DownloadActivityParam)p);
        } else if (activity instanceof FigureActivityParam) {
            p = (FigureActivityParam)activity;
            comp = new FigureActivity(this, this.manager.getRegistry(), (FigureActivityParam)p);
        } else if (activity instanceof AnalysisActivityParam) {
            p = (AnalysisActivityParam)activity;
            comp = new AnalysisActivity(this, this.manager.getRegistry(), (AnalysisActivityParam)p);
        } else if (activity instanceof ScriptActivityParam) {
            p = (ScriptActivityParam)activity;
            comp = new ScriptActivity((UserNotifier)this, this.manager.getRegistry(), ((ScriptActivityParam)p).getScript(), ((ScriptActivityParam)p).getIndex());
        } else if (activity instanceof DownloadArchivedActivityParam) {
            p = (DownloadArchivedActivityParam)activity;
            comp = new DownloadArchivedActivity(this, this.manager.getRegistry(), (DownloadArchivedActivityParam)p);
        } else if (activity instanceof DeleteActivityParam) {
            p = (DeleteActivityParam)activity;
            comp = new DeleteActivity(this, this.manager.getRegistry(), (DeleteActivityParam)p);
        }
        if (comp != null) {
            UserNotifierLoader loader = comp.createLoader();
            if (loader == null) {
                return;
            }
            if (register) {
                comp.startActivity();
            }
            this.manager.registerActivity(comp, register);
            EventBus bus = this.manager.getRegistry().getEventBus();
            bus.post(new ActivityProcessEvent(comp, false));
            loader.load();
        }
    }

    @Override
    public boolean hasRunningActivities() {
        return this.manager.getRunningActivitiesCount() > 0;
    }

    @Override
    public void openApplication(ApplicationData data, String path) {
        if (data == null && path == null) {
            return;
        }
        Runtime run = Runtime.getRuntime();
        try {
            String[] values;
            if (data == null) {
                data = new ApplicationData("");
            }
            List<String> l = data.getArguments();
            Iterator<String> i = l.iterator();
            int index = 0;
            if (path == null || path.length() == 0) {
                values = new String[l.size()];
                while (i.hasNext()) {
                    values[index] = i.next();
                    ++index;
                }
            } else {
                values = new String[l.size() + 1];
                while (i.hasNext()) {
                    values[index] = i.next();
                    ++index;
                }
                values[index] = path;
            }
            run.exec(values);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void setStatus(Object node) {
        if (this.dialog == null) {
            return;
        }
        this.dialog.setStatus(node);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("Done".equals(name) && this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }
    }
}

