/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.image.io;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.openmicroscopy.shoola.util.image.geom.Factory;

public class IconReader {
    public static final String ICNS = "icns";
    public static final int ICON_16 = 16;
    public static final int ICON_32 = 32;
    public static final int ICON_48 = 48;
    public static final int ICON_128 = 128;
    private static final String ICON_SMALL_32_BIT_RGB = "is32";
    private static final String ICON_SMALL_8_BIT_MASK = "s8mk";
    private static final String ICON_LARGE_32_BIT_RGB = "il32";
    private static final String ICON_LARGE_8_BIT_MASK = "l8mk";
    private static final String ICON_HUGE_32_BIT_RGB = "ih32";
    private static final String ICON_HUGE_8_BIT_MASK = "h8mk";
    private static final String THUMBNAIL_32_BIT_RGB = "it32";
    private static final String THUMBNAIL_8_BIT_MASK = "t8mk";
    private static final int SIZE = 4;
    private FileInputStream stream;

    private void read(byte[] array) throws IOException {
        int n;
        int toRead = array.length;
        for (int read = 0; read < toRead; read += n) {
            n = this.stream.read(array, read, toRead - read);
            if (n >= 0) continue;
            throw new IOException("Value cannot be negative.");
        }
    }

    private void ignore(long toIgnore) throws IOException {
        long n;
        for (long ignored = 0L; ignored < toIgnore; ignored += n) {
            n = this.stream.skip(toIgnore - ignored);
            if (n >= 0L) continue;
            throw new IOException("Value cannot be negative.");
        }
    }

    public IconReader(String path) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("No path specified.");
        }
        try {
            this.stream = new FileInputStream(path);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to initialize the file stream.");
        }
    }

    private int[] decode32bitIcon(byte[] data, int[] destination, int size) {
        int[] pixels;
        byte[] unpackedData;
        int nbPixels = size * size;
        if (data.length == nbPixels * 44) {
            unpackedData = data;
        } else {
            unpackedData = new byte[nbPixels * 33];
            this.unpackIconData(data, unpackedData);
        }
        if (destination == null) {
            pixels = new int[nbPixels];
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = -16777216;
            }
        } else {
            pixels = destination;
        }
        int unpackedIndex = 0;
        int i = 0;
        while (i < pixels.length) {
            int n = i++;
            pixels[n] = pixels[n] | (unpackedData[unpackedIndex++] & 0xFF) << 16;
        }
        i = 0;
        while (i < pixels.length) {
            int n = i++;
            pixels[n] = pixels[n] | (unpackedData[unpackedIndex++] & 0xFF) << 8;
        }
        i = 0;
        while (i < pixels.length) {
            int n = i++;
            pixels[n] = pixels[n] | unpackedData[unpackedIndex++] & 0xFF;
        }
        return pixels;
    }

    private int[] decode8bitMask(byte[] data, int[] destination, int size) {
        int arraySize = size * size;
        int[] pixels = destination == null ? new int[arraySize] : destination;
        for (int i = 0; i < pixels.length; ++i) {
            int n = i;
            pixels[n] = pixels[n] & 0xFFFFFF;
            int n2 = i;
            pixels[n2] = pixels[n2] | (data[i] & 0xFF) << 24;
        }
        return pixels;
    }

    private void unpackIconData(byte[] packedData, byte[] unpackedData) {
        int in = 0;
        int out = 0;
        while (in < packedData.length && out < unpackedData.length) {
            int n;
            int h;
            if (((h = packedData[in++] & 0xFF) & 0x80) == 0) {
                n = h + 1;
                System.arraycopy(packedData, in, unpackedData, out, n);
                in += n;
                out += n;
                continue;
            }
            n = h - 125;
            byte data = packedData[in++];
            Arrays.fill(unpackedData, out, out + n, data);
            out += n;
        }
    }

    private int getSize() throws IOException {
        byte[] data = new byte[4];
        this.read(data);
        return ((data[0] & 0xFF) << 24) + ((data[1] & 0xFF) << 16) + ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
    }

    private BufferedImage decodeICNS(int iconIndex) throws IOException {
        int size;
        int[] icon16 = null;
        int[] icon32 = null;
        int[] icon48 = null;
        int[] icon128 = null;
        int fileSize = this.getSize();
        for (int left = fileSize - 8; left > 0; left -= size) {
            byte[] data = new byte[4];
            this.read(data);
            String type = new String(data);
            size = this.getSize();
            int dataSize = size - 8;
            if (ICON_SMALL_32_BIT_RGB.equals(type)) {
                data = new byte[dataSize];
                this.read(data);
                icon16 = this.decode32bitIcon(data, icon16, 16);
                continue;
            }
            if (ICON_LARGE_32_BIT_RGB.equals(type)) {
                data = new byte[dataSize];
                this.read(data);
                icon32 = this.decode32bitIcon(data, icon32, 32);
                continue;
            }
            if (ICON_HUGE_32_BIT_RGB.equals(type)) {
                data = new byte[dataSize];
                this.read(data);
                icon48 = this.decode32bitIcon(data, icon48, 48);
                continue;
            }
            if (THUMBNAIL_32_BIT_RGB.equals(type)) {
                this.ignore(4L);
                data = new byte[dataSize - 4];
                this.read(data);
                icon128 = this.decode32bitIcon(data, icon128, 128);
                continue;
            }
            if (ICON_SMALL_8_BIT_MASK.equals(type)) {
                data = new byte[dataSize];
                this.read(data);
                icon16 = this.decode8bitMask(data, icon16, 16);
                continue;
            }
            if (ICON_LARGE_8_BIT_MASK.equals(type)) {
                data = new byte[dataSize];
                this.read(data);
                icon32 = this.decode8bitMask(data, icon32, 32);
                continue;
            }
            if (ICON_HUGE_8_BIT_MASK.equals(type)) {
                data = new byte[dataSize];
                this.read(data);
                icon48 = this.decode8bitMask(data, icon48, 48);
                continue;
            }
            if (THUMBNAIL_8_BIT_MASK.equals(type)) {
                data = new byte[dataSize];
                this.read(data);
                icon128 = this.decode8bitMask(data, icon128, 128);
                continue;
            }
            this.ignore(dataSize);
        }
        switch (iconIndex) {
            default: {
                return Factory.create(16, 16, icon16);
            }
            case 32: {
                return Factory.create(32, 32, icon32);
            }
            case 48: {
                return Factory.create(48, 48, icon48);
            }
            case 128: 
        }
        return Factory.create(128, 128, icon128);
    }

    public IconReader(File file) {
        if (file == null) {
            throw new IllegalArgumentException("No file specified.");
        }
        try {
            this.stream = new FileInputStream(file);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to initialize the file stream.");
        }
    }

    public BufferedImage decode(int iconIndex) throws IOException {
        byte[] data = new byte[4];
        this.read(data);
        String header = new String(data);
        if (ICNS.equals(header)) {
            return this.decodeICNS(iconIndex);
        }
        return null;
    }
}

