/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.io;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.geom.BezierPath;
import org.openmicroscopy.shoola.util.roi.ROIComponent;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.figures.MeasureBezierFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureEllipseFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureMaskFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasurePointFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureRectangleFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.EllipseData;
import pojos.ImageData;
import pojos.MaskData;
import pojos.PointData;
import pojos.PolygonData;
import pojos.PolylineData;
import pojos.ROIData;
import pojos.RectangleData;
import pojos.ShapeData;
import pojos.ShapeSettingsData;
import pojos.TextData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OutputServerStrategy {
    private ROIComponent component;
    private List<ROIData> ROIList;

    private void parseROI(ImageData image, long ownerID) throws Exception {
        TreeMap<Long, ROI> map = this.component.getROIMap();
        for (ROI roi : map.values()) {
            if (roi.getOwnerID() != ownerID && roi.getOwnerID() != -1L) continue;
            this.ROIList.add(this.createServerROI(roi, image));
        }
    }

    private ShapeData createShapeData(ROIShape clientShape) throws Exception {
        ROIFigure fig = clientShape.getFigure();
        ShapeData shape = null;
        if (fig instanceof MeasureBezierFigure) {
            shape = this.createBezierFigure(clientShape);
        } else if (fig instanceof MeasureEllipseFigure) {
            shape = this.createEllipseFigure(clientShape);
        } else if (fig instanceof MeasureLineFigure) {
            shape = this.createLineFigure(clientShape);
        } else if (fig instanceof MeasureMaskFigure) {
            shape = this.createMaskFigure(clientShape);
        } else if (fig instanceof MeasurePointFigure) {
            shape = this.createPointFigure(clientShape);
        } else if (fig instanceof MeasureRectangleFigure) {
            shape = this.createRectangleFigure(clientShape);
        } else if (fig instanceof MeasureTextFigure) {
            shape = this.createTextFigure(clientShape);
        }
        if (shape == null) {
            throw new Exception("ROIShape not supported : " + clientShape.getClass().toString());
        }
        shape.setT(clientShape.getT());
        shape.setZ(clientShape.getZ());
        shape.setDirty(fig.isDirty());
        if (!fig.isClientObject()) {
            shape.setId(clientShape.getROIShapeID());
        }
        return shape;
    }

    private ROIData createServerROI(ROI roi, ImageData image) throws Exception {
        ROIData roiData = new ROIData();
        String ns = (String)roi.getAnnotation(AnnotationKeys.NAMESPACE);
        List<String> list = UIUtilities.CSVToList((String)roi.getAnnotation(AnnotationKeys.KEYWORDS));
        String[] kw = new String[list.size()];
        list.toArray(kw);
        roiData.setNamespaceKeywords(ns, kw);
        roiData.setClientSide(roi.isClientSide());
        if (!roi.isClientSide()) {
            roiData.setId(roi.getID());
        }
        roiData.setImage(image.asImage());
        TreeMap<Coord3D, ROIShape> shapes = roi.getShapes();
        for (ROIShape roiShape : shapes.values()) {
            ShapeData shape = this.createShapeData(roiShape);
            this.addShapeAttributes(roiShape.getFigure(), shape);
            roiData.addShapeData(shape);
        }
        return roiData;
    }

    private ShapeData createBezierFigure(ROIShape shape) throws ParsingException {
        MeasureBezierFigure fig = (MeasureBezierFigure)shape.getFigure();
        if (fig.isClosed()) {
            return this.createPolygonFigure(shape);
        }
        return this.createPolylineFigure(shape);
    }

    private EllipseData createEllipseFigure(ROIShape shape) throws ParsingException {
        AffineTransform t;
        MeasureEllipseFigure fig = (MeasureEllipseFigure)shape.getFigure();
        double rx = fig.getEllipse().getWidth() / 2.0;
        double ry = fig.getEllipse().getHeight() / 2.0;
        double cx = fig.getEllipse().getCenterX();
        double cy = fig.getEllipse().getCenterY();
        EllipseData ellipse = new EllipseData(cx, cy, rx, ry);
        String text = fig.getText();
        if (text != null && text.trim().length() > 0 && !text.equals("Text")) {
            ellipse.setText(text);
        }
        if ((t = AttributeKeys.TRANSFORM.get(fig)) != null) {
            ellipse.setTransform(OutputServerStrategy.toTransform(t));
        }
        return ellipse;
    }

    private MaskData createMaskFigure(ROIShape shape) {
        return null;
    }

    private PointData createPointFigure(ROIShape shape) throws ParsingException {
        AffineTransform t;
        MeasurePointFigure fig = (MeasurePointFigure)shape.getFigure();
        double cx = fig.getCentre().getX();
        double cy = fig.getCentre().getY();
        PointData point = new PointData(cx, cy);
        String text = fig.getText();
        if (text != null && text.trim().length() > 0 && !text.equals("Text")) {
            point.setText(fig.getText());
        }
        if ((t = AttributeKeys.TRANSFORM.get(fig)) != null) {
            point.setTransform(OutputServerStrategy.toTransform(t));
        }
        return point;
    }

    private TextData createTextFigure(ROIShape shape) throws ParsingException {
        MeasureTextFigure fig = (MeasureTextFigure)shape.getFigure();
        double x = fig.getBounds().getX();
        double y = fig.getBounds().getY();
        String text = fig.getText();
        if (text != null && text.trim().length() > 0 && text.equals("Text")) {
            text = "";
        }
        TextData data = new TextData(text, x, y);
        data.setDirty(fig.isDirty());
        data.setT(shape.getT());
        data.setZ(shape.getZ());
        AffineTransform t = AttributeKeys.TRANSFORM.get(fig);
        if (t != null) {
            data.setTransform(OutputServerStrategy.toTransform(t));
        }
        if (!fig.isClientObject()) {
            data.setId(shape.getROIShapeID());
        }
        return data;
    }

    private RectangleData createRectangleFigure(ROIShape shape) throws ParsingException {
        AffineTransform t;
        MeasureRectangleFigure fig = (MeasureRectangleFigure)shape.getFigure();
        double x = fig.getX();
        double y = fig.getY();
        double width = fig.getWidth();
        double height = fig.getHeight();
        RectangleData rectangle = new RectangleData(x, y, width, height);
        String text = fig.getText();
        if (text != null && text.trim().length() > 0 && !text.equals("Text")) {
            rectangle.setText(text);
        }
        if ((t = AttributeKeys.TRANSFORM.get(fig)) != null) {
            rectangle.setTransform(OutputServerStrategy.toTransform(t));
        }
        return rectangle;
    }

    private PolygonData createPolygonFigure(ROIShape shape) throws ParsingException {
        String text;
        MeasureBezierFigure fig = (MeasureBezierFigure)shape.getFigure();
        AffineTransform t = AttributeKeys.TRANSFORM.get(fig);
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points1 = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points2 = new LinkedList<Point2D.Double>();
        LinkedList<Integer> maskList = new LinkedList<Integer>();
        BezierPath bezier = fig.getBezierPath();
        for (BezierPath.Node node : bezier) {
            points.add(new Point2D.Double(node.x[0], node.y[0]));
            points1.add(new Point2D.Double(node.x[1], node.y[1]));
            points2.add(new Point2D.Double(node.x[2], node.y[2]));
            maskList.add(node.getMask());
        }
        PolygonData poly = new PolygonData();
        poly.setPoints(points, points1, points2, maskList);
        if (t != null) {
            poly.setTransform(OutputServerStrategy.toTransform(t));
        }
        if ((text = fig.getText()) != null && text.trim().length() > 0 && !text.equals("Text")) {
            poly.setText(text);
        }
        return poly;
    }

    private PolylineData createLineFigure(ROIShape shape) throws ParsingException {
        String text;
        MeasureLineFigure fig = (MeasureLineFigure)shape.getFigure();
        AffineTransform t = AttributeKeys.TRANSFORM.get(fig);
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points1 = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points2 = new LinkedList<Point2D.Double>();
        LinkedList<Integer> maskList = new LinkedList<Integer>();
        BezierPath bezier = fig.getBezierPath();
        for (BezierPath.Node node : bezier) {
            points.add(new Point2D.Double(node.x[0], node.y[0]));
            points1.add(new Point2D.Double(node.x[1], node.y[1]));
            points2.add(new Point2D.Double(node.x[2], node.y[2]));
            maskList.add(node.getMask());
        }
        PolylineData line = new PolylineData();
        line.setPoints(points, points1, points2, maskList);
        if (t != null) {
            line.setTransform(OutputServerStrategy.toTransform(t));
        }
        if ((text = fig.getText()) != null && text.trim().length() > 0 && !text.equals("Text")) {
            line.setText(text);
        }
        return line;
    }

    private PolylineData createPolylineFigure(ROIShape shape) throws ParsingException {
        String text;
        MeasureBezierFigure fig = (MeasureBezierFigure)shape.getFigure();
        AffineTransform t = AttributeKeys.TRANSFORM.get(fig);
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points1 = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points2 = new LinkedList<Point2D.Double>();
        LinkedList<Integer> maskList = new LinkedList<Integer>();
        BezierPath bezier = fig.getBezierPath();
        for (BezierPath.Node node : bezier) {
            points.add(new Point2D.Double(node.x[0], node.y[0]));
            points1.add(new Point2D.Double(node.x[1], node.y[1]));
            points2.add(new Point2D.Double(node.x[2], node.y[2]));
            maskList.add(node.getMask());
        }
        PolylineData poly = new PolylineData();
        poly.setPoints(points, points1, points2, maskList);
        if (t != null) {
            poly.setTransform(OutputServerStrategy.toTransform(t));
        }
        if ((text = fig.getText()) != null && text.trim().length() > 0 && !text.equals("Text")) {
            poly.setText(text);
        }
        return poly;
    }

    private void addShapeAttributes(ROIFigure fig, ShapeData shape) {
        ShapeSettingsData settings = shape.getShapeSettings();
        if (AttributeKeys.FILL_COLOR.get(fig) != null) {
            Color c = AttributeKeys.FILL_COLOR.get(fig);
            settings.setFillColor(c);
        }
        if (MeasurementAttributes.STROKE_COLOR.get(fig) != null) {
            settings.setStrokeColor((Color)MeasurementAttributes.STROKE_COLOR.get(fig));
        }
        if (MeasurementAttributes.STROKE_WIDTH.get(fig) != null) {
            settings.setStrokeWidth(((Double)MeasurementAttributes.STROKE_WIDTH.get(fig)).doubleValue());
        }
        if (MeasurementAttributes.FONT_FACE.get(fig) != null) {
            settings.setFontFamily(((Font)MeasurementAttributes.FONT_FACE.get(fig)).getName());
        } else {
            settings.setFontFamily("Courier");
        }
        if (MeasurementAttributes.FONT_SIZE.get(fig) != null) {
            settings.setFontSize(((Double)MeasurementAttributes.FONT_SIZE.get(fig)).intValue());
        } else {
            settings.setFontSize(12);
        }
        if (MeasurementAttributes.FONT_BOLD.get(fig) != null) {
            settings.setFontWeight("bold");
        } else {
            settings.setFontWeight("normal");
        }
        if (MeasurementAttributes.FONT_ITALIC.get(fig) != null) {
            settings.setFontStyle("italic");
        } else {
            settings.setFontStyle("normal");
        }
    }

    private static String toTransform(AffineTransform t) throws ParsingException {
        StringBuilder buf = new StringBuilder();
        switch (t.getType()) {
            case 0: {
                buf.append("none");
                break;
            }
            case 1: {
                buf.append("translate(");
                buf.append(OutputServerStrategy.toNumber(t.getTranslateX()));
                if (t.getTranslateY() != 0.0) {
                    buf.append(' ');
                    buf.append(OutputServerStrategy.toNumber(t.getTranslateY()));
                }
                buf.append(')');
                break;
            }
            case 2: {
                buf.append("scale(");
                buf.append(OutputServerStrategy.toNumber(t.getScaleX()));
                buf.append(')');
                break;
            }
            case 4: 
            case 6: {
                buf.append("scale(");
                buf.append(OutputServerStrategy.toNumber(t.getScaleX()));
                buf.append(' ');
                buf.append(OutputServerStrategy.toNumber(t.getScaleY()));
                buf.append(')');
                break;
            }
            default: {
                buf.append("matrix(");
                double[] matrix = new double[6];
                t.getMatrix(matrix);
                for (int i = 0; i < matrix.length; ++i) {
                    if (i != 0) {
                        buf.append(' ');
                    }
                    buf.append(OutputServerStrategy.toNumber(matrix[i]));
                }
                buf.append(')');
            }
        }
        return buf.toString();
    }

    private static String toNumber(double number) {
        String str = Double.toString(number);
        if (str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        return str;
    }

    OutputServerStrategy() {
    }

    List<ROIData> writeROI(ROIComponent component, ImageData image, long ownerID) throws Exception {
        this.component = component;
        this.ROIList = new ArrayList<ROIData>();
        this.parseROI(image, ownerID);
        return this.ROIList;
    }
}

