/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.model;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.TreeMap;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIMap;
import org.openmicroscopy.shoola.util.roi.model.ROIRelationship;
import org.openmicroscopy.shoola.util.roi.model.ROIRelationshipList;
import org.openmicroscopy.shoola.util.roi.model.ROIRelationshipMap;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ROIShapeRelationship;
import org.openmicroscopy.shoola.util.roi.model.ROIShapeRelationshipList;
import org.openmicroscopy.shoola.util.roi.model.ROIShapeRelationshipMap;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROICollection
extends Component
implements PropertyChangeListener {
    private ROIMap roiMap = new ROIMap();
    private ROIRelationshipMap roiRelationshipMap = new ROIRelationshipMap();
    private ROIShapeRelationshipMap shapeRelationshipMap = new ROIShapeRelationshipMap();
    private long lastID;

    public ROICollection() {
        this.generateInitialID();
    }

    private void generateInitialID() {
        this.lastID = 0L;
    }

    public long getNextID() {
        ++this.lastID;
        return this.lastID;
    }

    public boolean containsROI(long id) {
        return this.roiMap.containsROI(id);
    }

    public ROI createROI(long id) {
        return this.createROI(id, true);
    }

    public ROI createROI(long id, boolean clientSideObject) {
        ROI newROI = new ROI(id, clientSideObject);
        if (this.lastID < id) {
            this.lastID = id + 1L;
        }
        this.roiMap.add(newROI.getID(), newROI);
        return newROI;
    }

    public ROI createROI() {
        ROI newROI = new ROI(this.getNextID(), true);
        this.roiMap.add(newROI.getID(), newROI);
        return newROI;
    }

    public TreeMap<Long, ROI> getROIMap() {
        return this.roiMap.getROIMap();
    }

    public ROI getROI(long id) throws NoSuchROIException {
        return this.roiMap.getROI(id);
    }

    public ROIShape getShape(long id, Coord3D coord) throws NoSuchROIException {
        return this.roiMap.getShape(id, coord);
    }

    public ShapeList getShapeList(Coord3D coord) throws NoSuchROIException {
        return this.roiMap.getShapeList(coord);
    }

    public void deleteROI(long id) throws NoSuchROIException {
        this.roiMap.deleteROI(id);
    }

    public void deleteShape(long id, Coord3D coord) throws NoSuchROIException {
        this.roiMap.deleteShape(id, coord);
    }

    public void addShape(long id, Coord3D coord, ROIShape shape) throws ROICreationException, NoSuchROIException {
        this.roiMap.addShape(id, coord, shape);
    }

    public List<ROIShape> propagateShape(long id, Coord3D selectedShape, Coord3D start, Coord3D end) throws ROICreationException, NoSuchROIException {
        return this.roiMap.propagateShape(id, selectedShape, start, end);
    }

    public void deleteShape(long id, Coord3D start, Coord3D end) throws NoSuchROIException {
        this.roiMap.deleteShape(id, start, end);
    }

    public void addROIRelationship(ROIRelationship relationship) {
        this.roiRelationshipMap.add(relationship);
    }

    public void addROIShapeRelationship(ROIShapeRelationship relationship) {
        this.shapeRelationshipMap.add(relationship);
    }

    public void removeROIRelationship(long relationship) {
        this.roiRelationshipMap.remove(relationship);
    }

    public void removeROIShapeRelationship(long relationship) {
        this.shapeRelationshipMap.remove(relationship);
    }

    public boolean containsROIRelationship(long relationship) {
        return this.roiRelationshipMap.contains(relationship);
    }

    public boolean containsROIShapeRelationship(long relationship) {
        return this.shapeRelationshipMap.contains(relationship);
    }

    public ROIRelationshipList getROIRelationshipList(long roiID) {
        return this.roiRelationshipMap.getRelationshipList(roiID);
    }

    public ROIShapeRelationshipList getROIShapeRelationshipList(long roiID) {
        return this.shapeRelationshipMap.getRelationshipList(roiID);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

