/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.model;

import java.util.TreeMap;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.roi.model.util.LongComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeList {
    private TreeMap<Long, ROIShape> roiList = new TreeMap(new LongComparator());
    private Coord3D coord;

    public ShapeList(Coord3D coord) {
        this.coord = coord;
    }

    public TreeMap<Long, ROIShape> getList() {
        return this.roiList;
    }

    public Coord3D getCoord3D() {
        return this.coord;
    }

    public void add(long id, ROIShape shape) {
        this.roiList.put(id, shape);
    }

    public ROIShape getShape(long id) throws NoSuchROIException {
        if (this.roiList.containsKey(id)) {
            return this.roiList.get(id);
        }
        throw new NoSuchROIException("No such ROIShape : " + id);
    }

    public boolean containsKey(long id) {
        return this.roiList.containsKey(id);
    }

    public void deleteShape(long id) throws NoSuchROIException {
        if (!this.roiList.containsKey(id)) {
            throw new NoSuchROIException("No such ROIShape : " + id);
        }
        this.roiList.remove(id);
    }
}

