/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.openmicroscopy.shoola.util.ui.ColouredButton;
import org.openmicroscopy.shoola.util.ui.colour.HSV;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ColouredButtonUI
extends BasicButtonUI {
    private static final int MATTE = 0;
    private static final int SPEC = 1;
    private static final Stroke STROKE = new BasicStroke(1.0f);
    private static final int DEFAULT_SIZE = 32;
    private static final Insets INSETS = new Insets(3, 3, 3, 3);
    private Color colour;
    private final ColouredButton button;
    private Rectangle buttonRect;
    private HSV gradientStartHSV;
    private Color gradientStartRGB;
    private HSV gradientEndHSV;
    private Color gradientEndRGB;
    private boolean greyedOut;
    private int fontIndex;
    private boolean paintBorderInsets;
    private Painter buttonFacePainter;
    private Painter selectedButtonFacePainter;
    private Painter greyMaskPainter;
    private Painter selectedGreyMaskPainter;

    private void setGradientColours() {
        float topGradientSaturation;
        float bottomGradientSaturation;
        HSV col = new HSV(this.colour);
        float topGradientValue = col.getValue();
        float bottomGradientValue = col.getValue();
        if (col.getSaturation() == 0.0f) {
            topGradientSaturation = bottomGradientSaturation = col.getSaturation();
            topGradientValue = col.getValue() + 0.3f;
            if (col.getValue() * 1.3f > topGradientValue) {
                topGradientValue = col.getValue() * 1.3f;
            }
            if (topGradientValue > 1.0f) {
                topGradientValue = 1.0f;
            }
            bottomGradientValue = col.getValue() * 0.75f;
        } else {
            topGradientValue = col.getValue() * 1.5f;
            if (topGradientValue > 1.0f) {
                topGradientValue = 1.0f;
            }
            topGradientSaturation = col.getSaturation() * 0.6f;
            bottomGradientSaturation = col.getSaturation();
        }
        this.gradientStartHSV = new HSV(col.getHue(), topGradientSaturation, topGradientValue, 1.0f);
        this.gradientStartRGB = this.gradientStartHSV.toColorA();
        this.gradientEndHSV = new HSV(col.getHue(), bottomGradientSaturation, bottomGradientValue, 1.0f);
        this.gradientEndRGB = this.gradientEndHSV.toColorA();
    }

    private void drawText(Graphics2D g) {
        HSV col = new HSV(this.colour);
        FontMetrics fm = g.getFontMetrics();
        int x = (int)((float)this.buttonRect.width / 2.0f - (float)(fm.stringWidth(this.button.getText()) / 2));
        int y = (int)((float)this.buttonRect.height / 2.0f + (float)((fm.getHeight() - fm.getDescent()) / 2));
        if ((double)col.getValue() < 0.6 || (double)col.getHue() > 0.6 && (double)col.getSaturation() > 0.7 || this.greyedOut) {
            g.setPaint(Color.white);
        } else {
            g.setPaint(Color.black);
        }
        g.drawString(this.button.getText(), x, y);
    }

    private void drawBorder(Graphics2D g) {
        Color borderColour = this.gradientStartRGB.brighter();
        g.setPaint(borderColour);
        g.drawLine(0, 0, 0, (int)this.buttonRect.getHeight());
        g.drawLine(0, 0, (int)this.buttonRect.getWidth(), 0);
        g.drawLine(1, 1, 1, (int)this.buttonRect.getHeight() - 1);
        g.drawLine(1, 1, (int)this.buttonRect.getWidth() - 1, 1);
        borderColour = this.gradientEndRGB.darker();
        g.setPaint(borderColour);
        g.drawLine((int)this.buttonRect.getWidth() - 1, 0, (int)this.buttonRect.getWidth() - 1, (int)this.buttonRect.getHeight() - 1);
        g.drawLine(0, (int)this.buttonRect.getHeight() - 1, (int)this.buttonRect.getWidth() - 1, (int)this.buttonRect.getHeight() - 1);
        g.drawLine((int)this.buttonRect.getWidth() - 2, 2, (int)this.buttonRect.getWidth() - 2, (int)this.buttonRect.getHeight() - 2);
        g.drawLine(1, (int)this.buttonRect.getHeight() - 2, (int)this.buttonRect.getWidth() - 1, (int)this.buttonRect.getHeight() - 2);
    }

    private void drawGreyBorder(Graphics2D g) {
        HSV borderColourHSV = new HSV(0.0f, 0.0f, this.gradientStartHSV.getValue(), 0.8f);
        Color borderColour = borderColourHSV.toColorA();
        g.setPaint(borderColour);
        g.setStroke(STROKE);
        int height = (int)this.buttonRect.getHeight();
        int width = (int)this.buttonRect.getWidth();
        g.drawLine(0, 0, 0, height);
        g.drawLine(0, 0, width, 0);
        g.drawLine(1, 1, 1, height - 1);
        g.drawLine(1, 1, width - 1, 1);
        borderColourHSV = new HSV(0.0f, 0.0f, this.gradientEndHSV.getValue(), 0.8f);
        borderColour = borderColourHSV.toColorA();
        g.setPaint(borderColour.darker().darker().darker());
        g.drawLine(width - 1, 0, width - 1, height - 1);
        g.drawLine(0, height - 1, width - 1, height - 1);
        g.drawLine(width - 2, 2, width - 2, height - 2);
        g.drawLine(1, height - 2, width - 1, height - 2);
    }

    private void drawGreySelectedBorder(Graphics2D g) {
        HSV borderColourHSV = new HSV(0.0f, 0.0f, this.gradientEndHSV.getValue(), 0.8f);
        Color borderColour = borderColourHSV.toColorA();
        g.setPaint(borderColour.darker().darker().darker());
        g.setStroke(STROKE);
        int height = (int)this.buttonRect.getHeight();
        int width = (int)this.buttonRect.getWidth();
        g.drawLine(0, 0, 0, height);
        g.drawLine(0, 0, width, 0);
        g.drawLine(1, 1, 1, height - 1);
        g.drawLine(1, 1, width - 1, 1);
        borderColourHSV = new HSV(0.0f, 0.0f, this.gradientStartHSV.getValue(), 0.8f);
        borderColour = borderColourHSV.toColorA();
        g.setPaint(borderColour.darker());
        g.drawLine(width - 1, 0, width - 1, height - 1);
        g.drawLine(0, height - 1, width - 1, height - 1);
        g.drawLine(width - 2, 2, width - 2, height - 2);
        g.drawLine(1, height - 2, width - 1, height - 2);
    }

    private void drawSelectedBorder(Graphics2D g) {
        Color borderColour = this.gradientEndRGB.darker();
        HSV col = new HSV(borderColour);
        g.setPaint(col.toColorA());
        g.setStroke(STROKE);
        int height = (int)this.buttonRect.getHeight();
        int width = (int)this.buttonRect.getWidth();
        g.drawLine(0, 0, 0, height);
        g.drawLine(0, 0, width, 0);
        g.drawLine(1, 1, 1, height - 1);
        g.drawLine(1, 1, width - 1, 1);
        borderColour = this.gradientStartRGB;
        col = new HSV(borderColour);
        col.setSaturation(col.getSaturation() * 0.8f);
        borderColour = col.toColorA();
        g.setPaint(borderColour);
        g.drawLine(width - 1, 0, width - 1, (int)this.buttonRect.getHeight() - 1);
        g.drawLine(0, height - 1, width - 1, height - 1);
        g.drawLine(width - 2, 2, width - 2, height - 2);
        g.drawLine(1, width - 2, width - 1, height - 2);
    }

    private void paintSquareButton(Graphics2D g) {
        if (this.button.isSelected()) {
            if (this.button.isEnabled()) {
                if (!this.greyedOut) {
                    this.invokePainter(g, this.selectedButtonFacePainter);
                    this.drawSelectedBorder(g);
                } else {
                    this.invokePainter(g, this.selectedGreyMaskPainter);
                    this.drawGreySelectedBorder(g);
                }
            } else {
                this.invokePainter(g, this.selectedGreyMaskPainter);
                this.drawGreySelectedBorder(g);
            }
        } else if (this.button.isEnabled()) {
            if (this.greyedOut) {
                this.invokePainter(g, this.greyMaskPainter);
                this.drawGreyBorder(g);
            } else {
                this.invokePainter(g, this.buttonFacePainter);
                this.drawBorder(g);
            }
        } else {
            this.invokePainter(g, this.greyMaskPainter);
            this.drawGreyBorder(g);
        }
        this.drawText(g);
    }

    private void createPainters() {
        this.buttonFacePainter = this.getPainter(this.colour, 1);
        this.selectedButtonFacePainter = this.getPainter(this.colour, 0);
        this.greyMaskPainter = this.getPainter(Color.gray, 1);
        this.selectedGreyMaskPainter = this.getPainter(Color.gray, 0);
    }

    private Painter<JXButton> getPainter(Color colour, int spec) {
        int startX = (int)((double)this.getWidth() * 0.2);
        int startY = 6;
        int colourStartX = (int)((double)this.getWidth() * 0.3);
        int colourStartY = 18;
        int radius = (int)Math.max(18.0, (double)this.getWidth() * 0.9);
        int matteEndX = 10;
        int matteEndY = 18;
        Color c = colour.brighter();
        MattePainter gradientWhite = new MattePainter((Paint)new GradientPaint(new Point2D.Double(0.0, 0.0), c, new Point2D.Double(matteEndX, matteEndY), Color.white));
        MattePainter gradientBrighterColour = new MattePainter((Paint)new GradientPaint(new Point2D.Double(0.0, 0.0), c, new Point2D.Double(matteEndX, matteEndY), colour));
        MattePainter gradientBrighterDarker = new MattePainter((Paint)new GradientPaint(new Point2D.Double(0.0, 0.0), c, new Point2D.Double(matteEndX, matteEndY), colour.darker()));
        HSV newHSV = new HSV(colour);
        float colourAlpha = 0.5f;
        if ((double)newHSV.getHue() > 0.2777777777777778 && (double)newHSV.getHue() < 0.4166666666666667) {
            colourAlpha = 0.7f;
        }
        MattePainter gradientLight = new MattePainter((Paint)new GradientPaint(new Point2D.Double(startX, startY), new Color(1.0f, 1.0f, 1.0f, colourAlpha), new Point2D.Double(colourStartX, colourStartY), new Color(1.0f, 1.0f, 1.0f, 0.0f)));
        switch (spec) {
            case 1: {
                return new CompoundPainter(new Painter[]{gradientWhite, gradientBrighterDarker, gradientLight});
            }
            case 0: {
                return new CompoundPainter(new Painter[]{gradientWhite, gradientBrighterDarker});
            }
        }
        return null;
    }

    private void invokePainter(Graphics g, Painter painter) {
        if (painter == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        if (!this.isPaintBorderInsets()) {
            painter.paint(g2d, (Object)this, this.getWidth(), this.getHeight());
        } else {
            g2d.translate(ColouredButtonUI.INSETS.left, ColouredButtonUI.INSETS.top);
            painter.paint(g2d, (Object)this, this.getWidth() - ColouredButtonUI.INSETS.left - ColouredButtonUI.INSETS.right, this.getHeight() - ColouredButtonUI.INSETS.top - ColouredButtonUI.INSETS.bottom);
        }
    }

    ColouredButtonUI(ColouredButton b, Color c) {
        if (b == null) {
            throw new IllegalArgumentException("No button.");
        }
        if (c == null) {
            throw new IllegalArgumentException("No color.");
        }
        this.button = b;
        this.greyedOut = false;
        this.fontIndex = 0;
        this.setColor(c);
        this.uninstallListeners(b);
    }

    void setGrayedOut(boolean greyedOut) {
        this.greyedOut = greyedOut;
    }

    void setColor(Color c) {
        if (c == null) {
            throw new IllegalArgumentException("No color.");
        }
        this.colour = c;
        this.setGradientColours();
        this.createPainters();
    }

    void setDeriveFont(int fontIndex) {
        this.fontIndex = fontIndex;
    }

    @Override
    public void paint(Graphics og, JComponent comp) {
        Graphics2D g = (Graphics2D)og;
        this.buttonRect = new Rectangle(comp.getWidth(), comp.getHeight());
        this.paintSquareButton(g);
    }

    boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    void setPaintBorderInsets(boolean pb) {
        this.paintBorderInsets = pb;
    }

    protected int getWidth() {
        return Math.max(this.button.getWidth(), 32);
    }

    protected int getHeight() {
        return Math.max(this.button.getHeight(), 32);
    }
}

