/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Insets2D;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.ui.drawingtools.attributes.DrawingAttributes;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.FigureUtil;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.RotateEllipseFigure;
import org.openmicroscopy.shoola.util.ui.drawingtools.texttools.TransformedDrawingTextTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EllipseTextFigure
extends RotateEllipseFigure
implements TextHolderFigure {
    protected boolean fromTransformUpdate;
    protected boolean editable;
    private transient TextLayout textLayout;
    private Rectangle2D.Double textBounds;

    private TextLayout getTextLayout() {
        if (this.textLayout == null) {
            this.textLayout = FigureUtil.createLayout(this.getText(), this.getFontRenderContext(), this.getFont(), AttributeKeys.FONT_UNDERLINE.get(this));
        }
        return this.textLayout;
    }

    public EllipseTextFigure(String text) {
        this(text, 0.0, 0.0, 0.0, 0.0);
    }

    public EllipseTextFigure(String t, double x, double y, double w, double h) {
        super(x, y, w, h);
        this.setAttributeEnabled(AttributeKeys.TEXT_COLOR, true);
        this.setAttributeEnabled(MeasurementAttributes.HEIGHT, true);
        this.setAttributeEnabled(MeasurementAttributes.WIDTH, true);
        this.setAttribute(MeasurementAttributes.WIDTH, w);
        this.setAttribute(MeasurementAttributes.HEIGHT, h);
        this.setText(t);
        this.textLayout = null;
        this.textBounds = null;
        this.editable = true;
        this.fromTransformUpdate = false;
    }

    @Override
    public void setAttribute(AttributeKey key, Object newValue) {
        super.setAttribute(key, newValue);
    }

    @Override
    public void transform(AffineTransform tx) {
        super.transform(tx);
        this.fromTransformUpdate = true;
        MeasurementAttributes.HEIGHT.set(this, Double.valueOf(this.getTransformedEllipse().getBounds2D().getHeight()));
        MeasurementAttributes.WIDTH.set(this, Double.valueOf(this.getTransformedEllipse().getBounds2D().getWidth()));
        this.fromTransformUpdate = false;
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        super.setBounds(anchor, lead);
        this.fromTransformUpdate = true;
        Rectangle2D r = this.getTransformedEllipse().getBounds2D();
        MeasurementAttributes.HEIGHT.set(this, Double.valueOf(r.getHeight()));
        MeasurementAttributes.WIDTH.set(this, Double.valueOf(r.getWidth()));
        this.fromTransformUpdate = false;
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            TransformHandleKit.addTransformHandles(this, handles);
        }
        return handles;
    }

    protected Rectangle2D.Double getTextBounds() {
        if (this.textBounds == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        return this.textBounds;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    @Override
    public Tool getTool(Point2D.Double p) {
        if (this.isEditable() && this.contains(p)) {
            this.invalidate();
            return new TransformedDrawingTextTool(this, this.getTransformedShape());
        }
        return null;
    }

    @Override
    protected void drawFill(Graphics2D g) {
        super.drawFill(g);
        this.drawText(g);
    }

    @Override
    protected void drawText(Graphics2D g) {
        if (!((Boolean)MeasurementAttributes.SHOWTEXT.get(this)).booleanValue()) {
            return;
        }
        String text = this.getText();
        if (text != null) {
            text = text.trim();
            TextLayout layout = this.getTextLayout();
            FontMetrics fm = g.getFontMetrics(AttributeKeys.FONT_FACE.get(this));
            double textWidth = fm.stringWidth(text);
            double textHeight = fm.getAscent();
            Rectangle r = this.getTransformedShape().getBounds();
            double x = r.getCenterX() - textWidth / 2.0;
            double y = r.getCenterY();
            Font font = AttributeKeys.FONT_FACE.get(this);
            Font viewFont = font.deriveFont(AttributeKeys.FONT_SIZE.get(this).intValue());
            g.setFont(viewFont);
            g.setColor(AttributeKeys.TEXT_COLOR.get(this));
            this.textBounds = new Rectangle2D.Double(x, y, textWidth, textHeight);
            layout.draw(g, (float)this.textBounds.x, (float)this.textBounds.y);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.textLayout = null;
    }

    @Override
    protected void validate() {
        super.validate();
        this.textLayout = null;
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = super.getDrawingArea();
        r.add(this.getTextBounds());
        return r;
    }

    @Override
    public String getText() {
        return (String)this.getAttribute(AttributeKeys.TEXT);
    }

    @Override
    public void setText(String newText) {
        this.setAttribute(DrawingAttributes.SHOWTEXT, true);
        this.setAttribute(AttributeKeys.TEXT, newText);
    }

    @Override
    public int getTextColumns() {
        String t = this.getText();
        int n = 4;
        return t == null ? n : Math.max(t.length(), n);
    }

    @Override
    public int getTabSize() {
        return 8;
    }

    @Override
    public TextHolderFigure getLabelFor() {
        return this;
    }

    @Override
    public Insets2D.Double getInsets() {
        return new Insets2D.Double();
    }

    @Override
    public Font getFont() {
        return AttributeKeys.getFont(this);
    }

    @Override
    public Color getTextColor() {
        return AttributeKeys.TEXT_COLOR.get(this);
    }

    @Override
    public Color getFillColor() {
        return AttributeKeys.FILL_COLOR.get(this);
    }

    @Override
    public float getFontSize() {
        return AttributeKeys.FONT_SIZE.get(this).floatValue();
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setFontSize(float size) {
    }

    @Override
    public boolean isTextOverflow() {
        return false;
    }

    @Override
    public EllipseTextFigure clone() {
        EllipseTextFigure that = (EllipseTextFigure)super.clone();
        that.setText(this.getText());
        return that;
    }
}

