/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLJPanel;
import javax.media.opengl.glu.GLU;
import org.openmicroscopy.shoola.util.ui.lens.LensModel;

class ZoomPanel
extends GLJPanel
implements GLEventListener {
    private static GLCapabilities CAPS = new GLCapabilities();
    protected GLU glu;
    protected Texture texture;
    private LensModel model;

    ZoomPanel(LensModel model) {
        super(CAPS, null, null);
        this.model = model;
        this.setOpaque(true);
        this.glu = new GLU();
        this.addGLEventListener(this);
    }

    public void display(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        gl.glClear(16640);
        TextureData data = this.model.getImageAsTexture();
        if (data == null) {
            return;
        }
        if (this.texture == null) {
            this.texture = TextureIO.newTexture((TextureData)data);
        } else {
            this.texture.updateImage(data);
        }
        this.texture.enable();
        this.texture.bind();
        gl.glTexEnvi(8960, 8704, 7681);
        float w = this.model.getImageWidth();
        float h = this.model.getImageHeight();
        float xStart = (float)this.model.getX() / w;
        float xEnd = ((float)this.model.getX() + (float)this.model.getWidth()) / w;
        float yStart = (float)this.model.getY() / h;
        float yEnd = ((float)this.model.getY() + (float)this.model.getHeight()) / h;
        TextureCoords coords = new TextureCoords(xStart, yEnd, xEnd, yStart);
        gl.glBegin(7);
        gl.glTexCoord2f(coords.left(), coords.bottom());
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glTexCoord2f(coords.right(), coords.bottom());
        gl.glVertex3d(1.0, 0.0, 0.0);
        gl.glTexCoord2f(coords.right(), coords.top());
        gl.glVertex3f(1.0f, 1.0f, 0.0f);
        gl.glTexCoord2f(coords.left(), coords.top());
        gl.glVertex3f(0.0f, 1.0f, 0.0f);
        gl.glEnd();
        this.texture.disable();
        gl.glFlush();
    }

    public void init(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glEnable(2929);
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL gl = drawable.getGL();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.glu.gluOrtho2D(0.0, 1.0, 0.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    public void dispose(GLAutoDrawable drawable) {
    }

    public void displayChanged(GLAutoDrawable drawable, boolean a, boolean b) {
    }

    static {
        CAPS.setAlphaBits(8);
    }
}

