/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.login;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.util.StringComparator;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.login.LoginCredentials;
import org.openmicroscopy.shoola.util.ui.login.ServerDialog;
import org.openmicroscopy.shoola.util.ui.login.ServerEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenLogin
extends JFrame
implements ActionListener,
DocumentListener,
PropertyChangeListener {
    public static final String TO_FRONT_PROPERTY = "toFront";
    public static final String LOGIN_PROPERTY = "login";
    public static final String QUIT_PROPERTY = "quit";
    public static final int USERNAME_FIELD = 0;
    public static final int PASSWORD_FIELD = 1;
    public static final String DEFAULT_SERVER = "Add a new server ->";
    static final Color TEXT_COLOR = Color.WHITE;
    static final Dimension DEFAULT_SIZE = new Dimension(551, 113);
    private static final Color FOREGROUND_COLOR = Color.DARK_GRAY;
    private static final String OMERO_USER = "omeroUser";
    private static final String OMERO_CONNECTION_SPEED = "omeroConnectionSpeed";
    private static final String OMERO_USER_GROUP = "omeroUserGroup";
    private static final String OMERO_TRANSFER_ENCRYPTED = "omeroTransferEncrypted";
    private static final float VERSION_FONT_SIZE = 14.0f;
    private static final int VERSION_FONT_STYLE = 1;
    private static final int TEXT_FONT_SIZE = 16;
    private static final String TEXT_LOGIN = "Log In";
    private static final String GROUP_TEXT = "Group: ";
    private static final String USER_TEXT = "Username: ";
    private static final String PASSWORD_TEXT = "Password: ";
    private static final int TEXT_COLUMN = 12;
    private JTextField user;
    private JPasswordField pass;
    private JButton configButton;
    private JButton login;
    private JButton cancel;
    private String serverName;
    private JTextPane serverText;
    private JPanel serverTextPane;
    private JLabel connectionSpeedText;
    private JTextPane versionInfo;
    private ServerEditor editor;
    private int speedIndex;
    private int selectedPort = -1;
    private boolean connectionSpeed;
    private Color defaultForeground;
    private JComboBox groupsBox;
    private JTextPane pleaseLogIn;
    private Map<Long, String> groups;
    private String originalName;
    private String originalServerName;
    private List<JComponent> ref;
    private JPanel mainPanel;
    private String[] groupValues;
    private JButton encryptedButton;
    private boolean encrypted;

    private void quit() {
        String usr = this.user.getText().trim();
        String server = this.serverText.getText();
        if (usr == null) {
            usr = "";
        }
        if (server == null) {
            server = "";
        }
        if (!server.equals(this.originalServerName) || !usr.equals(this.originalName)) {
            ScreenLogin.registerGroup(null);
        }
        this.firePropertyChange(QUIT_PROPERTY, (Object)false, (Object)true);
    }

    private void login() {
        LoginCredentials lc;
        this.firePropertyChange(TO_FRONT_PROPERTY, (Object)false, (Object)true);
        this.requestFocusOnField();
        StringBuffer buf = new StringBuffer();
        buf.append(this.pass.getPassword());
        String usr = this.user.getText().trim();
        String psw = buf.toString();
        String s = this.serverText.getText();
        if (usr == null || usr.length() == 0 || psw == null || psw.length() == 0 || s == null || s.trim().length() == 0 || s.trim().equals(DEFAULT_SERVER)) {
            this.requestFocusOnField();
            return;
        }
        if (usr != null) {
            usr = usr.trim();
        }
        if (s != null) {
            s = s.trim();
        }
        this.setControlsEnabled(false);
        if (this.groupsBox == null) {
            lc = new LoginCredentials(usr, psw, s, this.speedIndex, this.selectedPort, this.encrypted);
        } else {
            long id = -1L;
            if (this.hasGroupOption() && this.groupsBox.isVisible()) {
                id = this.getGroupId((String)this.groupsBox.getSelectedItem());
            }
            lc = new LoginCredentials(usr, psw, s, this.speedIndex, this.selectedPort, id, this.encrypted);
        }
        this.setUserName(usr);
        this.setEncrypted();
        this.setControlsEnabled(false);
        this.firePropertyChange(LOGIN_PROPERTY, null, lc);
    }

    private Long getGroupId(String value) {
        for (Map.Entry<Long, String> entry : this.groups.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return -1L;
    }

    private void groupSelection(Component invoker, Point p) {
    }

    private boolean hasGroupOption() {
        String usr = this.user.getText().trim();
        String s = this.serverText.getText().trim();
        return usr.equals(this.originalName) && s.equals(this.originalServerName);
    }

    private void config() {
        String s = this.serverText.getText().trim();
        ServerDialog d = this.connectionSpeed ? new ServerDialog(this, this.editor, s, this.speedIndex) : new ServerDialog(this, this.editor, s);
        d.addPropertyChangeListener(this);
        UIUtilities.centerAndShow(d);
    }

    private void encrypt() {
        this.encrypted = !this.encrypted;
        IconManager icons = IconManager.getInstance();
        if (this.encrypted) {
            this.encryptedButton.setIcon(icons.getIcon(138));
        } else {
            this.encryptedButton.setIcon(icons.getIcon(139));
        }
    }

    private void initListeners() {
        this.user.getDocument().addDocumentListener(this);
        this.pass.getDocument().addDocumentListener(this);
        this.login.addActionListener(this);
        this.user.addActionListener(this);
        this.pass.addActionListener(this);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScreenLogin.this.quit();
            }
        });
        this.configButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScreenLogin.this.config();
            }
        });
        this.encryptedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScreenLogin.this.encrypt();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                ScreenLogin.this.requestFocusOnField();
            }
        });
        this.user.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (ScreenLogin.this.user.getText() != null) {
                    ScreenLogin.this.user.selectAll();
                }
            }

            public void mouseClicked(MouseEvent e) {
                ScreenLogin.this.firePropertyChange(ScreenLogin.TO_FRONT_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                ScreenLogin.this.user.requestFocus();
                if (ScreenLogin.this.user.getText() != null) {
                    ScreenLogin.this.user.selectAll();
                }
            }
        });
        this.pass.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ScreenLogin.this.firePropertyChange(ScreenLogin.TO_FRONT_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            }
        });
    }

    private void setButtonDefault(JButton button) {
        button.setRolloverEnabled(false);
        button.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void initialize(String userName, String hostName) {
        String value;
        int k;
        Iterator<Object> i;
        int n;
        this.originalName = userName;
        this.user = new JTextField();
        this.user.setText(userName);
        this.user.setToolTipText("Enter your username.");
        this.user.setColumns(12);
        this.pass = new JPasswordField();
        this.pass.setToolTipText("Enter your password.");
        this.pass.setColumns(12);
        Map<String, String> servers = this.editor.getServers();
        if (hostName != null && hostName.trim().length() > 0) {
            this.serverName = hostName;
            if (servers != null && servers.size() > 0) {
                n = servers.size() - 1;
                i = servers.keySet().iterator();
                k = 0;
                while (i.hasNext()) {
                    this.serverName = i.next();
                    if (k == n && (value = servers.get(this.serverName)) != null) {
                        try {
                            this.selectedPort = Integer.parseInt(value);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ++k;
                }
            } else {
                this.editor.removeLastRow();
                this.editor.addRow(hostName);
            }
        } else if (servers == null || servers.size() == 0) {
            this.serverName = DEFAULT_SERVER;
        } else {
            n = servers.size() - 1;
            i = servers.keySet().iterator();
            k = 0;
            while (i.hasNext()) {
                this.serverName = i.next();
                if (k == n && (value = servers.get(this.serverName)) != null) {
                    try {
                        this.selectedPort = Integer.parseInt(value);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++k;
            }
        }
        if (!DEFAULT_SERVER.equals(this.serverName)) {
            this.originalServerName = this.serverName;
        }
        this.connectionSpeedText = new JLabel(this.getConnectionSpeed());
        this.connectionSpeedText.setForeground(TEXT_COLOR);
        this.connectionSpeedText.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.serverText = UIUtilities.buildTextPane(this.serverName, TEXT_COLOR);
        this.serverTextPane = UIUtilities.buildComponentPanelRight(this.serverText, false);
        this.serverTextPane.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.groups = this.getGroups();
        if (this.groups != null && this.groups.size() > 1) {
            this.groupValues = new String[this.groups.size()];
            i = this.groups.entrySet().iterator();
            int index = 0;
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                this.groupValues[index] = (String)entry.getValue();
                ++index;
            }
            String selectedGroup = this.groupValues[this.groupValues.length - 1];
            Arrays.sort(this.groupValues, new StringComparator());
            this.groupsBox = new JComboBox<String>(this.groupValues);
            this.groupsBox.setSelectedItem(selectedGroup);
        }
        this.ref = new ArrayList<JComponent>();
        this.login = new JButton("Login");
        this.defaultForeground = this.login.getForeground();
        this.login.setMnemonic('L');
        this.login.setToolTipText("Login");
        this.setButtonDefault(this.login);
        UIUtilities.enterPressesWhenFocused(this.login);
        UIUtilities.opacityCheck(this.login);
        this.cancel = new JButton("Quit");
        this.cancel.setMnemonic('Q');
        this.cancel.setToolTipText("Quit the Application.");
        this.setButtonDefault(this.cancel);
        UIUtilities.opacityCheck(this.cancel);
        this.configButton = new JButton();
        this.configButton.setMnemonic('X');
        this.configButton.setToolTipText("Enter the server's address.");
        this.configButton.setBorderPainted(false);
        this.configButton.setBorder(null);
        this.configButton.setFocusPainted(false);
        this.configButton.setContentAreaFilled(false);
        IconManager icons = IconManager.getInstance();
        this.configButton.setIcon(icons.getIcon(25));
        this.encrypted = !this.isEncrypted();
        this.encryptedButton = new JButton();
        ArrayList<String> tips = new ArrayList<String>();
        tips.add("The connexion to the server is always encrypted.");
        tips.add("If selected, the data transfer (e.g. annotations, images) will also be encrypted.");
        tips.add("But the transfer will be much slower.");
        this.encryptedButton.setToolTipText(UIUtilities.formatToolTipText(tips));
        this.encryptedButton.setBorderPainted(false);
        this.encryptedButton.setBorder(null);
        this.encryptedButton.setFocusPainted(false);
        this.encryptedButton.setContentAreaFilled(false);
        if (this.encrypted) {
            this.encryptedButton.setIcon(icons.getIcon(138));
        } else {
            this.encryptedButton.setIcon(icons.getIcon(139));
        }
        this.getRootPane().setDefaultButton(this.login);
        this.enableControls();
    }

    private void layout(boolean group) {
        if (this.mainPanel == null) {
            return;
        }
        if (this.ref == null) {
            return;
        }
        Iterator<JComponent> i = this.ref.iterator();
        boolean visible = false;
        if (group && this.groups != null && this.groupsBox != null) {
            visible = true;
        }
        while (i.hasNext()) {
            i.next().setVisible(visible);
        }
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    private JPanel buildMainPanel(String version) {
        this.mainPanel = new JPanel();
        int g = 10;
        int t = 10;
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(t, g, t, g));
        this.mainPanel.setOpaque(false);
        double[][] size = new double[][]{{-2.0, -1.0, -2.0, -1.0, -1.0, -2.0}, {-2.0, -2.0, -2.0, -2.0}};
        TableLayout layout = new TableLayout((double[][])size);
        this.mainPanel.setLayout((LayoutManager)layout);
        this.pleaseLogIn = UIUtilities.buildTextPane(TEXT_LOGIN, TEXT_COLOR);
        Font f = this.pleaseLogIn.getFont();
        this.pleaseLogIn.setFont(f.deriveFont(1, 16.0f));
        this.mainPanel.add((Component)this.pleaseLogIn, "0, 0, LEFT, CENTER");
        this.versionInfo = UIUtilities.buildTextPane(version, TEXT_COLOR);
        f = this.versionInfo.getFont();
        this.versionInfo.setFont(f.deriveFont(1, 14.0f));
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.serverTextPane);
        p.add(this.connectionSpeedText);
        this.mainPanel.add((Component)UIUtilities.buildComponentPanelRight(p, 0, 0, false), "0, 0, 4, 0");
        JToolBar bar = new JToolBar();
        bar.setOpaque(false);
        bar.setBorder(null);
        bar.setFloatable(false);
        bar.add(this.encryptedButton);
        bar.add(this.configButton);
        this.mainPanel.add((Component)bar, "5, 0, LEFT, TOP");
        JTextPane l = UIUtilities.buildTextPane(GROUP_TEXT, TEXT_COLOR);
        this.mainPanel.add((Component)l, "0, 1, LEFT, CENTER");
        this.ref.add(l);
        if (this.groupsBox != null) {
            JPanel gp = UIUtilities.buildComponentPanel(this.groupsBox, 0, 0);
            gp.setBorder(null);
            gp.setOpaque(false);
            this.mainPanel.add((Component)gp, "1, 1, 5, 1");
            this.ref.add(this.groupsBox);
        }
        l = UIUtilities.buildTextPane(USER_TEXT, TEXT_COLOR);
        this.mainPanel.add((Component)l, "0, 2, LEFT, CENTER");
        this.mainPanel.add((Component)this.user, "1, 2, 2, 2");
        l = UIUtilities.buildTextPane(" Password: ", TEXT_COLOR);
        this.mainPanel.add((Component)l, "3, 2, RIGHT, CENTER");
        this.mainPanel.add((Component)this.pass, "4, 2, 5, 2");
        JPanel cPanel = new JPanel();
        cPanel.setOpaque(false);
        cPanel.add(Box.createHorizontalGlue());
        cPanel.add(this.login);
        cPanel.add(this.cancel);
        double[][] s = new double[][]{{-1.0, -2.0}, {-2.0}};
        p = new JPanel();
        p.setOpaque(false);
        p.setLayout((LayoutManager)new TableLayout((double[][])s));
        p.add((Component)this.versionInfo, "0, 0, LEFT, CENTER");
        p.add((Component)UIUtilities.buildComponentPanelRight(cPanel, 0, 0, false), "1, 0, RIGHT, CENTER");
        this.mainPanel.add((Component)p, "0, 3, 5, 3");
        this.layout(this.groups != null);
        return this.mainPanel;
    }

    private void buildGUI(Icon logo, String version) {
        int height;
        int width;
        JLabel background;
        JLayeredPane layers = new JLayeredPane();
        if (logo != null) {
            background = new JLabel(logo);
            width = logo.getIconWidth();
            height = logo.getIconHeight();
        } else {
            background = new JLabel();
            width = ScreenLogin.DEFAULT_SIZE.width;
            height = ScreenLogin.DEFAULT_SIZE.height;
        }
        background.setBorder(BorderFactory.createEmptyBorder());
        layers.setBounds(0, 0, width, height);
        JPanel p = this.buildMainPanel(version);
        background.setBounds(0, 0, width, height);
        p.setBounds(0, 0, width, height);
        layers.add((Component)background, new Integer(0));
        layers.add((Component)p, new Integer(1));
        this.getContentPane().add(layers);
    }

    private String getServerName() {
        String s = this.serverText.getText();
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    private String getConnectionSpeed() {
        switch (this.speedIndex) {
            case 0: {
                return " [LAN]";
            }
            case 1: {
                return " [High]";
            }
            case 2: {
                return " [Low]";
            }
        }
        return null;
    }

    private void setNewServer(String s) {
        if (s == null || s.length() == 0) {
            s = DEFAULT_SERVER;
        }
        String[] values = s.split(":", 0);
        s = values[0];
        if (values.length == 2) {
            try {
                this.selectedPort = Integer.parseInt(values[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.serverText.setText(s);
        this.serverTextPane.validate();
        this.serverTextPane.repaint();
        this.enableControls();
    }

    private void enableControls() {
        boolean enabled = true;
        String s = this.serverText.getText();
        char[] name = this.pass.getPassword();
        String usr = this.user.getText().trim();
        usr = usr.trim();
        if (s == null || usr == null || name == null) {
            enabled = false;
        } else {
            s = s.trim();
            if (this.login != null) {
                if (DEFAULT_SERVER.equals(s)) {
                    enabled = false;
                } else if (usr.length() == 0 || name.length == 0) {
                    enabled = false;
                }
            }
        }
        if (enabled) {
            ActionListener[] listeners = this.login.getActionListeners();
            if (listeners != null) {
                boolean set = false;
                for (int i = 0; i < listeners.length; ++i) {
                    if (listeners[i] != this) continue;
                    set = true;
                    break;
                }
                if (!set) {
                    this.login.addActionListener(this);
                }
            }
            this.login.setForeground(this.defaultForeground);
        } else {
            this.login.setForeground(FOREGROUND_COLOR);
        }
        this.layout(this.hasGroupOption());
    }

    private void setConnectionSpeed(int speed) {
        this.speedIndex = speed;
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        prefs.put(OMERO_CONNECTION_SPEED, "" + this.speedIndex);
    }

    private int retrieveConnectionSpeed() {
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        String s = prefs.get(OMERO_CONNECTION_SPEED, null);
        if (s == null || s.trim().length() == 0) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    private void setUserName(String name) {
        if (name == null) {
            return;
        }
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        prefs.put(OMERO_USER, name);
    }

    private String getUserName() {
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        return prefs.get(OMERO_USER, null);
    }

    private boolean isEncrypted() {
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        String value = prefs.get(OMERO_TRANSFER_ENCRYPTED, null);
        if (value == null || value.trim().length() == 0) {
            return false;
        }
        if (value.equals("true")) {
            return true;
        }
        return false;
    }

    private void setEncrypted() {
        String value = "false";
        if (this.encrypted) {
            value = "true";
        }
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        prefs.put(OMERO_TRANSFER_ENCRYPTED, value);
    }

    private Map<Long, String> getGroups() {
        LinkedHashMap<Long, String> groups = new LinkedHashMap<Long, String>();
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        String list = prefs.get(OMERO_USER_GROUP, null);
        if (list == null || list.length() == 0) {
            return groups;
        }
        String[] l = list.split(",", 0);
        if (l == null) {
            return groups;
        }
        for (int index = 0; index < l.length; ++index) {
            String[] values;
            String group = l[index].trim();
            if (group.length() <= 0 || (values = group.split(":", 0)).length <= 1) continue;
            String name = values[1];
            try {
                long id = Long.parseLong(values[0]);
                groups.put(id, name);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return groups;
    }

    private void setProperties(Image frameIcon) {
        this.setIconImage(frameIcon);
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setUndecorated(true);
        this.toFront();
    }

    public ScreenLogin(String title, Icon logo, Image frameIcon, String version, String defaultPort, String hostName) {
        this.setTitle(title);
        Dimension d = logo != null ? new Dimension(logo.getIconWidth(), logo.getIconHeight()) : DEFAULT_SIZE;
        this.setSize(d);
        this.setPreferredSize(d);
        this.editor = new ServerEditor(defaultPort);
        this.editor.addPropertyChangeListener("remove", this);
        this.speedIndex = this.retrieveConnectionSpeed();
        this.initialize(this.getUserName(), hostName);
        this.initListeners();
        this.buildGUI(logo, version);
        this.encrypt();
        this.setProperties(frameIcon);
        this.showConnectionSpeed(false);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ScreenLogin.this.firePropertyChange(ScreenLogin.TO_FRONT_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                ScreenLogin.this.requestFocusOnField();
            }
        });
    }

    public ScreenLogin(String title, Icon logo, Image frameIcon, String version, String defaultPort) {
        this(title, logo, frameIcon, version, defaultPort, null);
    }

    public ScreenLogin(String title, Icon logo, Image frameIcon) {
        this(title, logo, frameIcon, null, null);
    }

    public ScreenLogin(Icon logo, Image frameIcon, String version) {
        this(null, logo, frameIcon, version, null);
    }

    public ScreenLogin(Icon logo, Image frameIcon) {
        this(null, logo, frameIcon, null, null);
    }

    public void showConnectionSpeed(boolean connectionSpeed) {
        this.connectionSpeed = connectionSpeed;
        this.connectionSpeedText.setVisible(connectionSpeed);
    }

    public void setControlsEnabled(boolean b) {
        this.user.setEnabled(b);
        this.pass.setEnabled(b);
        this.enableControls();
        this.login.requestFocus();
        this.configButton.setEnabled(b);
        this.encryptedButton.setEnabled(b);
        if (this.groupsBox != null) {
            this.groupsBox.setEnabled(b);
        }
        if (b) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setButtonDefault(this.login);
            this.setButtonDefault(this.cancel);
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.login.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void cleanFields() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.user.setText("");
        this.pass.setText("");
    }

    public void cleanField(int fieldID) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        switch (fieldID) {
            case 0: {
                this.user.setText("");
                break;
            }
            case 1: {
                this.pass.setText("");
                break;
            }
            default: {
                this.cleanFields();
            }
        }
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void requestFocusOnField() {
        this.setControlsEnabled(true);
        String txt = this.user.getText();
        if (txt == null || txt.trim().length() == 0) {
            this.user.requestFocus();
        } else {
            this.pass.requestFocus();
        }
    }

    public void setQuitButtonText(String text) {
        if (text == null) {
            return;
        }
        if ((text = text.trim()).length() == 0) {
            return;
        }
        if (text.equals(this.cancel.getText())) {
            return;
        }
        this.cancel.setText(text);
        char c = text.toUpperCase().charAt(0);
        this.setQuitButtonMnemonic(c);
    }

    public void setQuitButtonToolTipText(String toolTipText) {
        this.cancel.setToolTipText(toolTipText);
    }

    public void setQuitButtonMnemonic(int mnemonic) {
        this.cancel.setMnemonic(mnemonic);
    }

    public static void registerGroup(Map<Long, String> groups) {
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        if (groups == null) {
            prefs.put(OMERO_USER_GROUP, "");
            return;
        }
        Iterator<Map.Entry<Long, String>> i = groups.entrySet().iterator();
        int n = groups.size() - 1;
        int index = 0;
        String list = "";
        while (i.hasNext()) {
            Map.Entry<Long, String> entry = i.next();
            Long id = entry.getKey();
            list = list + "" + id;
            list = list + ":";
            if (entry.getValue() != null) {
                list = list + entry.getValue();
            }
            if (index != n) {
                list = list + ",";
            }
            ++index;
        }
        if (list.length() != 0) {
            prefs.put(OMERO_USER_GROUP, "");
            prefs.put(OMERO_USER_GROUP, list);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("server".equals(name)) {
            String v = this.getServerName();
            String s = (String)evt.getNewValue();
            if (s == null) {
                this.setNewServer(null);
                return;
            }
            String trim = s.trim();
            if (v.equals(trim)) {
                return;
            }
            this.setNewServer(trim);
        } else if ("remove".equals(name)) {
            this.requestFocusOnField();
            String v = this.getServerName();
            String oldValue = (String)evt.getOldValue();
            if (v.equals(oldValue)) {
                this.setNewServer((String)evt.getNewValue());
            }
        } else if ("connectionSpeed".endsWith(name)) {
            this.setConnectionSpeed((Integer)evt.getNewValue());
            this.connectionSpeedText.setText(this.getConnectionSpeed());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.enableControls();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.enableControls();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.login();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    static /* synthetic */ void access$000(ScreenLogin x0) {
        x0.quit();
    }

    static /* synthetic */ void access$100(ScreenLogin x0) {
        x0.config();
    }

    static /* synthetic */ void access$200(ScreenLogin x0) {
        x0.encrypt();
    }

    static /* synthetic */ JTextField access$300(ScreenLogin x0) {
        return x0.user;
    }

    static /* synthetic */ void access$400(ScreenLogin x0, String x1, Object x2, Object x3) {
        x0.firePropertyChange(x1, x2, x3);
    }

    static /* synthetic */ void access$500(ScreenLogin x0, String x1, Object x2, Object x3) {
        x0.firePropertyChange(x1, x2, x3);
    }

    static /* synthetic */ void access$600(ScreenLogin x0, String x1, Object x2, Object x3) {
        x0.firePropertyChange(x1, x2, x3);
    }
}

