/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.omeeditpane;

public class WikiDataObject {
    public static final int PROJECT = 0;
    public static final int DATASET = 1;
    public static final int IMAGE = 2;
    public static final int THUMBNAIL = 3;
    public static final int PROTOCOL = 4;
    public static final int URL = 5;
    public static final int OTHER = 6;
    private int index;
    private long id;
    private String name;
    private String group;
    private String regex;
    private String matchedText;

    private void checkIndex(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    WikiDataObject(String regex, String group, String matchedText) {
        this.regex = regex;
        this.group = group;
        this.matchedText = matchedText;
        this.index = 6;
    }

    WikiDataObject(int index, long id) {
        this.checkIndex(index);
        this.index = index;
        this.id = id;
    }

    WikiDataObject(int index, String name) {
        this.checkIndex(index);
        this.index = index;
        this.name = name;
        this.id = -1L;
    }

    public int getIndex() {
        if (this.index != 6) {
            return this.index;
        }
        if (this.regex != null) {
            if (this.regex.contains("Image")) {
                this.index = 2;
            } else if (this.regex.contains("Project")) {
                this.index = 0;
            } else if (this.regex.contains("Dataset")) {
                this.index = 1;
            } else if (this.regex.contains("http") || this.regex.contains("www")) {
                this.index = 5;
            }
        }
        return this.index;
    }

    public long getId() {
        if (this.id > 0L) {
            return this.id;
        }
        try {
            this.id = new Long(this.group);
        }
        catch (Exception e) {
            this.id = -1L;
        }
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getMatchedText() {
        return this.matchedText;
    }
}

