/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.enums.handler;

import java.util.HashMap;
import ome.formats.enums.EnumerationException;
import ome.formats.enums.handler.EnumerationHandler;
import ome.formats.enums.handler.PatternSet;
import omero.model.Correction;
import omero.model.IObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CorrectionEnumHandler
implements EnumerationHandler {
    static final Class<? extends IObject> HANDLER_FOR = Correction.class;
    private static final PatternSet[] searchPatterns = new PatternSet[]{new PatternSet("^\\s*Pl.*Apo.*$", "PlanApo"), new PatternSet("^\\s*Pl.*Flu.*$", "PlanFluor"), new PatternSet("^\\s*Sup.*Flu.*$", "SuperFluor"), new PatternSet("^\\s*Vio.*Corr.*$", "VioletCorrected"), new PatternSet("^\\s*Achr.*Flu.*$", "Achromat"), new PatternSet("^\\s*Neo.*flu.*$", "Neofluar"), new PatternSet("^\\s*Apo.*$", "Apo")};

    CorrectionEnumHandler() {
    }

    @Override
    public IObject findEnumeration(HashMap<String, IObject> enumerations, String value) {
        for (PatternSet x : searchPatterns) {
            if (!x.pattern.matcher(value).matches()) continue;
            IObject enumeration = enumerations.get(x.value);
            if (enumeration == null) {
                throw new EnumerationException(String.format("Matched value %s with regex %s. Could not find resulting value in enumerations.", x.pattern.pattern(), x.value), HANDLER_FOR, value);
            }
            return enumeration;
        }
        return null;
    }
}

