/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.gui.GuiCommonElements;
import omero.model.Screen;

public class AddScreenDialog
extends JDialog
implements ActionListener {
    private boolean debug = false;
    private Window owner;
    private JPanel mainPanel;
    private JPanel internalPanel;
    private JTextPane instructions;
    private String message;
    private JButton OKBtn;
    private JButton cancelBtn;
    private JTextField nameField;
    private JTextArea descriptionArea;
    private String screenName;
    private String screenDescription;
    private Screen screen;
    private ImportConfig config;
    OMEROMetadataStoreClient store;

    AddScreenDialog(ImportConfig config, Window owner, String title, Boolean modal, OMEROMetadataStoreClient store) {
        this.config = config;
        this.store = store;
        this.owner = owner;
        this.setDefaultCloseOperation(2);
        this.setTitle(title);
        this.setModal(modal);
        this.setResizable(true);
        this.setSize(new Dimension(480, 300));
        this.setLocationRelativeTo(owner);
        double[][] mainTable = new double[][]{{-1.0, 100.0, 5.0, 100.0, 10.0}, {-1.0, 40.0}};
        this.mainPanel = GuiCommonElements.addMainPanel(this, mainTable, 10, 10, 10, 10, this.debug);
        this.cancelBtn = GuiCommonElements.addButton(this.mainPanel, "Cancel", 67, "Cancel adding a screen", "1, 1, f, c", this.debug);
        this.cancelBtn.addActionListener(this);
        this.OKBtn = GuiCommonElements.addButton(this.mainPanel, "OK", 79, "Accept your new screen", "3, 1, f, c", this.debug);
        this.OKBtn.addActionListener(this);
        this.OKBtn.setEnabled(false);
        this.getRootPane().setDefaultButton(this.OKBtn);
        GuiCommonElements.enterPressesWhenFocused(this.OKBtn);
        double[][] internalTable = new double[][]{{160.0, -1.0}, {30.0, 30.0, -1.0}};
        this.internalPanel = GuiCommonElements.addMainPanel(this, internalTable, 10, 10, 10, 10, this.debug);
        this.message = "Please enter your screen name and an optional description below.";
        this.instructions = GuiCommonElements.addTextPane(this.internalPanel, this.message, "0,0,1,0", this.debug);
        this.nameField = GuiCommonElements.addTextField(this.internalPanel, "Screen Name: ", "", 69, "Input your screen name here.", "", -2.0, "0, 1, 1, 1", this.debug);
        this.nameField.getDocument().addDocumentListener(new MyDocumentListener());
        this.descriptionArea = GuiCommonElements.addScrollingTextArea(this.internalPanel, "Description: (optional)", "", 87, "0, 2, 1, 2", this.debug);
        this.mainPanel.add((Component)this.internalPanel, "0, 0, 4, 0");
        this.add((Component)this.mainPanel, "Center");
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.OKBtn) {
            this.screenName = this.nameField.getText();
            this.screenDescription = this.descriptionArea.getText();
            if (this.screenName.length() > 255) {
                JOptionPane.showMessageDialog(this, "The screen's name can not be longer than 255 characters.");
            } else if (this.screenName.trim().length() > 0) {
                this.screen = this.store.addScreen(this.screenName, this.screenDescription);
                this.config.savedScreen.set(this.screen.getId().getValue());
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this, "The screen's name can not be blank.");
            }
        }
        if (source == this.cancelBtn) {
            this.dispose();
        }
    }

    public static void main(String[] args) throws Exception {
        String laf = UIManager.getSystemLookAndFeelClassName();
        if (laf.equals("apple.laf.AquaLookAndFeel")) {
            System.setProperty("Quaqua.design", "panther");
            try {
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            }
            catch (Exception e) {
                System.err.println(laf + " not supported.");
            }
        } else {
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                System.err.println(laf + " not supported.");
            }
        }
        new AddScreenDialog(null, null, "Add a Screen", true, null);
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            if (AddScreenDialog.this.nameField.getText().trim().length() < 1) {
                AddScreenDialog.this.OKBtn.setEnabled(false);
            } else {
                AddScreenDialog.this.OKBtn.setEnabled(true);
            }
        }

        public void removeUpdate(DocumentEvent e) {
            if (AddScreenDialog.this.nameField.getText().trim().length() < 1) {
                AddScreenDialog.this.OKBtn.setEnabled(false);
            } else {
                AddScreenDialog.this.OKBtn.setEnabled(true);
            }
        }
    }
}

