/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.util.List;
import ome.formats.Index;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.ModelException;
import ome.formats.model.ModelProcessor;
import ome.util.LSID;
import omero.metadatastore.IObjectContainer;
import omero.model.PlaneInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlaneInfoProcessor
implements ModelProcessor {
    private Log log = LogFactory.getLog(PlaneInfoProcessor.class);

    public void process(IObjectContainerStore store) throws ModelException {
        List<IObjectContainer> containers = store.getIObjectContainers(PlaneInfo.class);
        for (IObjectContainer container : containers) {
            PlaneInfo pi = (PlaneInfo)container.sourceObject;
            if (pi.getDeltaT() != null || pi.getExposureTime() != null || pi.getPositionX() != null || pi.getPositionY() != null || pi.getPositionZ() != null) continue;
            LSID lsid = new LSID(PlaneInfo.class, new int[]{(Integer)container.indexes.get(Index.IMAGE_INDEX.getValue()), (Integer)container.indexes.get(Index.PLANE_INDEX.getValue())});
            this.log.debug((Object)("Removing empty PlaneInfo: " + lsid));
            store.removeIObjectContainer(lsid);
        }
    }
}

