/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.Annotation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LongAnnotation
extends Annotation {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SA/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(LongAnnotation.class);
    private Long value;

    public LongAnnotation() {
    }

    public LongAnnotation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Value_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"LongAnnotation".equals(tagName)) {
            LOGGER.debug("Expecting node name of LongAnnotation got {}", (Object)tagName);
        }
        if ((Value_nodeList = LongAnnotation.getChildrenByTagName(element, "Value")).size() > 1) {
            throw new RuntimeException(String.format("Value node list size %d != 1", Value_nodeList.size()));
        }
        if (Value_nodeList.size() != 0) {
            this.setValue(Long.valueOf(Value_nodeList.get(0).getTextContent()));
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public Long getValue() {
        return this.value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element LongAnnotation_element) {
        if (LongAnnotation_element == null) {
            LongAnnotation_element = document.createElementNS(NAMESPACE, "LongAnnotation");
        }
        if (this.value != null) {
            Element value_element = document.createElementNS(NAMESPACE, "Value");
            value_element.setTextContent(this.value.toString());
            LongAnnotation_element.appendChild(value_element);
        }
        return super.asXMLElement(document, LongAnnotation_element);
    }
}

