/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.FillRule;
import ome.xml.model.enums.FontFamily;
import ome.xml.model.enums.FontStyle;
import ome.xml.model.enums.LineCap;
import ome.xml.model.enums.Marker;
import ome.xml.model.primitives.NonNegativeInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Shape
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/ROI/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Shape.class);
    private String strokeDashArray;
    private Double strokeWidth;
    private FillRule fillRule;
    private LineCap lineCap;
    private NonNegativeInteger theC;
    private NonNegativeInteger theT;
    private String transform;
    private String label;
    private FontFamily fontFamily;
    private Integer stroke;
    private FontStyle fontStyle;
    private Marker markerEnd;
    private NonNegativeInteger theZ;
    private NonNegativeInteger fontSize;
    private String id;
    private Integer fill;
    private Marker markerStart;
    private String name;
    private String description;

    public Shape() {
    }

    public Shape(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        List<Element> Text_nodeList;
        List<Element> Path_nodeList;
        List<Element> Polyline_nodeList;
        List<Element> Point_nodeList;
        List<Element> Ellipse_nodeList;
        List<Element> Mask_nodeList;
        List<Element> Rectangle_nodeList;
        List<Element> Line_nodeList;
        super.update(element, model);
        if (element.hasAttribute("StrokeDashArray")) {
            this.setStrokeDashArray(String.valueOf(element.getAttribute("StrokeDashArray")));
        }
        if (element.hasAttribute("StrokeWidth")) {
            this.setStrokeWidth(Double.valueOf(element.getAttribute("StrokeWidth")));
        }
        if (element.hasAttribute("FillRule")) {
            this.setFillRule(FillRule.fromString(element.getAttribute("FillRule")));
        }
        if (element.hasAttribute("LineCap")) {
            this.setLineCap(LineCap.fromString(element.getAttribute("LineCap")));
        }
        if (element.hasAttribute("TheC")) {
            this.setTheC(NonNegativeInteger.valueOf(element.getAttribute("TheC")));
        }
        if (element.hasAttribute("TheT")) {
            this.setTheT(NonNegativeInteger.valueOf(element.getAttribute("TheT")));
        }
        if (element.hasAttribute("Transform")) {
            this.setTransform(String.valueOf(element.getAttribute("Transform")));
        }
        if (element.hasAttribute("Label")) {
            this.setLabel(String.valueOf(element.getAttribute("Label")));
        }
        if (element.hasAttribute("FontFamily")) {
            this.setFontFamily(FontFamily.fromString(element.getAttribute("FontFamily")));
        }
        if (element.hasAttribute("Stroke")) {
            this.setStroke(Integer.valueOf(element.getAttribute("Stroke")));
        }
        if (element.hasAttribute("FontStyle")) {
            this.setFontStyle(FontStyle.fromString(element.getAttribute("FontStyle")));
        }
        if (element.hasAttribute("MarkerEnd")) {
            this.setMarkerEnd(Marker.fromString(element.getAttribute("MarkerEnd")));
        }
        if (element.hasAttribute("TheZ")) {
            this.setTheZ(NonNegativeInteger.valueOf(element.getAttribute("TheZ")));
        }
        if (element.hasAttribute("FontSize")) {
            this.setFontSize(NonNegativeInteger.valueOf(element.getAttribute("FontSize")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Shape missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Fill")) {
            this.setFill(Integer.valueOf(element.getAttribute("Fill")));
        }
        if (element.hasAttribute("MarkerStart")) {
            this.setMarkerStart(Marker.fromString(element.getAttribute("MarkerStart")));
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if ((Line_nodeList = Shape.getChildrenByTagName(element, "Line")).size() > 1) {
            throw new RuntimeException(String.format("Line node list size %d != 1", Line_nodeList.size()));
        }
        if (Line_nodeList.size() != 0) {
            // empty if block
        }
        if ((Rectangle_nodeList = Shape.getChildrenByTagName(element, "Rectangle")).size() > 1) {
            throw new RuntimeException(String.format("Rectangle node list size %d != 1", Rectangle_nodeList.size()));
        }
        if (Rectangle_nodeList.size() != 0) {
            // empty if block
        }
        if ((Mask_nodeList = Shape.getChildrenByTagName(element, "Mask")).size() > 1) {
            throw new RuntimeException(String.format("Mask node list size %d != 1", Mask_nodeList.size()));
        }
        if (Mask_nodeList.size() != 0) {
            // empty if block
        }
        if ((Ellipse_nodeList = Shape.getChildrenByTagName(element, "Ellipse")).size() > 1) {
            throw new RuntimeException(String.format("Ellipse node list size %d != 1", Ellipse_nodeList.size()));
        }
        if (Ellipse_nodeList.size() != 0) {
            // empty if block
        }
        if ((Point_nodeList = Shape.getChildrenByTagName(element, "Point")).size() > 1) {
            throw new RuntimeException(String.format("Point node list size %d != 1", Point_nodeList.size()));
        }
        if (Point_nodeList.size() != 0) {
            // empty if block
        }
        if ((Polyline_nodeList = Shape.getChildrenByTagName(element, "Polyline")).size() > 1) {
            throw new RuntimeException(String.format("Polyline node list size %d != 1", Polyline_nodeList.size()));
        }
        if (Polyline_nodeList.size() != 0) {
            // empty if block
        }
        if ((Path_nodeList = Shape.getChildrenByTagName(element, "Path")).size() > 1) {
            throw new RuntimeException(String.format("Path node list size %d != 1", Path_nodeList.size()));
        }
        if (Path_nodeList.size() != 0) {
            // empty if block
        }
        if ((Text_nodeList = Shape.getChildrenByTagName(element, "Text")).size() > 1) {
            throw new RuntimeException(String.format("Text node list size %d != 1", Text_nodeList.size()));
        }
        if (Text_nodeList.size() != 0) {
            // empty if block
        }
        if ((Description_nodeList = Shape.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getStrokeDashArray() {
        return this.strokeDashArray;
    }

    public void setStrokeDashArray(String strokeDashArray) {
        this.strokeDashArray = strokeDashArray;
    }

    public Double getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(Double strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public FillRule getFillRule() {
        return this.fillRule;
    }

    public void setFillRule(FillRule fillRule) {
        this.fillRule = fillRule;
    }

    public LineCap getLineCap() {
        return this.lineCap;
    }

    public void setLineCap(LineCap lineCap) {
        this.lineCap = lineCap;
    }

    public NonNegativeInteger getTheC() {
        return this.theC;
    }

    public void setTheC(NonNegativeInteger theC) {
        this.theC = theC;
    }

    public NonNegativeInteger getTheT() {
        return this.theT;
    }

    public void setTheT(NonNegativeInteger theT) {
        this.theT = theT;
    }

    public String getTransform() {
        return this.transform;
    }

    public void setTransform(String transform) {
        this.transform = transform;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public FontFamily getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(FontFamily fontFamily) {
        this.fontFamily = fontFamily;
    }

    public Integer getStroke() {
        return this.stroke;
    }

    public void setStroke(Integer stroke) {
        this.stroke = stroke;
    }

    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    public Marker getMarkerEnd() {
        return this.markerEnd;
    }

    public void setMarkerEnd(Marker markerEnd) {
        this.markerEnd = markerEnd;
    }

    public NonNegativeInteger getTheZ() {
        return this.theZ;
    }

    public void setTheZ(NonNegativeInteger theZ) {
        this.theZ = theZ;
    }

    public NonNegativeInteger getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(NonNegativeInteger fontSize) {
        this.fontSize = fontSize;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Integer getFill() {
        return this.fill;
    }

    public void setFill(Integer fill) {
        this.fill = fill;
    }

    public Marker getMarkerStart() {
        return this.markerStart;
    }

    public void setMarkerStart(Marker markerStart) {
        this.markerStart = markerStart;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected Element asXMLElement(Document document, Element Shape_element) {
        if (!"Shape".equals(Shape_element.getTagName())) {
            Element abstractElement = document.createElementNS(NAMESPACE, "Shape");
            abstractElement.appendChild(Shape_element);
            Shape_element = abstractElement;
        }
        if (Shape_element == null) {
            Shape_element = document.createElementNS(NAMESPACE, "Shape");
        }
        if (this.strokeDashArray != null) {
            Shape_element.setAttribute("StrokeDashArray", this.strokeDashArray.toString());
        }
        if (this.strokeWidth != null) {
            Shape_element.setAttribute("StrokeWidth", this.strokeWidth.toString());
        }
        if (this.fillRule != null) {
            Shape_element.setAttribute("FillRule", this.fillRule.toString());
        }
        if (this.lineCap != null) {
            Shape_element.setAttribute("LineCap", this.lineCap.toString());
        }
        if (this.theC != null) {
            Shape_element.setAttribute("TheC", this.theC.toString());
        }
        if (this.theT != null) {
            Shape_element.setAttribute("TheT", this.theT.toString());
        }
        if (this.transform != null) {
            Shape_element.setAttribute("Transform", this.transform.toString());
        }
        if (this.label != null) {
            Shape_element.setAttribute("Label", this.label.toString());
        }
        if (this.fontFamily != null) {
            Shape_element.setAttribute("FontFamily", this.fontFamily.toString());
        }
        if (this.stroke != null) {
            Shape_element.setAttribute("Stroke", this.stroke.toString());
        }
        if (this.fontStyle != null) {
            Shape_element.setAttribute("FontStyle", this.fontStyle.toString());
        }
        if (this.markerEnd != null) {
            Shape_element.setAttribute("MarkerEnd", this.markerEnd.toString());
        }
        if (this.theZ != null) {
            Shape_element.setAttribute("TheZ", this.theZ.toString());
        }
        if (this.fontSize != null) {
            Shape_element.setAttribute("FontSize", this.fontSize.toString());
        }
        if (this.id != null) {
            Shape_element.setAttribute("ID", this.id.toString());
        }
        if (this.fill != null) {
            Shape_element.setAttribute("Fill", this.fill.toString());
        }
        if (this.markerStart != null) {
            Shape_element.setAttribute("MarkerStart", this.markerStart.toString());
        }
        if (this.name != null) {
            Shape_element.setAttribute("Name", this.name.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            Shape_element.appendChild(description_element);
        }
        return super.asXMLElement(document, Shape_element);
    }
}

