/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.BooleanAnnotation;
import ome.xml.model.CommentAnnotation;
import ome.xml.model.DoubleAnnotation;
import ome.xml.model.FileAnnotation;
import ome.xml.model.ListAnnotation;
import ome.xml.model.LongAnnotation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.TagAnnotation;
import ome.xml.model.TermAnnotation;
import ome.xml.model.TimestampAnnotation;
import ome.xml.model.XMLAnnotation;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuredAnnotations
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SA/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(StructuredAnnotations.class);
    private List<XMLAnnotation> xmlannotationList = new ArrayList<XMLAnnotation>();
    private List<FileAnnotation> fileAnnotationList = new ArrayList<FileAnnotation>();
    private List<ListAnnotation> listAnnotationList = new ArrayList<ListAnnotation>();
    private List<LongAnnotation> longAnnotationList = new ArrayList<LongAnnotation>();
    private List<DoubleAnnotation> doubleAnnotationList = new ArrayList<DoubleAnnotation>();
    private List<CommentAnnotation> commentAnnotationList = new ArrayList<CommentAnnotation>();
    private List<BooleanAnnotation> booleanAnnotationList = new ArrayList<BooleanAnnotation>();
    private List<TimestampAnnotation> timestampAnnotationList = new ArrayList<TimestampAnnotation>();
    private List<TagAnnotation> tagAnnotationList = new ArrayList<TagAnnotation>();
    private List<TermAnnotation> termAnnotationList = new ArrayList<TermAnnotation>();

    public StructuredAnnotations() {
    }

    public StructuredAnnotations(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"StructuredAnnotations".equals(tagName)) {
            LOGGER.debug("Expecting node name of StructuredAnnotations got {}", (Object)tagName);
        }
        List<Element> XMLAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "XMLAnnotation");
        for (Element XMLAnnotation_element : XMLAnnotation_nodeList) {
            this.addXMLAnnotation(new XMLAnnotation(XMLAnnotation_element, model));
        }
        List<Element> FileAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "FileAnnotation");
        for (Element FileAnnotation_element : FileAnnotation_nodeList) {
            this.addFileAnnotation(new FileAnnotation(FileAnnotation_element, model));
        }
        List<Element> ListAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "ListAnnotation");
        for (Element ListAnnotation_element : ListAnnotation_nodeList) {
            this.addListAnnotation(new ListAnnotation(ListAnnotation_element, model));
        }
        List<Element> LongAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "LongAnnotation");
        for (Element LongAnnotation_element : LongAnnotation_nodeList) {
            this.addLongAnnotation(new LongAnnotation(LongAnnotation_element, model));
        }
        List<Element> DoubleAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "DoubleAnnotation");
        for (Element DoubleAnnotation_element : DoubleAnnotation_nodeList) {
            this.addDoubleAnnotation(new DoubleAnnotation(DoubleAnnotation_element, model));
        }
        List<Element> CommentAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "CommentAnnotation");
        for (Element CommentAnnotation_element : CommentAnnotation_nodeList) {
            this.addCommentAnnotation(new CommentAnnotation(CommentAnnotation_element, model));
        }
        List<Element> BooleanAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "BooleanAnnotation");
        for (Element BooleanAnnotation_element : BooleanAnnotation_nodeList) {
            this.addBooleanAnnotation(new BooleanAnnotation(BooleanAnnotation_element, model));
        }
        List<Element> TimestampAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "TimestampAnnotation");
        for (Element TimestampAnnotation_element : TimestampAnnotation_nodeList) {
            this.addTimestampAnnotation(new TimestampAnnotation(TimestampAnnotation_element, model));
        }
        List<Element> TagAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "TagAnnotation");
        for (Element TagAnnotation_element : TagAnnotation_nodeList) {
            this.addTagAnnotation(new TagAnnotation(TagAnnotation_element, model));
        }
        List<Element> TermAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "TermAnnotation");
        for (Element TermAnnotation_element : TermAnnotation_nodeList) {
            this.addTermAnnotation(new TermAnnotation(TermAnnotation_element, model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public int sizeOfXMLAnnotationList() {
        return this.xmlannotationList.size();
    }

    public List<XMLAnnotation> copyXMLAnnotationList() {
        return new ArrayList<XMLAnnotation>(this.xmlannotationList);
    }

    public XMLAnnotation getXMLAnnotation(int index) {
        return this.xmlannotationList.get(index);
    }

    public XMLAnnotation setXMLAnnotation(int index, XMLAnnotation xmlannotation) {
        return this.xmlannotationList.set(index, xmlannotation);
    }

    public void addXMLAnnotation(XMLAnnotation xmlannotation) {
        this.xmlannotationList.add(xmlannotation);
    }

    public void removeXMLAnnotation(XMLAnnotation xmlannotation) {
        this.xmlannotationList.remove(xmlannotation);
    }

    public int sizeOfFileAnnotationList() {
        return this.fileAnnotationList.size();
    }

    public List<FileAnnotation> copyFileAnnotationList() {
        return new ArrayList<FileAnnotation>(this.fileAnnotationList);
    }

    public FileAnnotation getFileAnnotation(int index) {
        return this.fileAnnotationList.get(index);
    }

    public FileAnnotation setFileAnnotation(int index, FileAnnotation fileAnnotation) {
        return this.fileAnnotationList.set(index, fileAnnotation);
    }

    public void addFileAnnotation(FileAnnotation fileAnnotation) {
        this.fileAnnotationList.add(fileAnnotation);
    }

    public void removeFileAnnotation(FileAnnotation fileAnnotation) {
        this.fileAnnotationList.remove(fileAnnotation);
    }

    public int sizeOfListAnnotationList() {
        return this.listAnnotationList.size();
    }

    public List<ListAnnotation> copyListAnnotationList() {
        return new ArrayList<ListAnnotation>(this.listAnnotationList);
    }

    public ListAnnotation getListAnnotation(int index) {
        return this.listAnnotationList.get(index);
    }

    public ListAnnotation setListAnnotation(int index, ListAnnotation listAnnotation) {
        return this.listAnnotationList.set(index, listAnnotation);
    }

    public void addListAnnotation(ListAnnotation listAnnotation) {
        this.listAnnotationList.add(listAnnotation);
    }

    public void removeListAnnotation(ListAnnotation listAnnotation) {
        this.listAnnotationList.remove(listAnnotation);
    }

    public int sizeOfLongAnnotationList() {
        return this.longAnnotationList.size();
    }

    public List<LongAnnotation> copyLongAnnotationList() {
        return new ArrayList<LongAnnotation>(this.longAnnotationList);
    }

    public LongAnnotation getLongAnnotation(int index) {
        return this.longAnnotationList.get(index);
    }

    public LongAnnotation setLongAnnotation(int index, LongAnnotation longAnnotation) {
        return this.longAnnotationList.set(index, longAnnotation);
    }

    public void addLongAnnotation(LongAnnotation longAnnotation) {
        this.longAnnotationList.add(longAnnotation);
    }

    public void removeLongAnnotation(LongAnnotation longAnnotation) {
        this.longAnnotationList.remove(longAnnotation);
    }

    public int sizeOfDoubleAnnotationList() {
        return this.doubleAnnotationList.size();
    }

    public List<DoubleAnnotation> copyDoubleAnnotationList() {
        return new ArrayList<DoubleAnnotation>(this.doubleAnnotationList);
    }

    public DoubleAnnotation getDoubleAnnotation(int index) {
        return this.doubleAnnotationList.get(index);
    }

    public DoubleAnnotation setDoubleAnnotation(int index, DoubleAnnotation doubleAnnotation) {
        return this.doubleAnnotationList.set(index, doubleAnnotation);
    }

    public void addDoubleAnnotation(DoubleAnnotation doubleAnnotation) {
        this.doubleAnnotationList.add(doubleAnnotation);
    }

    public void removeDoubleAnnotation(DoubleAnnotation doubleAnnotation) {
        this.doubleAnnotationList.remove(doubleAnnotation);
    }

    public int sizeOfCommentAnnotationList() {
        return this.commentAnnotationList.size();
    }

    public List<CommentAnnotation> copyCommentAnnotationList() {
        return new ArrayList<CommentAnnotation>(this.commentAnnotationList);
    }

    public CommentAnnotation getCommentAnnotation(int index) {
        return this.commentAnnotationList.get(index);
    }

    public CommentAnnotation setCommentAnnotation(int index, CommentAnnotation commentAnnotation) {
        return this.commentAnnotationList.set(index, commentAnnotation);
    }

    public void addCommentAnnotation(CommentAnnotation commentAnnotation) {
        this.commentAnnotationList.add(commentAnnotation);
    }

    public void removeCommentAnnotation(CommentAnnotation commentAnnotation) {
        this.commentAnnotationList.remove(commentAnnotation);
    }

    public int sizeOfBooleanAnnotationList() {
        return this.booleanAnnotationList.size();
    }

    public List<BooleanAnnotation> copyBooleanAnnotationList() {
        return new ArrayList<BooleanAnnotation>(this.booleanAnnotationList);
    }

    public BooleanAnnotation getBooleanAnnotation(int index) {
        return this.booleanAnnotationList.get(index);
    }

    public BooleanAnnotation setBooleanAnnotation(int index, BooleanAnnotation booleanAnnotation) {
        return this.booleanAnnotationList.set(index, booleanAnnotation);
    }

    public void addBooleanAnnotation(BooleanAnnotation booleanAnnotation) {
        this.booleanAnnotationList.add(booleanAnnotation);
    }

    public void removeBooleanAnnotation(BooleanAnnotation booleanAnnotation) {
        this.booleanAnnotationList.remove(booleanAnnotation);
    }

    public int sizeOfTimestampAnnotationList() {
        return this.timestampAnnotationList.size();
    }

    public List<TimestampAnnotation> copyTimestampAnnotationList() {
        return new ArrayList<TimestampAnnotation>(this.timestampAnnotationList);
    }

    public TimestampAnnotation getTimestampAnnotation(int index) {
        return this.timestampAnnotationList.get(index);
    }

    public TimestampAnnotation setTimestampAnnotation(int index, TimestampAnnotation timestampAnnotation) {
        return this.timestampAnnotationList.set(index, timestampAnnotation);
    }

    public void addTimestampAnnotation(TimestampAnnotation timestampAnnotation) {
        this.timestampAnnotationList.add(timestampAnnotation);
    }

    public void removeTimestampAnnotation(TimestampAnnotation timestampAnnotation) {
        this.timestampAnnotationList.remove(timestampAnnotation);
    }

    public int sizeOfTagAnnotationList() {
        return this.tagAnnotationList.size();
    }

    public List<TagAnnotation> copyTagAnnotationList() {
        return new ArrayList<TagAnnotation>(this.tagAnnotationList);
    }

    public TagAnnotation getTagAnnotation(int index) {
        return this.tagAnnotationList.get(index);
    }

    public TagAnnotation setTagAnnotation(int index, TagAnnotation tagAnnotation) {
        return this.tagAnnotationList.set(index, tagAnnotation);
    }

    public void addTagAnnotation(TagAnnotation tagAnnotation) {
        this.tagAnnotationList.add(tagAnnotation);
    }

    public void removeTagAnnotation(TagAnnotation tagAnnotation) {
        this.tagAnnotationList.remove(tagAnnotation);
    }

    public int sizeOfTermAnnotationList() {
        return this.termAnnotationList.size();
    }

    public List<TermAnnotation> copyTermAnnotationList() {
        return new ArrayList<TermAnnotation>(this.termAnnotationList);
    }

    public TermAnnotation getTermAnnotation(int index) {
        return this.termAnnotationList.get(index);
    }

    public TermAnnotation setTermAnnotation(int index, TermAnnotation termAnnotation) {
        return this.termAnnotationList.set(index, termAnnotation);
    }

    public void addTermAnnotation(TermAnnotation termAnnotation) {
        this.termAnnotationList.add(termAnnotation);
    }

    public void removeTermAnnotation(TermAnnotation termAnnotation) {
        this.termAnnotationList.remove(termAnnotation);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element StructuredAnnotations_element) {
        if (StructuredAnnotations_element == null) {
            StructuredAnnotations_element = document.createElementNS(NAMESPACE, "StructuredAnnotations");
        }
        if (this.xmlannotationList != null) {
            for (XMLAnnotation xmlannotationList_value : this.xmlannotationList) {
                StructuredAnnotations_element.appendChild(xmlannotationList_value.asXMLElement(document));
            }
        }
        if (this.fileAnnotationList != null) {
            for (FileAnnotation fileAnnotationList_value : this.fileAnnotationList) {
                StructuredAnnotations_element.appendChild(fileAnnotationList_value.asXMLElement(document));
            }
        }
        if (this.listAnnotationList != null) {
            for (ListAnnotation listAnnotationList_value : this.listAnnotationList) {
                StructuredAnnotations_element.appendChild(listAnnotationList_value.asXMLElement(document));
            }
        }
        if (this.longAnnotationList != null) {
            for (LongAnnotation longAnnotationList_value : this.longAnnotationList) {
                StructuredAnnotations_element.appendChild(longAnnotationList_value.asXMLElement(document));
            }
        }
        if (this.doubleAnnotationList != null) {
            for (DoubleAnnotation doubleAnnotationList_value : this.doubleAnnotationList) {
                StructuredAnnotations_element.appendChild(doubleAnnotationList_value.asXMLElement(document));
            }
        }
        if (this.commentAnnotationList != null) {
            for (CommentAnnotation commentAnnotationList_value : this.commentAnnotationList) {
                StructuredAnnotations_element.appendChild(commentAnnotationList_value.asXMLElement(document));
            }
        }
        if (this.booleanAnnotationList != null) {
            for (BooleanAnnotation booleanAnnotationList_value : this.booleanAnnotationList) {
                StructuredAnnotations_element.appendChild(booleanAnnotationList_value.asXMLElement(document));
            }
        }
        if (this.timestampAnnotationList != null) {
            for (TimestampAnnotation timestampAnnotationList_value : this.timestampAnnotationList) {
                StructuredAnnotations_element.appendChild(timestampAnnotationList_value.asXMLElement(document));
            }
        }
        if (this.tagAnnotationList != null) {
            for (TagAnnotation tagAnnotationList_value : this.tagAnnotationList) {
                StructuredAnnotations_element.appendChild(tagAnnotationList_value.asXMLElement(document));
            }
        }
        if (this.termAnnotationList != null) {
            for (TermAnnotation termAnnotationList_value : this.termAnnotationList) {
                StructuredAnnotations_element.appendChild(termAnnotationList_value.asXMLElement(document));
            }
        }
        return super.asXMLElement(document, StructuredAnnotations_element);
    }
}

