/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import loci.common.Location;
import loci.common.StreamHandle;

public class ZipHandle
extends StreamHandle {
    private ZipFile zip;
    private ZipEntry entry;

    public ZipHandle(String file) throws IOException {
        this.zip = new ZipFile(file);
        String innerFile = file.substring(0, file.length() - 4);
        int slash = innerFile.lastIndexOf(File.separator);
        if (slash < 0) {
            slash = innerFile.lastIndexOf("/");
        }
        if (slash >= 0) {
            innerFile = innerFile.substring(slash + 1);
        }
        this.entry = null;
        Enumeration<? extends ZipEntry> e = this.zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            if (!ze.getName().startsWith(innerFile)) continue;
            this.entry = ze;
            break;
        }
        if (this.entry == null) {
            this.entry = this.zip.entries().nextElement();
        }
        this.length = this.entry.getSize();
        this.resetStream();
    }

    public ZipHandle(String file, ZipEntry entry) throws IOException {
        this.zip = new ZipFile(file);
        this.entry = entry;
        this.length = entry.getSize();
        this.resetStream();
    }

    public static boolean isZipFile(String file) throws IOException {
        if (!file.toLowerCase().endsWith(".zip")) {
            return false;
        }
        FileInputStream f = new FileInputStream(file);
        byte[] b = new byte[2];
        f.read(b);
        f.close();
        return new String(b).equals("PK");
    }

    public String getEntryName() {
        return this.entry.getName();
    }

    public DataInputStream getInputStream() {
        return this.stream;
    }

    public int getEntryCount() {
        return this.zip.size();
    }

    public void close() throws IOException {
        if (!Location.getIdMap().containsValue(this)) {
            super.close();
            this.zip = null;
            this.entry = null;
        }
    }

    protected void resetStream() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        this.stream = new DataInputStream(new BufferedInputStream(this.zip.getInputStream(this.entry), 0x100000));
    }
}

