/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Dataset;
import ome.xml.model.DatasetRef;
import ome.xml.model.Experiment;
import ome.xml.model.ExperimentRef;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterRef;
import ome.xml.model.Group;
import ome.xml.model.GroupRef;
import ome.xml.model.ImagingEnvironment;
import ome.xml.model.Instrument;
import ome.xml.model.InstrumentRef;
import ome.xml.model.MicrobeamManipulation;
import ome.xml.model.MicrobeamManipulationRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.ObjectiveSettings;
import ome.xml.model.Pixels;
import ome.xml.model.ROI;
import ome.xml.model.ROIRef;
import ome.xml.model.Reference;
import ome.xml.model.StageLabel;
import ome.xml.model.WellSample;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Image
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Image.class);
    private String id;
    private String name;
    private String acquiredDate;
    private Experimenter experimenter;
    private String description;
    private Experiment experiment;
    private Group group;
    private List<Dataset> datasetList = new ArrayList<Dataset>();
    private Instrument instrument;
    private ObjectiveSettings objectiveSettings;
    private ImagingEnvironment imagingEnvironment;
    private StageLabel stageLabel;
    private Pixels pixels;
    private List<ROI> roiList = new ArrayList<ROI>();
    private List<MicrobeamManipulation> microbeamManipulationList = new ArrayList<MicrobeamManipulation>();
    private List<Annotation> annotationList = new ArrayList<Annotation>();
    private List<WellSample> wellSample_BackReferenceList = new ArrayList<WellSample>();

    public Image() {
    }

    public Image(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Pixels_nodeList;
        List<Element> StageLabel_nodeList;
        List<Element> ImagingEnvironment_nodeList;
        List<Element> AcquiredDate_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Image".equals(tagName)) {
            LOGGER.debug("Expecting node name of Image got {}", (Object)tagName);
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Image missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if ((AcquiredDate_nodeList = Image.getChildrenByTagName(element, "AcquiredDate")).size() > 1) {
            throw new RuntimeException(String.format("AcquiredDate node list size %d != 1", AcquiredDate_nodeList.size()));
        }
        if (AcquiredDate_nodeList.size() != 0) {
            this.setAcquiredDate(String.valueOf(AcquiredDate_nodeList.get(0).getTextContent()));
        }
        List<Element> ExperimenterRef_nodeList = Image.getChildrenByTagName(element, "ExperimenterRef");
        for (Element ExperimenterRef_element : ExperimenterRef_nodeList) {
            ExperimenterRef experimenter_reference = new ExperimenterRef();
            experimenter_reference.setID(ExperimenterRef_element.getAttribute("ID"));
            model.addReference(this, experimenter_reference);
        }
        List<Element> Description_nodeList = Image.getChildrenByTagName(element, "Description");
        if (Description_nodeList.size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> ExperimentRef_nodeList = Image.getChildrenByTagName(element, "ExperimentRef");
        for (Element ExperimentRef_element : ExperimentRef_nodeList) {
            ExperimentRef experiment_reference = new ExperimentRef();
            experiment_reference.setID(ExperimentRef_element.getAttribute("ID"));
            model.addReference(this, experiment_reference);
        }
        List<Element> GroupRef_nodeList = Image.getChildrenByTagName(element, "GroupRef");
        for (Element GroupRef_element : GroupRef_nodeList) {
            GroupRef group_reference = new GroupRef();
            group_reference.setID(GroupRef_element.getAttribute("ID"));
            model.addReference(this, group_reference);
        }
        List<Element> DatasetRef_nodeList = Image.getChildrenByTagName(element, "DatasetRef");
        for (Element DatasetRef_element : DatasetRef_nodeList) {
            DatasetRef datasetList_reference = new DatasetRef();
            datasetList_reference.setID(DatasetRef_element.getAttribute("ID"));
            model.addReference(this, datasetList_reference);
        }
        List<Element> InstrumentRef_nodeList = Image.getChildrenByTagName(element, "InstrumentRef");
        for (Element InstrumentRef_element : InstrumentRef_nodeList) {
            InstrumentRef instrument_reference = new InstrumentRef();
            instrument_reference.setID(InstrumentRef_element.getAttribute("ID"));
            model.addReference(this, instrument_reference);
        }
        List<Element> ObjectiveSettings_nodeList = Image.getChildrenByTagName(element, "ObjectiveSettings");
        if (ObjectiveSettings_nodeList.size() > 1) {
            throw new RuntimeException(String.format("ObjectiveSettings node list size %d != 1", ObjectiveSettings_nodeList.size()));
        }
        if (ObjectiveSettings_nodeList.size() != 0) {
            this.setObjectiveSettings(new ObjectiveSettings(ObjectiveSettings_nodeList.get(0), model));
        }
        if ((ImagingEnvironment_nodeList = Image.getChildrenByTagName(element, "ImagingEnvironment")).size() > 1) {
            throw new RuntimeException(String.format("ImagingEnvironment node list size %d != 1", ImagingEnvironment_nodeList.size()));
        }
        if (ImagingEnvironment_nodeList.size() != 0) {
            this.setImagingEnvironment(new ImagingEnvironment(ImagingEnvironment_nodeList.get(0), model));
        }
        if ((StageLabel_nodeList = Image.getChildrenByTagName(element, "StageLabel")).size() > 1) {
            throw new RuntimeException(String.format("StageLabel node list size %d != 1", StageLabel_nodeList.size()));
        }
        if (StageLabel_nodeList.size() != 0) {
            this.setStageLabel(new StageLabel(StageLabel_nodeList.get(0), model));
        }
        if ((Pixels_nodeList = Image.getChildrenByTagName(element, "Pixels")).size() > 1) {
            throw new RuntimeException(String.format("Pixels node list size %d != 1", Pixels_nodeList.size()));
        }
        if (Pixels_nodeList.size() != 0) {
            this.setPixels(new Pixels(Pixels_nodeList.get(0), model));
        }
        List<Element> ROIRef_nodeList = Image.getChildrenByTagName(element, "ROIRef");
        for (Element ROIRef_element : ROIRef_nodeList) {
            ROIRef roiList_reference = new ROIRef();
            roiList_reference.setID(ROIRef_element.getAttribute("ID"));
            model.addReference(this, roiList_reference);
        }
        List<Element> MicrobeamManipulationRef_nodeList = Image.getChildrenByTagName(element, "MicrobeamManipulationRef");
        for (Element MicrobeamManipulationRef_element : MicrobeamManipulationRef_nodeList) {
            MicrobeamManipulationRef microbeamManipulationList_reference = new MicrobeamManipulationRef();
            microbeamManipulationList_reference.setID(MicrobeamManipulationRef_element.getAttribute("ID"));
            model.addReference(this, microbeamManipulationList_reference);
        }
        List<Element> AnnotationRef_nodeList = Image.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationList_reference = new AnnotationRef();
            annotationList_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationList_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof ExperimenterRef) {
            Experimenter o_casted = (Experimenter)o;
            o_casted.linkImage(this);
            this.experimenter = o_casted;
            return true;
        }
        if (reference instanceof ExperimentRef) {
            Experiment o_casted = (Experiment)o;
            o_casted.linkImage(this);
            this.experiment = o_casted;
            return true;
        }
        if (reference instanceof GroupRef) {
            Group o_casted = (Group)o;
            o_casted.linkImage(this);
            this.group = o_casted;
            return true;
        }
        if (reference instanceof DatasetRef) {
            Dataset o_casted = (Dataset)o;
            o_casted.linkImage(this);
            this.datasetList.add(o_casted);
            return true;
        }
        if (reference instanceof InstrumentRef) {
            Instrument o_casted = (Instrument)o;
            o_casted.linkImage(this);
            this.instrument = o_casted;
            return true;
        }
        if (reference instanceof ROIRef) {
            ROI o_casted = (ROI)o;
            o_casted.linkImage(this);
            this.roiList.add(o_casted);
            return true;
        }
        if (reference instanceof MicrobeamManipulationRef) {
            MicrobeamManipulation o_casted = (MicrobeamManipulation)o;
            o_casted.linkImage(this);
            this.microbeamManipulationList.add(o_casted);
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkImage(this);
            this.annotationList.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAcquiredDate() {
        return this.acquiredDate;
    }

    public void setAcquiredDate(String acquiredDate) {
        this.acquiredDate = acquiredDate;
    }

    public Experimenter getLinkedExperimenter() {
        return this.experimenter;
    }

    public void linkExperimenter(Experimenter o) {
        this.experimenter = o;
    }

    public void unlinkExperimenter(Experimenter o) {
        if (this.experimenter == o) {
            this.experimenter = null;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Experiment getLinkedExperiment() {
        return this.experiment;
    }

    public void linkExperiment(Experiment o) {
        this.experiment = o;
    }

    public void unlinkExperiment(Experiment o) {
        if (this.experiment == o) {
            this.experiment = null;
        }
    }

    public Group getLinkedGroup() {
        return this.group;
    }

    public void linkGroup(Group o) {
        this.group = o;
    }

    public void unlinkGroup(Group o) {
        if (this.group == o) {
            this.group = null;
        }
    }

    public int sizeOfLinkedDatasetList() {
        return this.datasetList.size();
    }

    public List<Dataset> copyLinkedDatasetList() {
        return new ArrayList<Dataset>(this.datasetList);
    }

    public Dataset getLinkedDataset(int index) {
        return this.datasetList.get(index);
    }

    public Dataset setLinkedDataset(int index, Dataset o) {
        return this.datasetList.set(index, o);
    }

    public boolean linkDataset(Dataset o) {
        o.linkImage(this);
        return this.datasetList.add(o);
    }

    public boolean unlinkDataset(Dataset o) {
        o.unlinkImage(this);
        return this.datasetList.remove(o);
    }

    public Instrument getLinkedInstrument() {
        return this.instrument;
    }

    public void linkInstrument(Instrument o) {
        this.instrument = o;
    }

    public void unlinkInstrument(Instrument o) {
        if (this.instrument == o) {
            this.instrument = null;
        }
    }

    public ObjectiveSettings getObjectiveSettings() {
        return this.objectiveSettings;
    }

    public void setObjectiveSettings(ObjectiveSettings objectiveSettings) {
        this.objectiveSettings = objectiveSettings;
    }

    public ImagingEnvironment getImagingEnvironment() {
        return this.imagingEnvironment;
    }

    public void setImagingEnvironment(ImagingEnvironment imagingEnvironment) {
        this.imagingEnvironment = imagingEnvironment;
    }

    public StageLabel getStageLabel() {
        return this.stageLabel;
    }

    public void setStageLabel(StageLabel stageLabel) {
        this.stageLabel = stageLabel;
    }

    public Pixels getPixels() {
        return this.pixels;
    }

    public void setPixels(Pixels pixels) {
        this.pixels = pixels;
    }

    public int sizeOfLinkedROIList() {
        return this.roiList.size();
    }

    public List<ROI> copyLinkedROIList() {
        return new ArrayList<ROI>(this.roiList);
    }

    public ROI getLinkedROI(int index) {
        return this.roiList.get(index);
    }

    public ROI setLinkedROI(int index, ROI o) {
        return this.roiList.set(index, o);
    }

    public boolean linkROI(ROI o) {
        o.linkImage(this);
        return this.roiList.add(o);
    }

    public boolean unlinkROI(ROI o) {
        o.unlinkImage(this);
        return this.roiList.remove(o);
    }

    public int sizeOfLinkedMicrobeamManipulationList() {
        return this.microbeamManipulationList.size();
    }

    public List<MicrobeamManipulation> copyLinkedMicrobeamManipulationList() {
        return new ArrayList<MicrobeamManipulation>(this.microbeamManipulationList);
    }

    public MicrobeamManipulation getLinkedMicrobeamManipulation(int index) {
        return this.microbeamManipulationList.get(index);
    }

    public MicrobeamManipulation setLinkedMicrobeamManipulation(int index, MicrobeamManipulation o) {
        return this.microbeamManipulationList.set(index, o);
    }

    public boolean linkMicrobeamManipulation(MicrobeamManipulation o) {
        o.linkImage(this);
        return this.microbeamManipulationList.add(o);
    }

    public boolean unlinkMicrobeamManipulation(MicrobeamManipulation o) {
        o.unlinkImage(this);
        return this.microbeamManipulationList.remove(o);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationList.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationList);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationList.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationList.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkImage(this);
        return this.annotationList.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkImage(this);
        return this.annotationList.remove(o);
    }

    public int sizeOfLinkedWellSampleList() {
        return this.wellSample_BackReferenceList.size();
    }

    public List<WellSample> copyLinkedWellSampleList() {
        return new ArrayList<WellSample>(this.wellSample_BackReferenceList);
    }

    public WellSample getLinkedWellSample(int index) {
        return this.wellSample_BackReferenceList.get(index);
    }

    public WellSample setLinkedWellSample(int index, WellSample o) {
        return this.wellSample_BackReferenceList.set(index, o);
    }

    public boolean linkWellSample(WellSample o) {
        return this.wellSample_BackReferenceList.add(o);
    }

    public boolean unlinkWellSample(WellSample o) {
        return this.wellSample_BackReferenceList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Image_element) {
        Reference o;
        Reference o2;
        if (Image_element == null) {
            Image_element = document.createElementNS(NAMESPACE, "Image");
        }
        if (this.id != null) {
            Image_element.setAttribute("ID", this.id.toString());
        }
        if (this.name != null) {
            Image_element.setAttribute("Name", this.name.toString());
        }
        if (this.acquiredDate != null) {
            Element acquiredDate_element = document.createElementNS(NAMESPACE, "AcquiredDate");
            acquiredDate_element.setTextContent(this.acquiredDate.toString());
            Image_element.appendChild(acquiredDate_element);
        }
        if (this.experimenter != null) {
            o2 = new ExperimenterRef();
            ((ExperimenterRef)o2).setID(this.experimenter.getID());
            Image_element.appendChild(((ExperimenterRef)o2).asXMLElement(document));
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            Image_element.appendChild(description_element);
        }
        if (this.experiment != null) {
            o2 = new ExperimentRef();
            ((ExperimentRef)o2).setID(this.experiment.getID());
            Image_element.appendChild(((ExperimentRef)o2).asXMLElement(document));
        }
        if (this.group != null) {
            o2 = new GroupRef();
            ((GroupRef)o2).setID(this.group.getID());
            Image_element.appendChild(((GroupRef)o2).asXMLElement(document));
        }
        if (this.datasetList != null) {
            for (Dataset datasetList_value : this.datasetList) {
                o = new DatasetRef();
                ((DatasetRef)o).setID(datasetList_value.getID());
                Image_element.appendChild(((DatasetRef)o).asXMLElement(document));
            }
        }
        if (this.instrument != null) {
            o2 = new InstrumentRef();
            ((InstrumentRef)o2).setID(this.instrument.getID());
            Image_element.appendChild(((InstrumentRef)o2).asXMLElement(document));
        }
        if (this.objectiveSettings != null) {
            Image_element.appendChild(this.objectiveSettings.asXMLElement(document));
        }
        if (this.imagingEnvironment != null) {
            Image_element.appendChild(this.imagingEnvironment.asXMLElement(document));
        }
        if (this.stageLabel != null) {
            Image_element.appendChild(this.stageLabel.asXMLElement(document));
        }
        if (this.pixels != null) {
            Image_element.appendChild(this.pixels.asXMLElement(document));
        }
        if (this.roiList != null) {
            for (ROI roiList_value : this.roiList) {
                o = new ROIRef();
                ((ROIRef)o).setID(roiList_value.getID());
                Image_element.appendChild(((ROIRef)o).asXMLElement(document));
            }
        }
        if (this.microbeamManipulationList != null) {
            for (MicrobeamManipulation microbeamManipulationList_value : this.microbeamManipulationList) {
                o = new MicrobeamManipulationRef();
                ((MicrobeamManipulationRef)o).setID(microbeamManipulationList_value.getID());
                Image_element.appendChild(((MicrobeamManipulationRef)o).asXMLElement(document));
            }
        }
        if (this.annotationList != null) {
            for (Annotation annotationList_value : this.annotationList) {
                o = new AnnotationRef();
                ((AnnotationRef)o).setID(annotationList_value.getID());
                Image_element.appendChild(((AnnotationRef)o).asXMLElement(document));
            }
        }
        if (this.wellSample_BackReferenceList != null) {
            // empty if block
        }
        return super.asXMLElement(document, Image_element);
    }
}

