/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Shape;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Text
extends Shape {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/ROI/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Text.class);
    private Double y;
    private Double x;
    private String value;

    public Text() {
    }

    public Text(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Value_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Text".equals(tagName)) {
            LOGGER.debug("Expecting node name of Text got {}", (Object)tagName);
        }
        if (element.hasAttribute("Y")) {
            this.setY(Double.valueOf(element.getAttribute("Y")));
        }
        if (element.hasAttribute("X")) {
            this.setX(Double.valueOf(element.getAttribute("X")));
        }
        if ((Value_nodeList = Text.getChildrenByTagName(element, "Value")).size() > 1) {
            throw new RuntimeException(String.format("Value node list size %d != 1", Value_nodeList.size()));
        }
        if (Value_nodeList.size() != 0) {
            this.setValue(String.valueOf(Value_nodeList.get(0).getTextContent()));
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element Text_element) {
        if (Text_element == null) {
            Text_element = document.createElementNS(NAMESPACE, "Text");
        }
        if (this.y != null) {
            Text_element.setAttribute("Y", this.y.toString());
        }
        if (this.x != null) {
            Text_element.setAttribute("X", this.x.toString());
        }
        if (this.value != null) {
            Element value_element = document.createElementNS(NAMESPACE, "Value");
            value_element.setTextContent(this.value.toString());
            Text_element.appendChild(value_element);
        }
        return super.asXMLElement(document, Text_element);
    }
}

