/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import eu.kostia.gtkjfilechooser.AcceptAllFileFilter;
import eu.kostia.gtkjfilechooser.FileFilterWrapper;
import eu.kostia.gtkjfilechooser.GtkFileChooserSettings;
import eu.kostia.gtkjfilechooser.I18N;
import eu.kostia.gtkjfilechooser.ui.ContextMenu;
import eu.kostia.gtkjfilechooser.ui.FilesListPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.table.TableCellEditor;

public class FileBrowserPane
extends FilesListPane {
    private File currentDir;
    private boolean showHidden = GtkFileChooserSettings.get().getShowHidden();
    private boolean showBackup = UIManager.getBoolean("FileChooser.showBackup");
    private int fileSelectionMode = 0;
    private FileFilter currentFilter = new AcceptAllFileFilter();
    private ContextMenu contextMenu;

    public FileBrowserPane(File startDir, FileView fileView) {
        super(fileView);
        this.setCurrentDir(startDir);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if ("double_click".equals(cmd)) {
                    FileBrowserPane.this.maybeApproveSelection();
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (FileBrowserPane.this.table.getSelectedRowCount() > 1) {
                    FileBrowserPane.this.firePropertyChange("SelectedFilesChangedProperty", null, FileBrowserPane.this.getSelectedFiles());
                } else {
                    FileBrowserPane.this.firePropertyChange("SelectedFileChangedProperty", null, FileBrowserPane.this.getSelectedFile());
                }
            }
        });
        this.bindKeyAction();
        this.doMultiSelectionEnabledChanged(false);
        this.addMouseListener();
    }

    private void addMouseListener() {
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                int index = FileBrowserPane.this.table.rowAtPoint(evt.getPoint());
                if (SwingUtilities.isRightMouseButton(evt)) {
                    FileBrowserPane.this.table.getSelectionModel().setSelectionInterval(index, index);
                    if (FileBrowserPane.this.contextMenu == null) {
                        FileBrowserPane.this.createContextMenu();
                    }
                    boolean enabled = FileBrowserPane.this.getSelectedFile() != null && FileBrowserPane.this.getSelectedFile().isDirectory();
                    FileBrowserPane.this.contextMenu.setAddToBookmarkMenuItemEnabled(enabled);
                    FileBrowserPane.this.contextMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
    }

    private void bindKeyAction() {
        this.bind(KeyStroke.getKeyStroke(10, 0), new AbstractAction("maybeApproveSelection"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileBrowserPane.this.maybeApproveSelection();
            }
        });
    }

    private void bind(KeyStroke key, Action action) {
        String name = (String)action.getValue("Name");
        if (name == null) {
            throw new IllegalArgumentException("The action must have a name.");
        }
        this.table.getInputMap().put(key, name);
        this.table.getActionMap().put(name, action);
    }

    private void listDirectory(File dir, FileFilter swingFilter) {
        if (!dir.exists()) {
            throw new IllegalArgumentException(dir + " doesn't exist.");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " isn't a directory.");
        }
        FileFilterWrapper filter = new FileFilterWrapper(swingFilter);
        this.getModel().clear();
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                if (file.isHidden()) {
                    if (!this.showHidden) continue;
                    if (this.isBackup(file)) {
                        if (!this.showBackup) continue;
                        this.getModel().addFile(file);
                        continue;
                    }
                    this.getModel().addFile(file);
                    continue;
                }
                if (this.isBackup(file)) {
                    if (!this.showBackup) continue;
                    this.getModel().addFile(file);
                    continue;
                }
                this.getModel().addFile(file);
            }
        }
    }

    private boolean isBackup(File file) {
        return file.getName().endsWith("~");
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    public void setCurrentDir(File currentDir) {
        File oldValue = this.currentDir;
        File newValue = currentDir;
        this.currentDir = currentDir;
        this.listDirectory(currentDir, this.currentFilter);
        this.firePropertyChange("directoryChanged", oldValue, newValue);
        this.table.scrollRectToVisible(this.table.getCellRect(0, 0, true));
    }

    public void refresh() {
        this.listDirectory(this.currentDir, this.currentFilter);
        this.table.scrollRectToVisible(this.table.getCellRect(0, 0, true));
    }

    public void setShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    public void setIsMultiSelectionEnabled(boolean enabled) {
        this.doMultiSelectionEnabledChanged(enabled);
    }

    public void setCurrentFilter(FileFilter swingFileFilter) {
        this.currentFilter = swingFileFilter;
        this.doFileFilerChanged(swingFileFilter);
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
        this.doFileSelectionModeChanged(fileSelectionMode);
    }

    private void doFileSelectionModeChanged(Integer value) {
        this.setFilesSelectable(1 != value);
        this.table.repaint();
    }

    private void doFileFilerChanged(FileFilter filter) {
        this.listDirectory(this.getCurrentDir(), filter);
    }

    private void doMultiSelectionEnabledChanged(Boolean multi) {
        this.table.setSelectionMode(multi != false ? 2 : 0);
    }

    private void maybeApproveSelection() {
        File selectedFile = this.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        if (this.fileSelectionMode != 1 && selectedFile.isDirectory()) {
            this.setCurrentDir(selectedFile);
        } else {
            this.fireActionEvent(new ActionEvent(this, "ApproveSelection".hashCode(), "ApproveSelection"));
        }
    }

    public void rescanCurrentDirectory() {
        this.listDirectory(this.getCurrentDir(), this.currentFilter);
    }

    private void createContextMenu() {
        this.contextMenu = new ContextMenu();
        ContextMenuListener contextMenuListener = new ContextMenuListener();
        this.contextMenu.addPropertyChangeListener(contextMenuListener);
        this.contextMenu.addActionListener(contextMenuListener);
    }

    public void createFolder() {
        TableCellEditor cellEditor;
        FilesListPane.FilesListTableModel model = (FilesListPane.FilesListTableModel)this.table.getModel();
        model.addEmtpyRow();
        model.setEditableRow(0);
        boolean success = this.table.editCellAt(0, 0);
        model.setEditableRow(-1);
        JTextField editorComponent = (JTextField)this.table.getEditorComponent();
        if (editorComponent != null) {
            editorComponent.setText(I18N._("Type name of new folder"));
            editorComponent.selectAll();
            editorComponent.requestFocusInWindow();
            editorComponent.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FileBrowserPane.this.table.getCellEditor() != null) {
                        FileBrowserPane.this.table.getCellEditor().cancelCellEditing();
                    }
                }
            }, KeyStroke.getKeyStroke(27, 0), 0);
            editorComponent.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (FileBrowserPane.this.table.getCellEditor() != null) {
                        FileBrowserPane.this.table.getCellEditor().cancelCellEditing();
                    }
                }
            });
        }
        if (success) {
            this.table.changeSelection(0, 0, false, false);
        }
        if ((cellEditor = this.table.getCellEditor()) != null) {
            CellEditorListener cellEditorListener = new CellEditorListener(){

                @Override
                public void editingStopped(ChangeEvent e) {
                    cellEditor.removeCellEditorListener(this);
                    Object cellValue = cellEditor.getCellEditorValue();
                    String newFolderName = null;
                    if (cellValue instanceof File) {
                        newFolderName = ((File)cellValue).getName();
                    } else if (cellValue instanceof String) {
                        newFolderName = (String)cellValue;
                    }
                    if (I18N._("Type name of new folder").equals(newFolderName)) {
                        this.removeEmtpyRow();
                        return;
                    }
                    File newFolder = new File(FileBrowserPane.this.getCurrentDir().getAbsolutePath() + File.separator + newFolderName);
                    if (newFolder.exists()) {
                        JOptionPane.showMessageDialog(FileBrowserPane.this, "<html><p width='250px'>" + I18N._("The folder could not be created, as a file with the same name already exists.  Try using a different name for the folder, or rename the file first.") + "</p></html>", "", 0);
                        this.removeEmtpyRow();
                    } else {
                        newFolder.mkdir();
                        FileBrowserPane.this.setCurrentDir(newFolder);
                    }
                }

                @Override
                public void editingCanceled(ChangeEvent e) {
                    cellEditor.removeCellEditorListener(this);
                    this.removeEmtpyRow();
                }

                private void removeEmtpyRow() {
                    ((FilesListPane.FilesListTableModel)FileBrowserPane.this.table.getModel()).removeEmtpyRow();
                }
            };
            cellEditor.addCellEditorListener(cellEditorListener);
        }
    }

    private class ContextMenuListener
    implements PropertyChangeListener,
    ActionListener {
        private ContextMenuListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            Object value = evt.getNewValue();
            if ("ShowSizeColumnChanged".equals(property)) {
                boolean showSizeColumn = (Boolean)value;
                FileBrowserPane.this.setShowSizeColumn(showSizeColumn);
                FileBrowserPane.this.rescanCurrentDirectory();
            } else if ("FileHidingChanged".equals(property)) {
                boolean hide = (Boolean)value;
                GtkFileChooserSettings.get().setShowHidden(!hide);
                FileBrowserPane.this.setShowHidden(!hide);
                FileBrowserPane.this.rescanCurrentDirectory();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if ("AddBookmark".equals(cmd)) {
                FileBrowserPane.this.fireActionEvent(e);
            }
        }
    }
}

