/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import eu.kostia.gtkjfilechooser.BookmarkManager;
import eu.kostia.gtkjfilechooser.GtkStockIcon;
import eu.kostia.gtkjfilechooser.Path;
import eu.kostia.gtkjfilechooser.ui.LowerBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;

public class FileComboBoxRenderer
extends JLabel
implements ListCellRenderer,
UIResource {
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(LowerBorder.INSETS);
    private static final Border DEFAULT_NO_FOCUS_BORDER;
    protected static Border noFocusBorder;
    private JComboBox comboBox;

    public FileComboBoxRenderer(JComboBox comboBox) {
        this.comboBox = comboBox;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setName("ComboBox.listRenderer");
        Dimension size = this.getPreferredSize();
        size.height = 29;
        this.setPreferredSize(size);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getSelectionForeground());
            this.setForeground(list.getForeground());
        }
        this.setFont(list.getFont());
        if (value instanceof Path) {
            Path path = (Path)value;
            this.setText(path.getName());
            this.setIcon(GtkStockIcon.get(path.getIconName(), GtkStockIcon.Size.GTK_ICON_SIZE_MENU));
        }
        if (this.comboBox != null) {
            this.setEnabled(this.comboBox.isEnabled());
            this.setComponentOrientation(this.comboBox.getComponentOrientation());
        }
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = this.getNoFocusBorder();
        }
        this.setBorder(border);
        if (index + 1 < list.getModel().getSize()) {
            Object nextValue = list.getModel().getElementAt(index + 1);
            if (!(value instanceof BookmarkManager.GtkBookmark) && nextValue instanceof BookmarkManager.GtkBookmark) {
                this.setBorder(new LowerBorder(Color.GRAY, 1));
            }
        }
        return this;
    }

    private Border getNoFocusBorder() {
        Border border = UIManager.getBorder("List.cellNoFocusBorder");
        if (System.getSecurityManager() != null) {
            if (border != null) {
                return border;
            }
            return SAFE_NO_FOCUS_BORDER;
        }
        if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
            return border;
        }
        return noFocusBorder;
    }

    static {
        noFocusBorder = DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(LowerBorder.INSETS);
    }
}

