/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.xbel;

import eu.kostia.gtkjfilechooser.UrlUtil;
import eu.kostia.gtkjfilechooser.xbel.ISO8601DateFormat;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RecentlyUsedManager {
    private static final Logger LOG = Logger.getLogger(RecentlyUsedManager.class.getName());
    private static final String FILE_PROTOCOL = "file://";
    private List<File> recentFiles;

    public RecentlyUsedManager(int n) {
        try {
            this.init(n);
        }
        catch (Exception e) {
            throw new IOError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(int n) throws ParserConfigurationException, SAXException, FileNotFoundException, IOException {
        BufferedInputStream stream = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            RecentFilesHandler handler = new RecentFilesHandler();
            stream = new BufferedInputStream(new FileInputStream(this.getRecentlyUsedFile()));
            InputSource is = new InputSource(stream);
            saxParser.parse(is, (DefaultHandler)handler);
            this.recentFiles = handler.getAllRecentFiles();
            Collections.sort(this.recentFiles, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    long date1 = o1.lastModified();
                    long date2 = o2.lastModified();
                    return date2 < date1 ? -1 : (date2 == date1 ? 0 : 1);
                }
            });
            if (n < this.recentFiles.size()) {
                this.recentFiles = this.recentFiles.subList(0, n);
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public List<File> getRecentFiles() {
        return this.recentFiles;
    }

    protected File getRecentlyUsedFile() {
        return new File(System.getProperty("user.home") + File.separator + ".recently-used.xbel");
    }

    private class RecentFilesHandler
    extends DefaultHandler {
        private final ISO8601DateFormat fmt;
        private final List<File> allRecentFiles = new ArrayList<File>();

        public RecentFilesHandler() {
            this.fmt = new ISO8601DateFormat();
        }

        public List<File> getAllRecentFiles() {
            return this.allRecentFiles;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attr) {
            if (!"bookmark".equals(name)) {
                return;
            }
            int attrCount = attr.getLength();
            if (attrCount == 0) {
                return;
            }
            String href = null;
            Date modified = null;
            for (int i = 0; i < attrCount; ++i) {
                if ("href".equals(attr.getQName(i))) {
                    href = attr.getValue(i);
                    if (!href.startsWith(RecentlyUsedManager.FILE_PROTOCOL)) {
                        return;
                    }
                    if (href.startsWith(RecentlyUsedManager.FILE_PROTOCOL + System.getProperty("java.io.tmpdir"))) {
                        return;
                    }
                    if (!new File(href = UrlUtil.decode(href.substring(RecentlyUsedManager.FILE_PROTOCOL.length()))).exists()) {
                        return;
                    }
                }
                if (!"modified".equals(attr.getQName(i))) continue;
                try {
                    modified = this.fmt.parse(attr.getValue(i));
                }
                catch (ParseException e) {
                    modified = new Date(0L);
                }
                break;
            }
            final long modifiedTime = modified.getTime();
            File recentFile = new File(href){
                private static final long serialVersionUID = 1L;

                @Override
                public long lastModified() {
                    return modifiedTime;
                }
            };
            this.allRecentFiles.add(recentFile);
        }

        @Override
        public void warning(SAXParseException spe) {
            LOG.warning(spe.getMessage());
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            throw spe;
        }
    }
}

