/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EndpointParseException;
import IceInternal.BasicStream;
import IceInternal.Buffer;
import IceInternal.EndpointFactory;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.UnknownEndpointI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EndpointFactoryManager {
    private Instance _instance;
    private List<EndpointFactory> _factories = new ArrayList<EndpointFactory>();

    EndpointFactoryManager(Instance instance) {
        this._instance = instance;
    }

    public synchronized void add(EndpointFactory factory) {
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory f = this._factories.get(i);
            if (f.type() == factory.type()) assert (false);
        }
        this._factories.add(factory);
    }

    public synchronized EndpointFactory get(short type) {
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory f = this._factories.get(i);
            if (f.type() != type) continue;
            return f;
        }
        return null;
    }

    public synchronized EndpointI create(String str, boolean oaEndpoint) {
        String s = str.trim();
        if (s.length() == 0) {
            EndpointParseException e = new EndpointParseException();
            e.str = str;
            throw e;
        }
        Pattern p = Pattern.compile("([ \t\n\r]+)|$");
        Matcher m = p.matcher(s);
        boolean b = m.find();
        assert (b);
        String protocol = s.substring(0, m.start());
        if (protocol.equals("default")) {
            protocol = this._instance.defaultsAndOverrides().defaultProtocol;
        }
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory f = this._factories.get(i);
            if (!f.protocol().equals(protocol)) continue;
            return f.create(s.substring(m.end()), oaEndpoint);
        }
        if (protocol.equals("opaque")) {
            UnknownEndpointI ue = new UnknownEndpointI(s.substring(m.end()));
            for (int i = 0; i < this._factories.size(); ++i) {
                EndpointFactory f = this._factories.get(i);
                if (f.type() != ((EndpointI)ue).type()) continue;
                BasicStream bs = new BasicStream(this._instance, true);
                ((EndpointI)ue).streamWrite(bs);
                Buffer buf = bs.getBuffer();
                buf.b.position(0);
                bs.readShort();
                return f.read(bs);
            }
            return ue;
        }
        return null;
    }

    public synchronized EndpointI read(BasicStream s) {
        short type = s.readShort();
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory f = this._factories.get(i);
            if (f.type() != type) continue;
            return f.read(s);
        }
        return new UnknownEndpointI(type, s);
    }

    void destroy() {
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory f = this._factories.get(i);
            f.destroy();
        }
        this._factories.clear();
    }
}

