/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.sql.Timestamp;
import java.text.DateFormat;
import omero.RInt;
import omero.RString;
import omero.RTime;
import omero.model.PlateAcquisition;
import omero.model.PlateAcquisitionI;
import omero.rtypes;
import pojos.DataObject;

public class PlateAcquisitionData
extends DataObject {
    private long refPlateId;
    private String label;

    public PlateAcquisitionData() {
        this.setDirty(true);
        this.setValue(new PlateAcquisitionI());
        this.refPlateId = -1L;
    }

    public PlateAcquisitionData(PlateAcquisition value) {
        if (value == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(value);
        this.refPlateId = -1L;
        this.label = null;
    }

    public long getRefPlateId() {
        return this.refPlateId;
    }

    public void setRefPlateId(long refPlateId) {
        this.refPlateId = refPlateId;
    }

    public String getName() {
        PlateAcquisition acq = (PlateAcquisition)this.asIObject();
        if (acq == null) {
            return "";
        }
        RString n = acq.getName();
        if (n == null) {
            return "";
        }
        return n.getValue();
    }

    public String getDescription() {
        PlateAcquisition acq = (PlateAcquisition)this.asIObject();
        if (acq == null) {
            return "";
        }
        RString n = acq.getDescription();
        if (n == null) {
            return "";
        }
        return n.getValue();
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        this.setDirty(true);
        PlateAcquisition acq = (PlateAcquisition)this.asIObject();
        acq.setName(rtypes.rstring(name));
    }

    public void setDescription(String description) {
        if (description == null || description.length() == 0) {
            return;
        }
        this.setDirty(true);
        PlateAcquisition acq = (PlateAcquisition)this.asIObject();
        acq.setDescription(rtypes.rstring(description));
    }

    public Timestamp getStartTime() {
        PlateAcquisition sa = (PlateAcquisition)this.asIObject();
        if (sa == null) {
            return null;
        }
        RTime time = sa.getStartTime();
        if (time == null) {
            return null;
        }
        return new Timestamp(time.getValue());
    }

    public Timestamp getEndTime() {
        PlateAcquisition sa = (PlateAcquisition)this.asIObject();
        if (sa == null) {
            return null;
        }
        RTime time = sa.getEndTime();
        if (time == null) {
            return null;
        }
        return new Timestamp(time.getValue());
    }

    public String getLabel() {
        String end;
        if (this.label != null) {
            return this.label;
        }
        String name = this.getName();
        if (name != null && name.length() > 0) {
            this.label = name;
            return this.label;
        }
        String start = DateFormat.getDateTimeInstance(3, 3).format(this.getStartTime());
        String[] values = start.split(" ");
        String date = "";
        String dateEnd = "";
        if (values.length > 1) {
            date = values[0];
            start = start.substring(date.length() + 1);
        }
        if ((values = (end = DateFormat.getDateTimeInstance(3, 3).format(this.getEndTime())).split(" ")).length > 1) {
            if (!date.equals(values[0])) {
                dateEnd = values[0];
            }
            end = end.substring(values[0].length() + 1);
        }
        String value = "";
        value = dateEnd.length() == 0 ? date + " " + start + " - " + end : date + " " + start + " - " + dateEnd + " " + end;
        this.label = value.length() > 0 ? value : "" + this.getId();
        return this.label;
    }

    public int getMaximumFieldCount() {
        PlateAcquisition acq = (PlateAcquisition)this.asIObject();
        if (acq == null) {
            return -1;
        }
        RInt n = acq.getMaximumFieldCount();
        if (n == null) {
            return -1;
        }
        return n.getValue();
    }
}

