/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.netcdf3;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IOServiceProviderWriter;
import ucar.nc2.iosp.Indexer;
import ucar.nc2.iosp.RegularLayout;
import ucar.nc2.iosp.netcdf3.N3header;
import ucar.nc2.util.CancelTask;
import ucar.unidata.util.Format;

public abstract class N3iosp
implements IOServiceProviderWriter {
    private static Logger log = LoggerFactory.getLogger(N3iosp.class);
    public static final byte NC_FILL_BYTE = -127;
    public static final char NC_FILL_CHAR = '\u0000';
    public static final short NC_FILL_SHORT = -32767;
    public static final int NC_FILL_INT = -2147483647;
    public static final long NC_FILL_LONG = -9223372036854775806L;
    public static final float NC_FILL_FLOAT = 9.96921E36f;
    public static final double NC_FILL_DOUBLE = (double)9.96921E36f;
    public static final String FillValue = "_FillValue";
    private static boolean syncExtendOnly = false;
    protected NetcdfFile ncfile;
    protected boolean readonly;
    protected ucar.unidata.io.RandomAccessFile raf;
    protected N3header headerParser;
    protected int numrecs;
    protected int recsize;
    protected long lastModified;
    protected long fileUsed = 0L;
    protected long recStart = 0L;
    protected boolean debug = false;
    protected boolean debugSize = false;
    protected boolean debugSPIO = false;
    protected boolean debugRecord = false;
    protected boolean debugSync = false;
    protected boolean showHeaderBytes = false;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
    private PrintStream out = new PrintStream(this.bos);
    protected boolean useRecordStructure;
    protected boolean fill = true;
    protected HashMap dimHash = new HashMap(50);

    public static void setProperty(String name, String value) {
        if (name.equalsIgnoreCase("syncExtendOnly")) {
            syncExtendOnly = value.equalsIgnoreCase("true");
        }
    }

    public boolean isValidFile(ucar.unidata.io.RandomAccessFile raf) throws IOException {
        return N3header.isValidFile(raf);
    }

    public String getDetailInfo() {
        this.out.flush();
        return this.bos.toString();
    }

    public void open(ucar.unidata.io.RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        File file;
        this.raf = raf;
        this.ncfile = ncfile;
        double size = (double)raf.length() / 1000000.0;
        this.out.println(" raf=" + raf.getLocation());
        this.out.println("   size= " + Format.dfrac(size, 3) + " Mb");
        String location = raf.getLocation();
        if (!location.startsWith("http:") && (file = new File(location)).exists()) {
            this.lastModified = file.lastModified();
        }
        raf.order(0);
        this.headerParser = new N3header();
        this.headerParser.read(raf, ncfile, null);
        this.numrecs = this.headerParser.numrecs;
        this.recsize = this.headerParser.recsize;
        this.recStart = this.headerParser.recStart;
        this._open(raf);
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        if (v2 instanceof Structure) {
            return this.readRecordData((Structure)v2, section);
        }
        N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        Indexer index = RegularLayout.factory(vinfo.begin, v2.getElementSize(), v2.isUnlimited() ? this.recsize : -1, v2.getShape(), section);
        Object data = this.readData(index, dataType);
        return Array.factory(dataType.getPrimitiveClassType(), section.getShape(), data);
    }

    private Array readRecordData(Structure s, Section section) throws IOException {
        Range recordRange = section.getRange(0);
        StructureMembers members = this.makeStructureMembers(s);
        members.setStructureSize(this.recsize);
        ArrayStructureBB structureArray = new ArrayStructureBB(members, new int[]{recordRange.length()});
        byte[] result = (byte[])structureArray.getStorage();
        int count = 0;
        for (int recnum = recordRange.first(); recnum <= recordRange.last(); recnum += recordRange.stride()) {
            if (this.debugRecord) {
                System.out.println(" read record " + recnum);
            }
            this.raf.seek(this.recStart + (long)(recnum * this.recsize));
            if (recnum != this.numrecs - 1) {
                this.raf.readFully(result, count * this.recsize, this.recsize);
            } else {
                this.raf.read(result, count * this.recsize, this.recsize);
            }
            ++count;
        }
        return structureArray;
    }

    private StructureMembers makeStructureMembers(Structure s) {
        StructureMembers members = s.makeStructureMembers();
        for (StructureMembers.Member m : members.getMembers()) {
            Variable v2 = s.findVariable(m.getName());
            N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
            m.setDataParam((int)(vinfo.begin - this.recStart));
        }
        return members;
    }

    public Array readNestedData(Variable v2, Section section) throws IOException, InvalidRangeException {
        N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        int[] fullShape = new int[v2.getRank() + 1];
        fullShape[0] = this.numrecs;
        System.arraycopy(v2.getShape(), 0, fullShape, 1, v2.getRank());
        Indexer index = RegularLayout.factory(vinfo.begin, v2.getElementSize(), this.recsize, fullShape, section);
        Object dataObject = this.readData(index, dataType);
        return Array.factory(dataType.getPrimitiveClassType(), section.getShape(), dataObject);
    }

    public long readData(Variable v2, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        if (v2 instanceof Structure) {
            return this.readRecordData((Structure)v2, section, channel);
        }
        N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        Indexer index = RegularLayout.factory(vinfo.begin, v2.getElementSize(), v2.isUnlimited() ? this.recsize : -1, v2.getShape(), section);
        return this.readData(index, dataType, channel);
    }

    private long readRecordData(Structure s, Section section, WritableByteChannel out) throws IOException, InvalidRangeException {
        long count = 0L;
        Range recordRange = section.getRange(0);
        int stride = recordRange.stride();
        if (stride == 1) {
            int first = recordRange.first();
            int n = recordRange.length();
            return this.raf.readToByteChannel(out, this.recStart + (long)(first * this.recsize), n * this.recsize);
        }
        for (int recnum = recordRange.first(); recnum <= recordRange.last(); recnum += recordRange.stride()) {
            if (this.debugRecord) {
                System.out.println(" read record " + recnum);
            }
            this.raf.seek(this.recStart + (long)(recnum * this.recsize));
            count += this.raf.readToByteChannel(out, this.recStart + (long)(recnum * this.recsize), this.recsize);
        }
        return count;
    }

    protected static char[] convertByteToCharUTF(byte[] byteArray) {
        Charset c = Charset.forName("UTF-8");
        CharBuffer output = c.decode(ByteBuffer.wrap(byteArray));
        return output.array();
    }

    protected static byte[] convertCharToByteUTF(char[] from) {
        Charset c = Charset.forName("UTF-8");
        ByteBuffer output = c.encode(CharBuffer.wrap(from));
        return output.array();
    }

    protected static char[] convertByteToChar(byte[] byteArray) {
        int size = byteArray.length;
        char[] cbuff = new char[size];
        for (int i = 0; i < size; ++i) {
            cbuff[i] = (char)DataType.unsignedByteToShort(byteArray[i]);
        }
        return cbuff;
    }

    public static byte[] convertCharToByte(char[] from) {
        int size = from.length;
        byte[] to = new byte[size];
        for (int i = 0; i < size; ++i) {
            to[i] = (byte)from[i];
        }
        return to;
    }

    public void create(String filename, NetcdfFile ncfile, boolean fill) throws IOException {
        this.create(filename, ncfile, fill, 0L);
    }

    public void create(String filename, NetcdfFile ncfile, boolean fill, long size) throws IOException {
        this.ncfile = ncfile;
        this.fill = fill;
        this.readonly = false;
        ncfile.finish();
        this.raf = new ucar.unidata.io.RandomAccessFile(filename, "rw");
        this.raf.order(0);
        if (size > 0L) {
            RandomAccessFile myRaf = this.raf.getRandomAccessFile();
            myRaf.setLength(size);
        }
        this.headerParser = new N3header();
        this.headerParser.create(this.raf, ncfile, fill, null);
        this.recsize = this.headerParser.recsize;
        this.recStart = this.headerParser.recStart;
        this.fileUsed = this.headerParser.recStart;
        this._create(this.raf);
        if (fill) {
            this.fillNonRecordVariables();
        } else {
            this.raf.setMinLength(this.recStart);
        }
    }

    public void writeData(Variable v2, Section section, Array values) throws IOException, InvalidRangeException {
        N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        if (v2.isUnlimited()) {
            Range firstRange = section.getRange(0);
            this.setNumrecs(firstRange.last() + 1);
        }
        if (v2 instanceof Structure) {
            this.writeRecordData((Structure)v2, section, values);
        } else {
            Indexer index = RegularLayout.factory(vinfo.begin, v2.getElementSize(), v2.isUnlimited() ? this.recsize : -1, v2.getShape(), section);
            this.writeData(values, index, dataType);
        }
    }

    private void writeRecordData(Structure s, Section section, Array values) throws IOException, InvalidRangeException {
        if (!(values instanceof ArrayStructure)) {
            throw new IllegalArgumentException("writeRecordData: data must be ArrayStructure");
        }
        ArrayStructure structureData = (ArrayStructure)values;
        List<Variable> vars = s.getVariables();
        StructureMembers members = structureData.getStructureMembers();
        Range recordRange = section.getRange(0);
        int count = 0;
        for (int recnum = recordRange.first(); recnum <= recordRange.last(); recnum += recordRange.stride()) {
            for (Variable v2 : vars) {
                N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
                long begin = vinfo.begin + (long)(recnum * this.recsize);
                Indexer index = RegularLayout.factory(begin, v2.getElementSize(), -1, v2.getShape(), v2.getShapeAsSection());
                StructureMembers.Member m = members.findMember(v2.getShortName());
                if (null == m) continue;
                Array data = structureData.getArray(count, m);
                this.writeData(data, index, v2.getDataType());
            }
            ++count;
        }
    }

    protected void setNumrecs(int n) throws IOException, InvalidRangeException {
        if (n <= this.numrecs) {
            return;
        }
        int startRec = this.numrecs;
        if (this.debugSize) {
            System.out.println("extend records to = " + n);
        }
        this.fileUsed = this.recStart + (long)(this.recsize * n);
        this.headerParser.setNumrecs(n);
        this.numrecs = n;
        for (Dimension dim : this.ncfile.getDimensions()) {
            if (!dim.isUnlimited()) continue;
            dim.setLength(n);
        }
        for (Variable v : this.ncfile.getVariables()) {
            if (!v.isUnlimited()) continue;
            v.resetShape();
            v.setCachedData(null, false);
        }
        if (this.fill) {
            this.fillRecordVariables(startRec, n);
        } else {
            this.raf.setMinLength(this.fileUsed);
        }
    }

    public void updateAttribute(Variable v2, Attribute att) throws IOException {
        this.headerParser.updateAttribute(v2, att);
    }

    protected void fillNonRecordVariables() throws IOException {
        for (Variable v : this.ncfile.getVariables()) {
            if (v.isUnlimited()) continue;
            try {
                this.writeData(v, v.getShapeAsSection(), this.makeConstantArray(v));
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
        }
    }

    protected void fillRecordVariables(int recStart, int recEnd) throws IOException, InvalidRangeException {
        for (int i = recStart; i < recEnd; ++i) {
            Range r = new Range(i, i);
            for (Variable v : this.ncfile.getVariables()) {
                if (!v.isUnlimited() || v instanceof Structure) continue;
                Section recordSection = new Section(v.getRanges());
                recordSection.setRange(0, r);
                this.writeData(v, recordSection, this.makeConstantArray(v));
            }
        }
    }

    private Array makeConstantArray(Variable v) {
        Class classType = v.getDataType().getPrimitiveClassType();
        Attribute att = v.findAttribute(FillValue);
        Object[] storage = null;
        if (classType == Double.TYPE) {
            double[] storageP = new double[]{att == null ? (double)9.96921E36f : att.getNumericValue().doubleValue()};
            storage = storageP;
        } else if (classType == Float.TYPE) {
            float[] storageP = new float[]{att == null ? 9.96921E36f : att.getNumericValue().floatValue()};
            storage = storageP;
        } else if (classType == Integer.TYPE) {
            int[] storageP = new int[]{att == null ? -2147483647 : att.getNumericValue().intValue()};
            storage = storageP;
        } else if (classType == Short.TYPE) {
            short[] storageP = new short[]{att == null ? (short)-32767 : (short)att.getNumericValue().shortValue()};
            storage = storageP;
        } else if (classType == Byte.TYPE) {
            byte[] storageP = new byte[]{att == null ? (byte)-127 : (byte)att.getNumericValue().byteValue()};
            storage = storageP;
        } else if (classType == Character.TYPE) {
            char[] storageP = new char[]{att != null && att.getStringValue().length() > 0 ? att.getStringValue().charAt(0) : (char)'\u0000'};
            storage = storageP;
        }
        return Array.factoryConstant(classType, v.getShape(), storage);
    }

    public boolean syncExtend() throws IOException {
        boolean result = this.headerParser.synchNumrecs();
        if (result && log.isDebugEnabled()) {
            log.debug(" N3iosp syncExtend " + this.raf.getLocation() + " numrecs =" + this.headerParser.numrecs);
        }
        return result;
    }

    public boolean sync() throws IOException {
        if (syncExtendOnly) {
            return this.syncExtend();
        }
        if (this.lastModified == 0L) {
            return false;
        }
        File file = new File(this.raf.getLocation());
        if (file.exists()) {
            long currentModified = file.lastModified();
            if (currentModified == this.lastModified) {
                return false;
            }
            this.ncfile.empty();
            this.open(this.raf, this.ncfile, null);
            if (log.isDebugEnabled()) {
                log.debug(" N3iosp resynced " + this.raf.getLocation() + " currentModified=" + currentModified + " lastModified= " + this.lastModified);
            }
            return true;
        }
        throw new IOException("File does not exist");
    }

    public void flush() throws IOException {
        this.raf.flush();
        this.headerParser.writeNumrecs();
        this.raf.flush();
    }

    public void close() throws IOException {
        this.raf.setMinLength(this.fileUsed);
        this.raf.close();
    }

    public String toStringDebug(Object o) {
        return null;
    }

    public Object sendIospMessage(Object message) {
        if (message == "AddRecordStructure") {
            return this.headerParser.addRecordStructure();
        }
        if (message == "RemoveRecordStructure") {
            return this.headerParser.removeRecordStructure();
        }
        return null;
    }

    protected abstract Object readData(Indexer var1, DataType var2) throws IOException;

    protected abstract long readData(Indexer var1, DataType var2, WritableByteChannel var3) throws IOException;

    protected abstract void writeData(Array var1, Indexer var2, DataType var3) throws IOException;

    protected abstract void _open(ucar.unidata.io.RandomAccessFile var1) throws IOException;

    protected abstract void _create(ucar.unidata.io.RandomAccessFile var1) throws IOException;
}

