/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.AreaFile;
import edu.wisc.ssec.mcidas.McIDASException;
import java.awt.geom.Rectangle2D;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;

public class McIDASAreaProjection
extends ProjectionImpl {
    private AREAnav anav = null;
    private int lines;
    private int elements;
    private int[] dirBlock;
    private int[] navBlock;
    private int[] auxBlock;

    public ProjectionImpl constructCopy() {
        return new McIDASAreaProjection(this.dirBlock, this.navBlock, this.auxBlock);
    }

    public McIDASAreaProjection() {
    }

    public McIDASAreaProjection(AreaFile af) {
        this(af.getDir(), af.getNav(), af.getAux());
    }

    public McIDASAreaProjection(int[] dir, int[] nav) {
        this(dir, nav, null);
    }

    public McIDASAreaProjection(int[] dir, int[] nav, int[] aux) {
        try {
            this.anav = AREAnav.makeAreaNav((int[])nav, (int[])aux);
        }
        catch (McIDASException excp) {
            throw new IllegalArgumentException("McIDASAreaProjection: problem creating projection" + (Object)((Object)excp));
        }
        this.dirBlock = dir;
        this.navBlock = nav;
        this.anav.setImageStart(dir[5], dir[6]);
        this.anav.setRes(dir[11], dir[12]);
        this.anav.setStart(0, 0);
        this.anav.setMag(1, 1);
        this.lines = dir[8];
        this.elements = dir[9];
        this.anav.setFlipLineCoordinates(dir[8]);
        this.addParameter("Projection_Name", "mcidas_area");
        this.addParameter("AreaHeader", dir.toString());
        this.addParameter("NavHeader", nav.toString());
    }

    public int[] getDirBlock() {
        return this.dirBlock;
    }

    public int[] getNavBlock() {
        return this.navBlock;
    }

    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        double[][] xy = this.anav.toLinEle((double[][])new double[][]{{fromLat}, {fromLon}});
        double toX = xy[0][0];
        double toY = xy[1][0];
        result.setLocation(toX, toY);
        return result;
    }

    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = world.getX();
        double fromY = world.getY();
        double[][] latlon = this.anav.toLatLon((double[][])new double[][]{{fromX}, {fromY}});
        double toLat = latlon[0][0];
        double toLon = latlon[1][0];
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }

    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        float[] fromLatA = from[latIndex];
        float[] fromLonA = from[lonIndex];
        float[][] xy = this.anav.toLinEle((float[][])new float[][]{fromLatA, fromLonA});
        to[0] = xy[0];
        to[1] = xy[1];
        return to;
    }

    public float[][] projToLatLon(float[][] from, float[][] to) {
        float[] fromXA = from[0];
        float[] fromYA = from[1];
        float[][] latlon = this.anav.toLatLon((float[][])new float[][]{fromXA, fromYA});
        to[0] = latlon[0];
        to[1] = latlon[1];
        return to;
    }

    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        double[] fromLatA = from[latIndex];
        double[] fromLonA = from[lonIndex];
        double[][] xy = this.anav.toLinEle((double[][])new double[][]{fromLatA, fromLonA});
        to[0] = xy[0];
        to[1] = xy[1];
        return to;
    }

    public double[][] projToLatLon(double[][] from, double[][] to) {
        double[] fromXA = from[0];
        double[] fromYA = from[1];
        double[][] latlon = this.anav.toLatLon((double[][])new double[][]{fromXA, fromYA});
        to[0] = latlon[0];
        to[1] = latlon[1];
        return to;
    }

    public ProjectionRect getDefaultMapArea() {
        return new ProjectionRect(new Rectangle2D.Float(0.0f, 0.0f, this.elements, this.lines));
    }

    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0 && Math.abs(pt1.getX() - pt2.getX()) > 5000.0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof McIDASAreaProjection)) {
            return false;
        }
        McIDASAreaProjection that = (McIDASAreaProjection)obj;
        return this == that || this.anav.equals((Object)that.anav) && this.lines == that.lines && this.elements == that.elements;
    }

    public String toString() {
        return "Image (" + this.anav.toString() + ") Projection";
    }

    public String paramsToString() {
        return " nav " + this.anav.toString();
    }

    public static void main(String[] args) throws Exception {
        String file = args.length > 0 ? args[0] : "c:/data/satellite/AREA8760";
        AreaFile af = new AreaFile(file);
        McIDASAreaProjection proj = new McIDASAreaProjection(af);
        LatLonPoint llp = new LatLonPointImpl(45.0, -105.0);
        System.out.println("lat/lon = " + llp);
        ProjectionPoint pp = proj.latLonToProj(llp);
        System.out.println("proj point = " + pp);
        llp = proj.projToLatLon(pp);
        System.out.println("reverse llp = " + llp);
        double[][] latlons = new double[][]{{45.0}, {-105.0}};
        double[][] linele = proj.latLonToProj(latlons);
        System.out.println("proj point = " + linele[0][0] + "," + linele[1][0]);
        double[][] outll = proj.projToLatLon(linele);
        System.out.println("proj point = " + outll[0][0] + "," + outll[1][0]);
    }
}

