/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Hashtable;
import loci.common.DateTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.NonNegativeInteger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ND2Handler
extends DefaultHandler {
    private static final String DATE_FORMAT = "dd/MM/yyyy  HH:mm:ss";
    private String prefix = null;
    private String prevRuntype = null;
    private String prevElement = null;
    private Hashtable<String, Object> metadata = new Hashtable();
    private CoreMetadata[] core;
    private boolean isLossless;
    private ArrayList<Long> zs = new ArrayList();
    private ArrayList<Long> ts = new ArrayList();
    private int numSeries = 0;
    private double pixelSizeX;
    private double pixelSizeY;
    private double pixelSizeZ;
    private Double pinholeSize;
    private Double voltage;
    private Double mag;
    private Double na;
    private String objectiveModel;
    private String immersion;
    private String correction;
    private Double refractiveIndex;
    private ArrayList<String> channelNames = new ArrayList();
    private ArrayList<String> modality = new ArrayList();
    private ArrayList<String> binning = new ArrayList();
    private ArrayList<Double> speed = new ArrayList();
    private ArrayList<Double> gain = new ArrayList();
    private ArrayList<Double> temperature = new ArrayList();
    private ArrayList<Double> exposureTime = new ArrayList();
    private ArrayList<Integer> exWave = new ArrayList();
    private ArrayList<Integer> emWave = new ArrayList();
    private ArrayList<Integer> power = new ArrayList();
    private ArrayList<Hashtable<String, String>> rois = new ArrayList();
    private ArrayList<Double> posX = new ArrayList();
    private ArrayList<Double> posY = new ArrayList();
    private ArrayList<Double> posZ = new ArrayList();
    private String cameraModel;
    private int fieldIndex = 0;
    private String date;
    private Hashtable<String, Integer> colors = new Hashtable();
    private Hashtable<String, String> dyes = new Hashtable();
    private Hashtable<String, Integer> realColors = new Hashtable();

    public ND2Handler(CoreMetadata[] core) {
        this.core = core;
    }

    public CoreMetadata[] getCoreMetadata() {
        return this.core;
    }

    public void populateROIs(MetadataStore store) {
        for (int r = 0; r < this.rois.size(); ++r) {
            int i;
            Hashtable<String, String> roi = this.rois.get(r);
            String type = roi.get("ROIType");
            if (type.equals("Text")) {
                store.setROIID(MetadataTools.createLSID("ROI", r), r);
                store.setTextID(MetadataTools.createLSID("Shape", r, 0), r, 0);
                store.setTextFontSize(NonNegativeInteger.valueOf((String)roi.get("fHeight")), r, 0);
                store.setTextValue(roi.get("eval-text"), r, 0);
                store.setTextStrokeWidth(new Double(roi.get("line-width")), r, 0);
                String rectangle = roi.get("rectangle");
                String[] p = rectangle.split(",");
                double[] points = new double[p.length];
                for (i = 0; i < p.length; ++i) {
                    points[i] = Double.parseDouble(p[i]);
                }
                store.setRectangleID(MetadataTools.createLSID("Shape", r, 1), r, 1);
                store.setRectangleX(points[0], r, 1);
                store.setRectangleY(points[1], r, 1);
                store.setRectangleWidth(points[2] - points[0], r, 1);
                store.setRectangleHeight(points[3] - points[1], r, 1);
                continue;
            }
            if (!type.equals("HorizontalLine") && !type.equals("VerticalLine")) continue;
            store.setROIID(MetadataTools.createLSID("ROI", r), r);
            String segments = roi.get("segments");
            segments = segments.replaceAll("\\[\\]", "");
            String[] points = segments.split("\\)");
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < points.length; ++i) {
                points[i] = points[i].substring(points[i].indexOf(":") + 1);
                sb.append(points[i]);
                if (i >= points.length - 1) continue;
                sb.append(" ");
            }
            store.setPolylineID(MetadataTools.createLSID("Shape", r, 0), r, 0);
            store.setPolylinePoints(sb.toString(), r, 0);
        }
    }

    public String getDate() {
        return this.date;
    }

    public Hashtable<String, Object> getMetadata() {
        return this.metadata;
    }

    public int getSeriesCount() {
        return this.numSeries;
    }

    public boolean isLossless() {
        return this.isLossless;
    }

    public ArrayList<Long> getZSections() {
        return this.zs;
    }

    public ArrayList<Long> getTimepoints() {
        return this.ts;
    }

    public double getPixelSizeX() {
        return this.pixelSizeX;
    }

    public double getPixelSizeY() {
        return this.pixelSizeY;
    }

    public double getPixelSizeZ() {
        return this.pixelSizeZ;
    }

    public Double getPinholeSize() {
        return this.pinholeSize;
    }

    public Double getVoltage() {
        return this.voltage;
    }

    public Double getMagnification() {
        return this.mag;
    }

    public Double getNumericalAperture() {
        return this.na;
    }

    public String getObjectiveModel() {
        return this.objectiveModel;
    }

    public String getImmersion() {
        return this.immersion;
    }

    public String getCorrection() {
        return this.correction;
    }

    public Double getRefractiveIndex() {
        return this.refractiveIndex;
    }

    public ArrayList<String> getChannelNames() {
        return this.channelNames;
    }

    public ArrayList<String> getModalities() {
        return this.modality;
    }

    public ArrayList<String> getBinnings() {
        return this.binning;
    }

    public ArrayList<Double> getSpeeds() {
        return this.speed;
    }

    public ArrayList<Double> getGains() {
        return this.gain;
    }

    public ArrayList<Double> getTemperatures() {
        return this.temperature;
    }

    public ArrayList<Double> getExposureTimes() {
        return this.exposureTime;
    }

    public ArrayList<Integer> getExcitationWavelengths() {
        return this.exWave;
    }

    public ArrayList<Integer> getEmissionWavelengths() {
        return this.emWave;
    }

    public ArrayList<Integer> getPowers() {
        return this.power;
    }

    public ArrayList<Hashtable<String, String>> getROIs() {
        return this.rois;
    }

    public ArrayList<Double> getXPositions() {
        return this.posX;
    }

    public ArrayList<Double> getYPositions() {
        return this.posY;
    }

    public ArrayList<Double> getZPositions() {
        return this.posZ;
    }

    public String getCameraModel() {
        return this.cameraModel;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    public Hashtable<String, Integer> getChannelColors() {
        return this.realColors;
    }

    public void endElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("CalibrationSeq") || qName.equals("MetadataSeq")) {
            this.prefix = null;
        }
        if (qName.equals(this.prevElement)) {
            this.prevElement = null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("CLxListVariant".equals(attributes.getValue("runtype"))) {
            this.prevElement = qName;
        }
        String value = attributes.getValue("value");
        if (qName.equals("uiWidth")) {
            this.core[0].sizeX = Integer.parseInt(value);
        } else if (qName.equals("uiWidthBytes") || qName.equals("uiBpcInMemory")) {
            int div = qName.equals("uiWidthBytes") ? this.core[0].sizeX : 8;
            int bytes = Integer.parseInt(value) / div;
            try {
                this.core[0].pixelType = FormatTools.pixelTypeFromBytes(bytes, false, false);
            }
            catch (FormatException e) {
                // empty catch block
            }
            this.parseKeyAndValue(qName, value, this.prevRuntype);
        } else if ("dPosX".equals(this.prevElement) && qName.startsWith("item_")) {
            this.posX.add(new Double(this.sanitizeDouble(value)));
            this.metadata.put("X position for position #" + this.posX.size(), value);
        } else if ("dPosY".equals(this.prevElement) && qName.startsWith("item_")) {
            this.posY.add(new Double(this.sanitizeDouble(value)));
            this.metadata.put("Y position for position #" + this.posY.size(), value);
        } else if ("dPosZ".equals(this.prevElement) && qName.startsWith("item_")) {
            this.posZ.add(new Double(this.sanitizeDouble(value)));
            this.metadata.put("Z position for position #" + this.posZ.size(), value);
        } else if (qName.startsWith("item_")) {
            int v = Integer.parseInt(qName.substring(qName.indexOf("_") + 1));
            if (v == this.numSeries) {
                this.fieldIndex = this.core[0].dimensionOrder.length();
                ++this.numSeries;
            } else if (v < this.numSeries && this.fieldIndex < this.core[0].dimensionOrder.length()) {
                this.fieldIndex = this.core[0].dimensionOrder.length();
            }
        } else if (qName.equals("uiCompCount")) {
            int v = Integer.parseInt(value);
            this.core[0].sizeC = Math.max(this.core[0].sizeC, v);
        } else if (qName.equals("uiHeight")) {
            this.core[0].sizeY = Integer.parseInt(value);
        } else if (qName.startsWith("TextInfo")) {
            this.parseKeyAndValue(qName, attributes.getValue("Text"), this.prevRuntype);
            this.parseKeyAndValue(qName, value, this.prevRuntype);
        } else if (qName.equals("dCompressionParam")) {
            this.isLossless = Integer.parseInt(value) > 0;
            this.parseKeyAndValue(qName, value, this.prevRuntype);
        } else if (qName.equals("CalibrationSeq") || qName.equals("MetadataSeq")) {
            this.prefix = qName + " " + attributes.getValue("_SEQUENCE_INDEX");
        } else if (qName.equals("HorizontalLine") || qName.equals("VerticalLine") || qName.equals("Text")) {
            Hashtable<String, String> roi = new Hashtable<String, String>();
            roi.put("ROIType", qName);
            for (int q = 0; q < attributes.getLength(); ++q) {
                roi.put(attributes.getQName(q), attributes.getValue(q));
            }
            this.rois.add(roi);
        } else if (qName.equals("dPinholeRadius")) {
            this.pinholeSize = new Double(this.sanitizeDouble(value));
            this.metadata.put("Pinhole size", value);
        } else if (qName.endsWith("ChannelColor")) {
            String name = qName.substring(0, qName.indexOf("Channel"));
            this.colors.put(name, new Integer(value));
        } else if (qName.endsWith("DyeName")) {
            int channelIndex = qName.indexOf("Channel");
            if (channelIndex < 0) {
                channelIndex = 0;
            }
            this.dyes.put(qName.substring(0, channelIndex), value);
        } else {
            StringBuffer sb = new StringBuffer();
            if (this.prefix != null) {
                sb.append(this.prefix);
                sb.append(" ");
            }
            sb.append(qName);
            this.parseKeyAndValue(sb.toString(), value, this.prevRuntype);
        }
        this.prevRuntype = attributes.getValue("runtype");
    }

    @Override
    public void endDocument() {
        for (String name : this.colors.keySet()) {
            String chName = this.dyes.get(name);
            if (chName == null) {
                chName = name;
            }
            this.realColors.put(chName, this.colors.get(name));
        }
    }

    private void parseKeyAndValue(String key, String value, String runtype) {
        if (key == null || value == null) {
            return;
        }
        this.metadata.put(key, value);
        if (key.endsWith("dCalibration")) {
            this.pixelSizeY = this.pixelSizeX = Double.parseDouble(this.sanitizeDouble(value));
        } else if (key.endsWith("dZStep")) {
            this.pixelSizeZ = Double.parseDouble(this.sanitizeDouble(value));
        } else if (key.endsWith("Gain")) {
            if (!(value = this.sanitizeDouble(value)).equals("")) {
                this.gain.add(new Double(value));
            }
        } else if (key.endsWith("dLampVoltage")) {
            this.voltage = new Double(this.sanitizeDouble(value));
        } else if (key.endsWith("dObjectiveMag") && this.mag == null) {
            this.mag = new Double(this.sanitizeDouble(value));
        } else if (key.endsWith("dObjectiveNA")) {
            this.na = new Double(this.sanitizeDouble(value));
        } else if (key.endsWith("dRefractIndex1")) {
            this.refractiveIndex = new Double(this.sanitizeDouble(value));
        } else if (key.equals("sObjective") || key.equals("wsObjectiveName") || key.equals("sOptics")) {
            String[] tokens = value.split(" ");
            int magIndex = -1;
            for (int i = 0; i < tokens.length; ++i) {
                if (tokens[i].indexOf("x") == -1) continue;
                magIndex = i;
                break;
            }
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < magIndex; ++i) {
                s.append(tokens[i]);
            }
            this.correction = s.toString();
            if (magIndex >= 0) {
                String m = tokens[magIndex].substring(0, tokens[magIndex].indexOf("x"));
                if ((m = this.sanitizeDouble(m)).length() > 0) {
                    this.mag = new Double(m);
                }
            }
            if (magIndex + 1 < tokens.length) {
                this.immersion = tokens[magIndex + 1];
            }
        } else if (key.endsWith("dTimeMSec")) {
            long v = (long)Double.parseDouble(this.sanitizeDouble(value));
            if (!this.ts.contains(new Long(v))) {
                this.ts.add(new Long(v));
                this.metadata.put("number of timepoints", this.ts.size());
            }
        } else if (key.endsWith("dZPos")) {
            long v = (long)Double.parseDouble(this.sanitizeDouble(value));
            if (!this.zs.contains(new Long(v))) {
                this.zs.add(new Long(v));
            }
        } else if (key.endsWith("uiCount")) {
            if (runtype != null) {
                if (runtype.endsWith("ZStackLoop")) {
                    if (this.core[0].sizeZ == 0) {
                        this.core[0].sizeZ = Integer.parseInt(value);
                        if (this.core[0].dimensionOrder.indexOf("Z") == -1) {
                            this.core[0].dimensionOrder = "Z" + this.core[0].dimensionOrder;
                        }
                    }
                } else if (runtype.endsWith("TimeLoop") && this.core[0].sizeT == 0) {
                    this.core[0].sizeT = Integer.parseInt(value);
                    if (this.core[0].dimensionOrder.indexOf("T") == -1) {
                        this.core[0].dimensionOrder = "T" + this.core[0].dimensionOrder;
                    }
                }
            }
        } else if (key.endsWith("uiBpcSignificant")) {
            this.core[0].bitsPerPixel = Integer.parseInt(value);
        } else if (key.equals("VirtualComponents")) {
            if (this.core[0].sizeC == 0) {
                this.core[0].sizeC = Integer.parseInt(value);
                if (this.core[0].dimensionOrder.indexOf("C") == -1) {
                    this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C" + this.core[0].dimensionOrder;
                }
            }
        } else if (key.startsWith("TextInfoItem") || key.endsWith("TextInfoItem")) {
            String[] tokens;
            this.metadata.remove(key);
            value = value.replaceAll("&#x000d;&#x000a;", "\n");
            for (String t : tokens = value.split("\n")) {
                if ((t = t.trim()).startsWith("Dimensions:")) {
                    t = t.substring(11);
                    String[] dims = t.split(" x ");
                    if (this.core[0].sizeZ == 0) {
                        this.core[0].sizeZ = 1;
                    }
                    if (this.core[0].sizeT == 0) {
                        this.core[0].sizeT = 1;
                    }
                    if (this.core[0].sizeC == 0) {
                        this.core[0].sizeC = 1;
                    }
                    for (String dim : dims) {
                        dim = dim.trim();
                        int v = Integer.parseInt(dim.replaceAll("\\D", ""));
                        v = Math.max(v, 1);
                        if (dim.startsWith("XY")) {
                            this.numSeries = v;
                            if (this.numSeries <= 1) continue;
                            int x = this.core[0].sizeX;
                            int y = this.core[0].sizeY;
                            int z = this.core[0].sizeZ;
                            int tSize = this.core[0].sizeT;
                            int c = this.core[0].sizeC;
                            String order = this.core[0].dimensionOrder;
                            this.core = new CoreMetadata[this.numSeries];
                            for (int i = 0; i < this.numSeries; ++i) {
                                this.core[i] = new CoreMetadata();
                                this.core[i].sizeX = x;
                                this.core[i].sizeY = y;
                                this.core[i].sizeZ = z == 0 ? 1 : z;
                                this.core[i].sizeC = c == 0 ? 1 : c;
                                this.core[i].sizeT = tSize == 0 ? 1 : tSize;
                                this.core[i].dimensionOrder = order;
                            }
                            continue;
                        }
                        if (dim.startsWith("T")) {
                            if (this.core[0].sizeT > 1 && v >= this.core[0].sizeT) continue;
                            this.core[0].sizeT = v;
                            continue;
                        }
                        if (dim.startsWith("Z")) {
                            if (this.core[0].sizeZ > 1) continue;
                            this.core[0].sizeZ = v;
                            continue;
                        }
                        if (this.core[0].sizeC > 1) continue;
                        this.core[0].sizeC = v;
                    }
                    this.core[0].imageCount = this.core[0].sizeZ * this.core[0].sizeC * this.core[0].sizeT;
                    continue;
                }
                if (t.startsWith("Number of Picture Planes")) {
                    this.core[0].sizeC = Integer.parseInt(t.replaceAll("\\D", ""));
                    continue;
                }
                String[] v = t.split(":");
                if (v.length == 2) {
                    v[1] = v[1].trim();
                    if (v[0].equals("Name")) {
                        this.channelNames.add(v[1]);
                        continue;
                    }
                    if (v[0].equals("Modality")) {
                        this.modality.add(v[1]);
                        continue;
                    }
                    if (v[0].equals("Camera Type")) {
                        this.cameraModel = v[1];
                        continue;
                    }
                    if (v[0].equals("Binning")) {
                        this.binning.add(v[1]);
                        continue;
                    }
                    if (v[0].equals("Readout Speed")) {
                        int last = v[1].lastIndexOf(" ");
                        if (last != -1) {
                            v[1] = v[1].substring(0, last);
                        }
                        this.speed.add(new Double(this.sanitizeDouble(v[1])));
                        continue;
                    }
                    if (v[0].equals("Temperature")) {
                        String temp = v[1].replaceAll("[\\D&&[^-.]]", "");
                        this.temperature.add(new Double(this.sanitizeDouble(temp)));
                        continue;
                    }
                    if (v[0].equals("Exposure")) {
                        String[] s = v[1].trim().split(" ");
                        try {
                            double time = Double.parseDouble(this.sanitizeDouble(s[0]));
                            if (s[1].equals("ms")) {
                                time /= 1000.0;
                            }
                            this.exposureTime.add(new Double(time));
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    if (!v[0].equals("{Pinhole Size}")) continue;
                    this.pinholeSize = new Double(this.sanitizeDouble(v[1]));
                    this.metadata.put("Pinhole size", v[1]);
                    continue;
                }
                if (v[0].startsWith("- Step")) {
                    int space = v[0].indexOf(" ", v[0].indexOf("Step") + 1);
                    int last = v[0].indexOf(" ", space + 1);
                    if (last == -1) {
                        last = v[0].length();
                    }
                    this.pixelSizeZ = Double.parseDouble(this.sanitizeDouble(v[0].substring(space, last)));
                    continue;
                }
                if (v[0].equals("Line")) {
                    String[] values = t.split(";");
                    for (int q = 0; q < values.length; ++q) {
                        int colon = values[q].indexOf(":");
                        if (colon < 0) continue;
                        String nextKey = values[q].substring(0, colon).trim();
                        String nextValue = values[q].substring(colon + 1).trim();
                        if (nextKey.equals("Emission wavelength")) {
                            this.emWave.add(new Integer(nextValue));
                            continue;
                        }
                        if (nextKey.equals("Excitation wavelength")) {
                            this.exWave.add(new Integer(nextValue));
                            continue;
                        }
                        if (!nextKey.equals("Power")) continue;
                        nextValue = this.sanitizeDouble(nextValue);
                        this.power.add(new Integer((int)Double.parseDouble(nextValue)));
                    }
                    continue;
                }
                if (v.length <= 1) continue;
                v[0] = v[0].replace('{', ' ');
                v[0] = v[0].replace('}', ' ');
                this.metadata.put(v[0].trim(), v[1]);
            }
        } else if (key.equals("CameraUniqueName")) {
            this.cameraModel = value;
        } else if (key.equals("ExposureTime")) {
            this.exposureTime.add(new Double(value) / 1000.0);
        } else if (key.equals("sDate")) {
            this.date = DateTools.formatDate(value, DATE_FORMAT);
        }
    }

    private String sanitizeDouble(String value) {
        char separator;
        if ((value = value.replaceAll("[^0-9,\\.]", "")).indexOf(separator = new DecimalFormatSymbols().getDecimalSeparator()) == -1) {
            char usedSeparator = separator == '.' ? (char)',' : '.';
            value = value.replace(usedSeparator, separator);
            try {
                Double.parseDouble(value);
            }
            catch (Exception e) {
                value = value.replace(separator, usedSeparator);
            }
        }
        return value;
    }
}

