/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.util.Hashtable;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;

public class CoreMetadata {
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    public int sizeC;
    public int sizeT;
    public int thumbSizeX;
    public int thumbSizeY;
    public int pixelType;
    public int bitsPerPixel;
    public int imageCount;
    public int[] cLengths;
    public String[] cTypes;
    public String dimensionOrder;
    public boolean orderCertain;
    public boolean rgb;
    public boolean littleEndian;
    public boolean interleaved;
    public boolean indexed;
    public boolean falseColor;
    public boolean metadataComplete;
    public Hashtable<String, Object> seriesMetadata;
    public boolean thumbnail;

    public CoreMetadata() {
        this.seriesMetadata = new Hashtable();
    }

    public CoreMetadata(IFormatReader r, int seriesNo) {
        int series = r.getSeries();
        r.setSeries(seriesNo);
        this.sizeX = r.getSizeX();
        this.sizeY = r.getSizeY();
        this.sizeZ = r.getSizeZ();
        this.sizeC = r.getSizeC();
        this.sizeT = r.getSizeT();
        this.thumbSizeX = r.getThumbSizeX();
        this.thumbSizeY = r.getThumbSizeY();
        this.pixelType = r.getPixelType();
        this.bitsPerPixel = r.getBitsPerPixel();
        this.imageCount = r.getImageCount();
        this.cLengths = r.getChannelDimLengths();
        this.cTypes = r.getChannelDimTypes();
        this.dimensionOrder = r.getDimensionOrder();
        this.orderCertain = r.isOrderCertain();
        this.rgb = r.isRGB();
        this.littleEndian = r.isLittleEndian();
        this.interleaved = r.isInterleaved();
        this.indexed = r.isIndexed();
        this.falseColor = r.isFalseColor();
        this.metadataComplete = r.isMetadataComplete();
        this.seriesMetadata = r.getSeriesMetadata();
        this.thumbnail = r.isThumbnailSeries();
        r.setSeries(series);
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString() + ":");
        sb.append("\n\tsizeX = " + this.sizeX);
        sb.append("\n\tsizeY = " + this.sizeY);
        sb.append("\n\tsizeZ = " + this.sizeZ);
        sb.append("\n\tsizeC = " + this.sizeC);
        sb.append("\n\tsizeT = " + this.sizeT);
        sb.append("\n\tthumbSizeX = " + this.thumbSizeX);
        sb.append("\n\tthumbSizeY = " + this.thumbSizeY);
        sb.append("\n\tpixelType = " + FormatTools.getPixelTypeString(this.pixelType));
        sb.append("\n\tbitsPerPixel = " + this.bitsPerPixel);
        sb.append("\n\timageCount = " + this.imageCount);
        sb.append("\n\tcLengths =");
        if (this.cLengths == null) {
            sb.append(" null");
        } else {
            for (i = 0; i < this.cLengths.length; ++i) {
                sb.append(" " + this.cLengths[i]);
            }
        }
        sb.append("\n\tcTypes =");
        if (this.cTypes == null) {
            sb.append(" null");
        } else {
            for (i = 0; i < this.cTypes.length; ++i) {
                sb.append(" " + this.cTypes[i]);
            }
        }
        sb.append("\n\tdimensionOrder = " + this.dimensionOrder);
        sb.append("\n\torderCertain = " + this.orderCertain);
        sb.append("\n\trgb = " + this.rgb);
        sb.append("\n\tlittleEndian = " + this.littleEndian);
        sb.append("\n\tinterleaved = " + this.interleaved);
        sb.append("\n\tindexed = " + this.indexed);
        sb.append("\n\tfalseColor = " + this.falseColor);
        sb.append("\n\tmetadataComplete = " + this.metadataComplete);
        sb.append("\n\tseriesMetadata = " + this.seriesMetadata.size() + " keys");
        sb.append("\n\tthumbnail = " + this.thumbnail);
        return sb.toString();
    }
}

