/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.POIService;

public class TillVisionReader
extends FormatReader {
    private static final byte[] MARKER_0 = new byte[]{-128, 3, 0};
    private static final byte[] MARKER_1 = new byte[]{-127, 3, 0};
    private static final String[] DATE_FORMATS = new String[]{"mm/dd/yy HH:mm:ss aa", "mm/dd/yy HH:mm:ss.SSS aa", "mm/dd/yy", "HH:mm:ss aa", "HH:mm:ss.SSS aa"};
    private String[] pixelsFiles;
    private RandomAccessInputStream pixelsStream;
    private Hashtable<Integer, Double> exposureTimes;
    private boolean embeddedImages;
    private long embeddedOffset;
    private String[] infFiles;
    private Vector<String> imageNames = new Vector();
    private Vector<String> types = new Vector();
    private Vector<String> dates = new Vector();

    public TillVisionReader() {
        super("TillVision", new String[]{"vws", "pst"});
        this.domains = new String[]{"Light Microscopy"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int plane = FormatTools.getPlaneSize(this);
        if (this.embeddedImages) {
            this.in.seek(this.embeddedOffset + (long)(no * plane));
            this.readPlane(this.in, x, y, w, h, buf);
        } else {
            this.pixelsStream = new RandomAccessInputStream(this.pixelsFiles[this.series]);
            if ((long)((no + 1) * plane) <= this.pixelsStream.length()) {
                this.pixelsStream.seek(no * plane);
                this.readPlane(this.pixelsStream, x, y, w, h, buf);
            }
            this.pixelsStream.close();
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.pixelsStream != null) {
                this.pixelsStream.close();
            }
            this.pixelsStream = null;
            this.pixelsFiles = null;
            this.infFiles = null;
            this.embeddedOffset = 0L;
            this.embeddedImages = false;
            this.exposureTimes = null;
            this.imageNames.clear();
            this.types.clear();
            this.dates.clear();
        }
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return !new Location(id.replaceAll(".vws", ".pst")).exists();
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        files.add(this.currentId);
        if (!noPixels && this.pixelsFiles[this.getSeries()] != null) {
            files.add(this.pixelsFiles[this.getSeries()]);
        }
        if (this.infFiles[this.getSeries()] != null) {
            files.add(this.infFiles[this.getSeries()]);
        }
        return files.toArray(new String[files.size()]);
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (!TillVisionReader.checkSuffix(id, "vws")) {
            Location pst = new Location(id).getAbsoluteFile();
            String name = pst.getParentFile().getName();
            Location parent = pst.getParentFile().getParentFile();
            Location vwsFile = new Location(parent, name.replaceAll(".pst", ".vws"));
            if (vwsFile.exists()) {
                id = vwsFile.getAbsolutePath();
            } else {
                throw new FormatException("Could not find .vws file.");
            }
        }
        super.initFile(id);
        this.exposureTimes = new Hashtable();
        POIService poi = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            poi = factory.getInstance(POIService.class);
        }
        catch (DependencyException de) {
            throw new FormatException("POI library not found", de);
        }
        poi.initialize(id);
        Vector<String> documents = poi.getDocumentList();
        int nImages = 0;
        Hashtable<String, Object> tmpSeriesMetadata = new Hashtable<String, Object>();
        for (String name : documents) {
            LOGGER.debug("Reading {}", (Object)name);
            if (!name.equals("Root Entry" + File.separator + "Contents")) continue;
            RandomAccessInputStream s = poi.getDocumentStream(name);
            s.order(true);
            boolean nFound = false;
            this.embeddedImages = s.read() == 1;
            LOGGER.debug("Images are {}embedded", (Object)(this.embeddedImages ? "" : "not "));
            if (this.embeddedImages) {
                s.skipBytes(12);
                int len = s.readShort();
                String type = s.readString(len);
                if (!type.equals("CImage")) {
                    this.embeddedImages = false;
                    s.close();
                    continue;
                }
                s.seek(27L);
                len = s.read();
                while (len != 0) {
                    s.skipBytes(len);
                    len = s.read();
                }
                s.skipBytes(1243);
                this.core[0].sizeX = s.readInt();
                this.core[0].sizeY = s.readInt();
                this.core[0].sizeZ = s.readInt();
                this.core[0].sizeC = s.readInt();
                this.core[0].sizeT = s.readInt();
                this.core[0].pixelType = this.convertPixelType(s.readInt());
                this.embeddedOffset = s.getFilePointer() + 28L;
                if (this.in != null) {
                    this.in.close();
                }
                this.in = poi.getDocumentStream(name);
                ++nImages;
                s.close();
                break;
            }
            byte[] marker = this.getMarker(s);
            if (marker == null) {
                throw new FormatException("Could not find known marker.");
            }
            LOGGER.debug("Marker: {}, {}, {}", new Object[]{marker[0], marker[1], marker[2]});
            s.seek(0L);
            while (s.getFilePointer() < s.length() - 2L) {
                String[] lines;
                LOGGER.debug("  Looking for image at {}", (Object)s.getFilePointer());
                s.order(false);
                int nextOffset = this.findNextOffset(s, marker);
                if (nextOffset < 0 || (long)nextOffset >= s.length()) break;
                s.seek(nextOffset);
                s.skipBytes(3);
                short len = s.readShort();
                if (len <= 0) continue;
                this.imageNames.add(s.readString(len));
                s.skipBytes(6);
                s.order(true);
                len = s.readShort();
                if (len < 0 || len > 4096) continue;
                String description = s.readString(len);
                LOGGER.debug("Description: {}", (Object)description);
                String dateTime = "";
                for (String line : lines = description.split("[\r\n]")) {
                    int colon = (line = line.trim()).indexOf(":");
                    if (colon == -1 || line.startsWith(";")) continue;
                    String key = line.substring(0, colon).trim();
                    String value = line.substring(colon + 1).trim();
                    String metaKey = "Series " + nImages + " " + key;
                    this.addMeta(metaKey, value, tmpSeriesMetadata);
                    if (key.equals("Start time of experiment")) {
                        dateTime = dateTime + " " + value;
                        continue;
                    }
                    if (key.equals("Date")) {
                        dateTime = value + " " + dateTime;
                        continue;
                    }
                    if (key.equals("Exposure time [ms]")) {
                        double exp = Double.parseDouble(value) / 1000.0;
                        this.exposureTimes.put(new Integer(nImages), new Double(exp));
                        continue;
                    }
                    if (!key.equals("Image type")) continue;
                    this.types.add(value);
                }
                if (!(dateTime = dateTime.trim()).equals("")) {
                    boolean success = false;
                    for (String format : DATE_FORMATS) {
                        try {
                            dateTime = DateTools.formatDate(dateTime, format);
                            success = true;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                    this.dates.add(success ? dateTime : "");
                }
                ++nImages;
            }
            s.close();
        }
        Location directory = new Location(this.currentId).getAbsoluteFile().getParentFile();
        Object[] pixelsFile = new String[nImages];
        if (!this.embeddedImages) {
            if (nImages == 0) {
                throw new FormatException("No images found.");
            }
            this.core = new CoreMetadata[nImages];
            String[] files = directory.list(true);
            String name = this.currentId.substring(this.currentId.lastIndexOf(File.separator) + 1, this.currentId.lastIndexOf("."));
            int nextFile = 0;
            for (String f : files) {
                String[] subfiles;
                Location pst;
                if (!TillVisionReader.checkSuffix(f, "pst") || !(pst = new Location(directory, f)).isDirectory() || !f.startsWith(name)) continue;
                for (String q : subfiles = pst.list(true)) {
                    if (!TillVisionReader.checkSuffix(q, "pst") || nextFile >= nImages) continue;
                    pixelsFile[nextFile++] = f + File.separator + q;
                }
            }
            if (nextFile == 0) {
                for (String f : files) {
                    if (!TillVisionReader.checkSuffix(f, "pst")) continue;
                    pixelsFile[nextFile++] = new Location(directory, f).getAbsolutePath();
                }
                if (nextFile == 0) {
                    throw new FormatException("No image files found.");
                }
            }
        }
        Arrays.sort(pixelsFile);
        this.pixelsFiles = new String[this.getSeriesCount()];
        this.infFiles = new String[this.getSeriesCount()];
        Object[] metadataKeys = tmpSeriesMetadata.keySet().toArray();
        IniParser parser = new IniParser();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            if (!this.embeddedImages) {
                String inf;
                this.core[i] = new CoreMetadata();
                this.setSeries(i);
                Object file = pixelsFile[i];
                file = ((String)file).replace('/', File.separatorChar);
                Object oldFile = file = ((String)file).replace('\\', File.separatorChar);
                Location f = new Location(directory, (String)oldFile);
                if (!f.exists() && !(f = new Location(directory, (String)(oldFile = ((String)oldFile).substring(((String)oldFile).lastIndexOf(File.separator) + 1)))).exists()) {
                    throw new FormatException("Could not find pixels file '" + (String)file);
                }
                this.pixelsFiles[i] = file = f.getAbsolutePath();
                int dot = ((String)file).lastIndexOf(".");
                this.infFiles[i] = inf = ((String)file).substring(0, dot) + ".inf";
                BufferedReader reader = new BufferedReader(new FileReader(inf));
                IniList data = parser.parseINI(reader);
                reader.close();
                IniTable infoTable = data.getTable("Info");
                this.core[i].sizeX = Integer.parseInt((String)infoTable.get("Width"));
                this.core[i].sizeY = Integer.parseInt((String)infoTable.get("Height"));
                this.core[i].sizeC = Integer.parseInt((String)infoTable.get("Bands"));
                this.core[i].sizeZ = Integer.parseInt((String)infoTable.get("Slices"));
                this.core[i].sizeT = Integer.parseInt((String)infoTable.get("Frames"));
                int dataType = Integer.parseInt((String)infoTable.get("Datatype"));
                this.core[i].pixelType = this.convertPixelType(dataType);
                if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                    HashMap<String, String> iniMap = data.flattenIntoHashMap();
                    this.core[i].seriesMetadata.putAll(iniMap);
                }
            }
            this.core[i].imageCount = this.core[i].sizeZ * this.core[i].sizeC * this.core[i].sizeT;
            this.core[i].rgb = false;
            this.core[i].littleEndian = true;
            this.core[i].dimensionOrder = "XYCZT";
            this.core[i].seriesMetadata = new Hashtable();
            for (Object key : metadataKeys) {
                String keyName = key.toString();
                if (!keyName.startsWith("Series " + i + " ")) continue;
                keyName = keyName.replaceAll("Series " + i + " ", "");
                this.core[i].seriesMetadata.put(keyName, tmpSeriesMetadata.get(key));
            }
        }
        tmpSeriesMetadata = null;
        this.populateMetadataStore();
        poi.close();
        poi = null;
    }

    private void populateMetadataStore() throws FormatException {
        int i;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            String date;
            if (i < this.imageNames.size()) {
                store.setImageName(this.imageNames.get(i), i);
            }
            String string = date = i < this.dates.size() ? this.dates.get(i) : "";
            if (date != null && !date.equals("")) {
                store.setImageAcquiredDate(date, i);
                continue;
            }
            MetadataTools.setDefaultCreationDate(store, this.currentId, i);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (i = 0; i < this.getSeriesCount(); ++i) {
                for (int q = 0; q < this.core[i].imageCount; ++q) {
                    store.setPlaneExposureTime(this.exposureTimes.get(i), i, q);
                }
                if (i >= this.types.size()) continue;
                store.setExperimentID(MetadataTools.createLSID("Experiment", i), i);
                store.setExperimentType(this.getExperimentType(this.types.get(i)), i);
            }
        }
    }

    private int convertPixelType(int type) throws FormatException {
        boolean signed = type % 2 == 1;
        int bytes = type / 2 + (signed ? 1 : 0);
        return FormatTools.pixelTypeFromBytes(bytes, signed, false);
    }

    private byte[] getMarker(RandomAccessInputStream s) throws IOException {
        s.seek(0L);
        int offset = this.findNextOffset(s, MARKER_0);
        if (offset != -1) {
            return MARKER_0;
        }
        s.seek(0L);
        offset = this.findNextOffset(s, MARKER_1);
        return offset == -1 ? null : MARKER_1;
    }

    private int findNextOffset(RandomAccessInputStream s, byte[] marker) throws IOException {
        for (long i = s.getFilePointer(); i < s.length() - (long)marker.length; ++i) {
            s.seek(i);
            boolean found = true;
            for (int q = 0; q < marker.length; ++q) {
                if (marker[q] == s.readByte()) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return (int)(i + (long)marker.length);
        }
        return -1;
    }
}

