// **********************************************************************
//
// Copyright (c) 2003-2008 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.3.0

package monitors;

public enum FileType
{
    File,
    Dir,
    Link,
    Mount,
    Unknown;

    public static final int _File = 0;
    public static final int _Dir = 1;
    public static final int _Link = 2;
    public static final int _Mount = 3;
    public static final int _Unknown = 4;

    public static FileType
    convert(int val)
    {
        assert val >= 0 && val < 5;
        return values()[val];
    }

    public static FileType
    convert(String val)
    {
        try
        {
            return valueOf(val);
        }
        catch(java.lang.IllegalArgumentException ex)
        {
            return null;
        }
    }

    public int
    value()
    {
        return ordinal();
    }

    public void
    __write(IceInternal.BasicStream __os)
    {
        __os.writeByte((byte)value());
    }

    public static FileType
    __read(IceInternal.BasicStream __is)
    {
        int __v = __is.readByte(5);
        return FileType.convert(__v);
    }
}
