// **********************************************************************
//
// Copyright (c) 2003-2008 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.3.0

package monitors;

public interface _MonitorServerOperationsNC
{
    String createMonitor(EventType eType, String pathString, String[] whitelist, String[] blacklist, PathMode pMode, MonitorClientPrx proxy)
        throws OmeroFSError;

    void startMonitor(String id)
        throws OmeroFSError;

    void stopMonitor(String id)
        throws OmeroFSError;

    void destroyMonitor(String id)
        throws OmeroFSError;

    MonitorState getMonitorState(String id)
        throws OmeroFSError;

    String[] getMonitorDirectory(String id, String relPath, String filter)
        throws OmeroFSError;

    String[] getDirectory(String absPath, String filter)
        throws OmeroFSError;

    String getBaseName(String fileId)
        throws OmeroFSError;

    FileStats getStats(String fileId)
        throws OmeroFSError;

    long getSize(String fileId)
        throws OmeroFSError;

    String getOwner(String fileId)
        throws OmeroFSError;

    float getCTime(String fileId)
        throws OmeroFSError;

    float getMTime(String fileId)
        throws OmeroFSError;

    float getATime(String fileId)
        throws OmeroFSError;

    boolean isDir(String fileId)
        throws OmeroFSError;

    boolean isFile(String fileId)
        throws OmeroFSError;

    String getSHA1(String fileId)
        throws OmeroFSError;

    byte[] readBlock(String fileId, long offset, int size)
        throws OmeroFSError;
}
