/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.Instrument;
import ome.model.enums.Correction;
import ome.model.enums.Immersion;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="objective_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="objective_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="objective_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="objective_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="objective_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="objective_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="objective_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="objective_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="objective", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_objective", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_objective"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Objective
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "objective_owner_filter";
    public static final String GROUP_FILTER = "objective_group_filter";
    public static final String EVENT_FILTER = "objective_event_filter";
    public static final String PERMS_FILTER = "objective_perms_filter";
    public static final String ID = "ome.model.acquisition.Objective_id";
    protected Long id;
    public static final String VERSION = "ome.model.acquisition.Objective_version";
    protected Integer version = 0;
    protected String manufacturer = null;
    protected String model = null;
    protected String serialNumber = null;
    protected Integer nominalMagnification = null;
    protected Double calibratedMagnification = null;
    protected Double lensNA = null;
    protected Immersion immersion = null;
    protected Correction correction = null;
    protected Double workingDistance = null;
    protected Boolean iris = null;
    protected Instrument instrument = null;
    protected ome.model.internal.Details details = new Details();
    public static final String MANUFACTURER = "ome.model.acquisition.Objective_manufacturer";
    public static final String MODEL = "ome.model.acquisition.Objective_model";
    public static final String SERIALNUMBER = "ome.model.acquisition.Objective_serialNumber";
    public static final String NOMINALMAGNIFICATION = "ome.model.acquisition.Objective_nominalMagnification";
    public static final String CALIBRATEDMAGNIFICATION = "ome.model.acquisition.Objective_calibratedMagnification";
    public static final String LENSNA = "ome.model.acquisition.Objective_lensNA";
    public static final String IMMERSION = "ome.model.acquisition.Objective_immersion";
    public static final String CORRECTION = "ome.model.acquisition.Objective_correction";
    public static final String WORKINGDISTANCE = "ome.model.acquisition.Objective_workingDistance";
    public static final String IRIS = "ome.model.acquisition.Objective_iris";
    public static final String INSTRUMENT = "ome.model.acquisition.Objective_instrument";
    public static final String DETAILS = "ome.model.acquisition.Objective_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Objective() {
        this(null, true);
    }

    protected Objective(Long id) {
        this(id, true);
    }

    public Objective(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Objective(Immersion _immersion, Correction _correction, Instrument _instrument) {
        this(null, true);
        this.setImmersion(_immersion);
        this.setCorrection(_correction);
        this.setInstrument(_instrument);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_objective")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="manufacturer", updatable=true)
    public String getManufacturer() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.manufacturer = manufacturer;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="model", updatable=true)
    public String getModel() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.model;
    }

    public void setModel(String model) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.model = model;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="serialNumber", updatable=true)
    public String getSerialNumber() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.serialNumber = serialNumber;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="nominalMagnification", updatable=true)
    public Integer getNominalMagnification() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.nominalMagnification;
    }

    public void setNominalMagnification(Integer nominalMagnification) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.nominalMagnification = nominalMagnification;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="calibratedMagnification", updatable=true)
    public Double getCalibratedMagnification() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.calibratedMagnification;
    }

    public void setCalibratedMagnification(Double calibratedMagnification) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.calibratedMagnification = calibratedMagnification;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="lensNA", updatable=true)
    public Double getLensNA() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.lensNA;
    }

    public void setLensNA(Double lensNA) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.lensNA = lensNA;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Immersion.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="immersion", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKobjective_immersion_immersion")
    public Immersion getImmersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.immersion;
    }

    public void setImmersion(Immersion immersion) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.immersion = immersion;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Correction.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="correction", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKobjective_correction_correction")
    public Correction getCorrection() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.correction;
    }

    public void setCorrection(Correction correction) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.correction = correction;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="workingDistance", updatable=true)
    public Double getWorkingDistance() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.workingDistance;
    }

    public void setWorkingDistance(Double workingDistance) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.workingDistance = workingDistance;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="iris", updatable=true)
    public Boolean getIris() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.iris;
    }

    public void setIris(Boolean iris) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.iris = iris;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Instrument.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="instrument", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKobjective_instrument_instrument")
    public Instrument getInstrument() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.instrument = instrument;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Objective newInstance() {
        return new Objective();
    }

    public Objective proxy() {
        return new Objective(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.manufacturer = (String)__filter.filter(MANUFACTURER, this.manufacturer);
            this.model = (String)__filter.filter(MODEL, this.model);
            this.serialNumber = (String)__filter.filter(SERIALNUMBER, this.serialNumber);
            this.nominalMagnification = (Integer)__filter.filter(NOMINALMAGNIFICATION, this.nominalMagnification);
            this.calibratedMagnification = (Double)__filter.filter(CALIBRATEDMAGNIFICATION, this.calibratedMagnification);
            this.lensNA = (Double)__filter.filter(LENSNA, this.lensNA);
            this.immersion = (Immersion)__filter.filter(IMMERSION, this.immersion);
            this.correction = (Correction)__filter.filter(CORRECTION, this.correction);
            this.workingDistance = (Double)__filter.filter(WORKINGDISTANCE, this.workingDistance);
            this.iris = (Boolean)__filter.filter(IRIS, this.iris);
            this.instrument = (Instrument)__filter.filter(INSTRUMENT, this.instrument);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(MANUFACTURER)) {
            return this.getManufacturer();
        }
        if (field.equals(MODEL)) {
            return this.getModel();
        }
        if (field.equals(SERIALNUMBER)) {
            return this.getSerialNumber();
        }
        if (field.equals(NOMINALMAGNIFICATION)) {
            return this.getNominalMagnification();
        }
        if (field.equals(CALIBRATEDMAGNIFICATION)) {
            return this.getCalibratedMagnification();
        }
        if (field.equals(LENSNA)) {
            return this.getLensNA();
        }
        if (field.equals(IMMERSION)) {
            return this.getImmersion();
        }
        if (field.equals(CORRECTION)) {
            return this.getCorrection();
        }
        if (field.equals(WORKINGDISTANCE)) {
            return this.getWorkingDistance();
        }
        if (field.equals(IRIS)) {
            return this.getIris();
        }
        if (field.equals(INSTRUMENT)) {
            return this.getInstrument();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(MANUFACTURER)) {
            this.setManufacturer((String)value);
        } else if (field.equals(MODEL)) {
            this.setModel((String)value);
        } else if (field.equals(SERIALNUMBER)) {
            this.setSerialNumber((String)value);
        } else if (field.equals(NOMINALMAGNIFICATION)) {
            this.setNominalMagnification((Integer)value);
        } else if (field.equals(CALIBRATEDMAGNIFICATION)) {
            this.setCalibratedMagnification((Double)value);
        } else if (field.equals(LENSNA)) {
            this.setLensNA((Double)value);
        } else if (field.equals(IMMERSION)) {
            this.setImmersion((Immersion)value);
        } else if (field.equals(CORRECTION)) {
            this.setCorrection((Correction)value);
        } else if (field.equals(WORKINGDISTANCE)) {
            this.setWorkingDistance((Double)value);
        } else if (field.equals(IRIS)) {
            this.setIris((Boolean)value);
        } else if (field.equals(INSTRUMENT)) {
            this.setInstrument((Instrument)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.manufacturer = null;
        this.model = null;
        this.serialNumber = null;
        this.nominalMagnification = null;
        this.calibratedMagnification = null;
        this.lensNA = null;
        this.immersion = null;
        this.correction = null;
        this.workingDistance = null;
        this.iris = null;
        this.instrument = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(MANUFACTURER);
        raw.add(MODEL);
        raw.add(SERIALNUMBER);
        raw.add(NOMINALMAGNIFICATION);
        raw.add(CALIBRATEDMAGNIFICATION);
        raw.add(LENSNA);
        raw.add(IMMERSION);
        raw.add(CORRECTION);
        raw.add(WORKINGDISTANCE);
        raw.add(IRIS);
        raw.add(INSTRUMENT);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKobjective_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKobjective_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKobjective_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKobjective_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKobjective_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

