/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.gateway;

import Ice.Current;
import Ice.Identity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ome.services.blitz.gateway.services.DataService;
import ome.services.blitz.gateway.services.GatewayFactory;
import ome.services.blitz.gateway.services.ImageService;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.BlitzOnly;
import ome.services.blitz.util.ServiceFactoryAware;
import omero.InternalException;
import omero.RInt;
import omero.ServerError;
import omero.api.AMD_StatefulServiceInterface_activate;
import omero.api.AMD_StatefulServiceInterface_close;
import omero.api.AMD_StatefulServiceInterface_getCurrentEventContext;
import omero.api.AMD_StatefulServiceInterface_passivate;
import omero.api.ContainerClass;
import omero.api.ServiceFactoryPrx;
import omero.api.ServiceFactoryPrxHelper;
import omero.api._GatewayOperations;
import omero.model.Dataset;
import omero.model.IObject;
import omero.model.Image;
import omero.model.Pixels;
import omero.model.PixelsType;
import omero.model.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OmeroGateway
implements ServiceFactoryAware,
_GatewayOperations,
BlitzOnly {
    private ServiceFactoryPrx serviceFactory;
    private ImageService imageService;
    private DataService dataService;
    private GatewayFactory gatewayFactory;

    @Override
    public void setServiceFactory(ServiceFactoryI sf) throws ServerError {
        Identity id = sf.sessionId();
        this.serviceFactory = ServiceFactoryPrxHelper.checkedCast(sf.getAdapter().createProxy(id));
        this.createServices();
    }

    private void createServices() throws ServerError {
        this.gatewayFactory = new GatewayFactory(this.serviceFactory);
        this.imageService = this.gatewayFactory.getImageService();
        this.dataService = this.gatewayFactory.getDataService();
    }

    private void close() throws ServerError {
        this.imageService = null;
        this.dataService = null;
        this.gatewayFactory.closeService();
    }

    @Override
    public void attachImageToDataset(Dataset dataset, Image image, Current __current) throws ServerError {
        this.dataService.attachImageToDataset(dataset, image);
    }

    @Override
    public long copyPixels(long pixelsID, List<Integer> channelList, String methodology, Current __current) throws ServerError {
        return this.imageService.copyPixels(pixelsID, channelList, methodology);
    }

    @Override
    public long copyPixelsXYTZ(long pixelsID, int x, int y, int t, int z, List<Integer> channelList, String methodology, Current __current) throws ServerError {
        return this.imageService.copyPixels(pixelsID, x, y, t, z, channelList, methodology);
    }

    @Override
    public long createImage(int sizeX, int sizeY, int sizeZ, int sizeT, List<Integer> channelList, PixelsType pixelsType, String name, String description, Current __current) throws ServerError {
        return this.imageService.createImage(sizeX, sizeY, sizeZ, sizeT, channelList, pixelsType, name, description);
    }

    @Override
    public void deleteObject(IObject row, Current __current) throws ServerError {
        this.dataService.deleteObject(row);
    }

    @Override
    public List<IObject> findAllByQuery(String myQuery, Current __current) throws ServerError {
        return this.dataService.findAllByQuery(myQuery);
    }

    @Override
    public IObject findByQuery(String myQuery, Current __current) throws ServerError {
        return this.dataService.findByQuery(myQuery);
    }

    @Override
    public Dataset getDataset(long datasetId, boolean leaves, Current __current) throws ServerError {
        ArrayList<Long> datasetIdList = new ArrayList<Long>();
        datasetIdList.add(datasetId);
        List<Dataset> datasets = this.getDatasets(datasetIdList, leaves, __current);
        if (datasets.size() == 1) {
            return datasets.get(0);
        }
        return null;
    }

    @Override
    public List<Dataset> getDatasets(List<Long> ids, boolean withLeaves, Current __current) throws ServerError {
        return this.dataService.getDatasets(ids, withLeaves);
    }

    @Override
    public Image getImage(long id, Current __current) throws ServerError {
        return this.imageService.getImage(id);
    }

    @Override
    public List<Image> getImageByName(String imageName, Current __current) throws ServerError {
        return this.dataService.getImageByName(imageName);
    }

    @Override
    public List<Image> getImageFromDatasetByName(long datasetId, String imageName, Current __current) throws ServerError {
        return this.dataService.getImageFromDatasetByName(datasetId, imageName);
    }

    @Override
    public List<Image> getImages(ContainerClass parentType, List<Long> ids, Current __current) throws ServerError {
        return this.dataService.getImages(parentType, ids);
    }

    @Override
    public PixelsType getPixelType(String type, Current __current) throws ServerError {
        return this.dataService.getPixelType(type);
    }

    @Override
    public List<PixelsType> getPixelTypes(Current __current) throws ServerError {
        return this.dataService.getPixelTypes();
    }

    @Override
    public Pixels getPixels(long pixelsId, Current __current) throws ServerError {
        return this.imageService.getPixels(pixelsId);
    }

    @Override
    public List<Pixels> getPixelsFromImage(long imageId, Current __current) throws ServerError {
        return this.dataService.getPixelsFromImage(imageId);
    }

    @Override
    public List<Project> getProjects(List<Long> ids, boolean withLeaves, Current __current) throws ServerError {
        return this.dataService.getProjects(ids, withLeaves);
    }

    @Override
    public int[] getRenderedImage(long pixelsId, int z, int t, Current __current) throws ServerError {
        return this.imageService.getRenderedImage(pixelsId, z, t);
    }

    @Override
    public int[] renderAsPackedIntAsRGBA(long pixelsId, int z, int t, Current __current) throws ServerError {
        return this.imageService.renderAsPackedIntAsRGBA(pixelsId, z, t);
    }

    @Override
    public int[][][] getRenderedImageMatrix(long pixelsId, int z, int t, Current __current) throws ServerError {
        return this.imageService.getRenderedImageMatrix(pixelsId, z, t);
    }

    @Override
    public byte[] getThumbnail(long pixelsId, RInt sizeX, RInt sizeY, Current __current) throws ServerError {
        return this.imageService.getThumbnail(pixelsId, sizeX, sizeY);
    }

    @Override
    public Map<Long, byte[]> getThumbnailSet(RInt sizeX, RInt sizeY, List<Long> pixelsIds, Current __current) throws ServerError {
        return this.imageService.getThumbnailSet(sizeX, sizeY, pixelsIds);
    }

    @Override
    public List<IObject> saveAndReturnArray(List<IObject> graph, Current __current) throws ServerError {
        return this.dataService.saveAndReturnArray(graph);
    }

    @Override
    public IObject saveAndReturnObject(IObject obj, Current __current) throws ServerError {
        return this.dataService.saveAndReturnObject(obj);
    }

    @Override
    public void saveArray(List<IObject> graph, Current __current) throws ServerError {
        this.dataService.saveArray(graph);
    }

    @Override
    public void saveObject(IObject obj, Current __current) throws ServerError {
        this.dataService.saveObject(obj);
    }

    @Override
    public void setActive(long pixelsId, int w, boolean active, Current __current) throws ServerError {
        this.imageService.setActive(pixelsId, w, active);
    }

    @Override
    public long copyImage(long imageId, int x, int y, int t, int z, List<Integer> channelList, String imageName, Current __current) throws ServerError {
        return this.imageService.copyImage(imageId, x, y, t, z, channelList, "");
    }

    @Override
    public void keepAlive(Current current) throws ServerError {
        this.gatewayFactory.keepAlive();
    }

    @Override
    public void uploadPlane(long pixelsId, int z, int c, int t, byte[] data, Current __current) throws ServerError {
        this.imageService.uploadPlane(pixelsId, z, c, t, data);
    }

    @Override
    public Pixels updatePixels(Pixels pixels, Current __current) throws ServerError {
        return this.dataService.updatePixels(pixels);
    }

    @Override
    public byte[] getPlane(long pixelsId, int z, int c, int t, Current current) throws ServerError {
        return this.imageService.getRawPlane(pixelsId, z, c, t);
    }

    @Override
    public void activate_async(AMD_StatefulServiceInterface_activate __cb, Current __current) {
        __cb.ice_exception((Exception)((Object)new InternalException(null, null, "NYI")));
    }

    @Override
    public void passivate_async(AMD_StatefulServiceInterface_passivate __cb, Current __current) {
        __cb.ice_exception((Exception)((Object)new InternalException(null, null, "NYI")));
    }

    @Override
    public void close_async(AMD_StatefulServiceInterface_close __cb, Current __current) throws ServerError {
        this.close();
        __cb.ice_response();
    }

    @Override
    public void getCurrentEventContext_async(AMD_StatefulServiceInterface_getCurrentEventContext __cb, Current __current) throws ServerError {
        __cb.ice_exception((Exception)((Object)new InternalException(null, null, "NYI")));
    }
}

