/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.Current;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import ome.api.IUpdate;
import ome.api.RawFileStore;
import ome.model.IObject;
import ome.model.core.OriginalFile;
import ome.model.enums.Format;
import ome.model.internal.Permissions;
import ome.model.jobs.JobOriginalFileLink;
import ome.model.jobs.ScriptJob;
import ome.parameters.Parameters;
import ome.services.blitz.impl.AbstractAmdServant;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.BlitzExecutor;
import ome.services.blitz.util.BlitzOnly;
import ome.services.blitz.util.ServiceFactoryAware;
import ome.services.util.Executor;
import ome.system.ServiceFactory;
import ome.util.Utils;
import omero.ApiUsageException;
import omero.InternalException;
import omero.RType;
import omero.ServerError;
import omero.ValidationException;
import omero.api.AMD_IScript_deleteScript;
import omero.api.AMD_IScript_getParams;
import omero.api.AMD_IScript_getScript;
import omero.api.AMD_IScript_getScriptID;
import omero.api.AMD_IScript_getScriptWithDetails;
import omero.api.AMD_IScript_getScripts;
import omero.api.AMD_IScript_runScript;
import omero.api.AMD_IScript_uploadScript;
import omero.api._IScriptOperations;
import omero.grid.InteractiveProcessorPrx;
import omero.grid.JobParams;
import omero.grid.Param;
import omero.grid.ProcessPrx;
import omero.model.OriginalFileI;
import omero.model.ScriptJobI;
import omero.rtypes;
import omero.util.IceMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptI
extends AbstractAmdServant
implements _IScriptOperations,
ServiceFactoryAware,
BlitzOnly {
    private static final Log log = LogFactory.getLog(ScriptI.class);
    private static final String PYTHONSCRIPT = "text/x-python";
    private static final String PARSING = "ScriptI.parsing_only";
    protected ServiceFactoryI factory;

    public ScriptI(BlitzExecutor be) {
        super(null, be);
    }

    @Override
    public void setServiceFactory(ServiceFactoryI sf) {
        this.factory = sf;
    }

    @Override
    public void getScriptID_async(final AMD_IScript_getScriptID cb, final String scriptName, Current __current) throws ServerError {
        this.runnableCall(__current, new Runnable(){

            public void run() {
                OriginalFile file = ScriptI.this.getOriginalFileOrNull(scriptName);
                if (file == null) {
                    cb.ice_response(-1L);
                } else {
                    cb.ice_response(file.getId());
                }
            }
        });
    }

    @Override
    public void uploadScript_async(final AMD_IScript_uploadScript cb, final String script, final Current __current) throws ServerError {
        this.runnableCall(__current, new Runnable(){

            public void run() {
                try {
                    if (!ScriptI.this.validateScript(script)) {
                        cb.ice_exception((Exception)((Object)new ApiUsageException(null, null, "Invalid script")));
                        return;
                    }
                    OriginalFile tempFile = ScriptI.this.makeFile(script);
                    ScriptI.this.writeContent(tempFile, script);
                    JobParams params = ScriptI.this.getScriptParams(tempFile, __current);
                    if (params == null) {
                        cb.ice_exception((Exception)((Object)new ApiUsageException(null, null, "Script error: no params found.")));
                        return;
                    }
                    if (ScriptI.this.originalFileExists(params.name)) {
                        OriginalFile file = ScriptI.this.getOriginalFileOrNull(params.name);
                        if (file == null) {
                            cb.ice_exception((Exception)((Object)new ApiUsageException(null, null, "Script error: cannot overwrite file.")));
                            return;
                        }
                        ScriptI.this.writeContent(file, script);
                        ScriptI.this.deleteOriginalFile(tempFile);
                        cb.ice_response(file.getId());
                    }
                    tempFile.setName(params.name);
                    tempFile.setPath(params.name);
                    ScriptI.this.writeContent(tempFile, script);
                    OriginalFile scriptFile = ScriptI.this.updateFile(tempFile);
                    cb.ice_response(scriptFile.getId());
                }
                catch (Exception e) {
                    cb.ice_exception(e);
                }
            }
        });
    }

    @Override
    public void getScriptWithDetails_async(final AMD_IScript_getScriptWithDetails cb, final long id, Current __current) throws ServerError {
        this.runnableCall(__current, new Runnable(){

            public void run() {
                final OriginalFile file = ScriptI.this.getOriginalFileOrNull(id);
                if (file == null) {
                    cb.ice_response(null);
                    return;
                }
                final Long size = file.getSize();
                if (size == null || size > Integer.MAX_VALUE || size < 0L) {
                    cb.ice_exception((Exception)((Object)new ValidationException(null, null, "Script size : " + size + " invalid on Blitz.OMERO server.")));
                    return;
                }
                try {
                    HashMap<String, RType> scr = new HashMap<String, RType>();
                    scr.put((String)ScriptI.this.factory.executor.execute(ScriptI.this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getScriptWithDetails", new Object[0]){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Transactional(readOnly=true)
                        public Object doWork(Session session, ServiceFactory sf) {
                            RawFileStore rawFileStore = sf.createRawFileStore();
                            try {
                                String script;
                                rawFileStore.setFileId(file.getId().longValue());
                                String string = script = new String(rawFileStore.read(0L, (int)size.longValue()));
                                return string;
                            }
                            finally {
                                rawFileStore.close();
                            }
                        }
                    }), new IceMapper().toRType(file));
                    cb.ice_response(scr);
                }
                catch (ApiUsageException e) {
                    cb.ice_exception((Exception)((Object)e));
                }
            }
        });
    }

    @Override
    public void getScript_async(final AMD_IScript_getScript cb, final long id, Current __current) throws ServerError {
        this.runnableCall(__current, new Runnable(){

            public void run() {
                final OriginalFile file = ScriptI.this.getOriginalFileOrNull(id);
                if (file == null) {
                    cb.ice_response(null);
                    return;
                }
                final Long size = file.getSize();
                if (size == null || size > Integer.MAX_VALUE || size < 0L) {
                    cb.ice_exception((Exception)((Object)new ValidationException(null, null, "Script size : " + size + " invalid on Blitz.OMERO server.")));
                    return;
                }
                try {
                    cb.ice_response((String)ScriptI.this.factory.executor.execute(ScriptI.this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getScript", new Object[0]){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Transactional(readOnly=true)
                        public Object doWork(Session session, ServiceFactory sf) {
                            RawFileStore rawFileStore = sf.createRawFileStore();
                            try {
                                String script;
                                rawFileStore.setFileId(file.getId().longValue());
                                String string = script = new String(rawFileStore.read(0L, (int)size.longValue()));
                                return string;
                            }
                            finally {
                                rawFileStore.close();
                            }
                        }
                    }));
                }
                catch (Exception e) {
                    cb.ice_exception(e);
                }
            }
        });
    }

    @Override
    public void getParams_async(final AMD_IScript_getParams cb, final long id, final Current __current) throws ServerError {
        this.runnableCall(__current, new Runnable(){

            public void run() {
                try {
                    cb.ice_response(ScriptI.this.getParams(id, __current));
                }
                catch (Exception e) {
                    cb.ice_exception(e);
                }
            }
        });
    }

    @Override
    public void runScript_async(final AMD_IScript_runScript cb, final long id, final Map<String, RType> map, Current __current) throws ServerError {
        this.runnableCall(__current, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                InteractiveProcessorPrx proc = null;
                try {
                    log.info((Object)String.format("runScript: %s param keys: %s", id, map == null ? null : map.keySet()));
                    ScriptJobI job = ScriptI.this.buildJob(id);
                    proc = ScriptI.this.factory.sharedResources().acquireProcessor(job, 10);
                    JobParams params = proc.params();
                    if (params == null) {
                        cb.ice_exception((Exception)((Object)new ApiUsageException(null, null, "Script has returned no parameters this indicates that the script may have crashed.")));
                        return;
                    }
                    for (Map.Entry<String, Param> entry : params.inputs.entrySet()) {
                        String paramName = entry.getKey();
                        Param param = entry.getValue();
                        RType scriptParamType = param.prototype;
                        RType inputParamType = (RType)map.get(paramName);
                        if (inputParamType == null) {
                            if (param.optional) continue;
                            cb.ice_exception((Exception)((Object)new ApiUsageException(null, null, "Script takes required parameter " + paramName + " which has not supplied input params to runScript.")));
                            return;
                        }
                        if (scriptParamType.getClass().equals(inputParamType.getClass())) continue;
                        cb.ice_exception((Exception)((Object)new ApiUsageException(null, null, "Script takes parameter " + paramName + " of type " + scriptParamType + " runScript was passed parameter " + paramName + " of type " + inputParamType + ".")));
                        return;
                    }
                    ProcessPrx prx = proc.execute(rtypes.rmap(map));
                    prx._wait();
                    Map<String, RType> results = proc.getResults(prx).getValue();
                    if (results == null) {
                        cb.ice_exception((Exception)((Object)new ApiUsageException(null, null, "Script has returned null this indicates that the script may have crashed.")));
                        return;
                    }
                    cb.ice_response(results);
                }
                catch (Exception e) {
                    cb.ice_exception(e);
                }
                finally {
                    if (proc != null) {
                        try {
                            proc.stop();
                        }
                        catch (Exception e) {
                            log.warn((Object)("Err on proc.stop(): " + e.getMessage()));
                        }
                    }
                }
            }
        });
    }

    @Override
    public void getScripts_async(final AMD_IScript_getScripts cb, Current __current) throws ServerError {
        this.runnableCall(__current, new Runnable(){

            public void run() {
                try {
                    final HashMap<Long, String> scriptMap = new HashMap<Long, String>();
                    long fmt = ScriptI.this.getFormat(ScriptI.PYTHONSCRIPT).getId();
                    final String queryString = "from OriginalFile as o where o.format.id = " + fmt;
                    ScriptI.this.factory.executor.execute(ScriptI.this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getScripts", new Object[0]){

                        @Transactional(readOnly=true)
                        public Object doWork(Session session, ServiceFactory sf) {
                            List fileList = sf.getQueryService().findAllByQuery(queryString, null);
                            for (OriginalFile file : fileList) {
                                scriptMap.put(file.getId(), file.getName());
                            }
                            return null;
                        }
                    });
                    cb.ice_response(scriptMap);
                }
                catch (Exception e) {
                    cb.ice_exception(e);
                }
            }
        });
    }

    @Override
    public void deleteScript_async(final AMD_IScript_deleteScript cb, final long id, Current __current) throws ServerError {
        this.runnableCall(__current, new Runnable(){

            public void run() {
                OriginalFile file = ScriptI.this.getOriginalFileOrNull(id);
                if (file == null) {
                    cb.ice_exception((Exception)((Object)new ApiUsageException(null, null, "No script with id " + id + " on server.")));
                    return;
                }
                try {
                    ScriptI.this.deleteOriginalFile(file);
                    cb.ice_response();
                }
                catch (ServerError e) {
                    cb.ice_exception((Exception)((Object)e));
                }
            }
        });
    }

    private Map<String, RType> getParams(long id, Current __current) throws ServerError {
        OriginalFile file = this.getOriginalFileOrNull(id);
        JobParams params = this.getScriptParams(file, __current);
        if (params == null) {
            return null;
        }
        HashMap<String, RType> temporary = new HashMap<String, RType>();
        for (String key : params.inputs.keySet()) {
            Param p = params.inputs.get(key);
            temporary.put(key, p.prototype);
        }
        return temporary;
    }

    private JobParams getScriptParams(OriginalFile file, Current __current) throws ServerError {
        if (file == null || file.getId() == null) {
            throw new ApiUsageException(null, null, file + " is not persistent.");
        }
        ScriptJobI job = this.buildJob(file.getId());
        InteractiveProcessorPrx proc = this.factory.sharedResources().acquireProcessor(job, 10);
        if (proc == null) {
            throw new InternalException(null, null, "No processor acquired.");
        }
        JobParams rv = proc.params();
        this.deleteTempJob(proc.getJob().getId().getValue());
        return rv;
    }

    private OriginalFile makeFile(String script) throws ServerError {
        String fName = "ScriptName" + UUID.randomUUID();
        OriginalFile tempFile = new OriginalFile();
        tempFile.setName(fName);
        tempFile.setPath(fName);
        tempFile.setFormat(this.getFormat(PYTHONSCRIPT));
        tempFile.setSize(Long.valueOf(script.getBytes().length));
        tempFile.setSha1(Utils.bufferToSha1((byte[])script.getBytes()));
        tempFile.getDetails().setPermissions(Permissions.PUBLIC);
        return this.updateFile(tempFile);
    }

    private OriginalFile updateFile(final OriginalFile file) throws ServerError {
        OriginalFile updatedFile = (OriginalFile)this.factory.executor.execute(this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "updateFile", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                IUpdate update = sf.getUpdateService();
                file.getDetails().setUpdateEvent(null);
                return update.saveAndReturnObject((IObject)file);
            }
        });
        return updatedFile;
    }

    private void writeContent(final OriginalFile file, final String script) throws ServerError {
        this.factory.executor.execute(this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "writeContent", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                RawFileStore rawFileStore = sf.createRawFileStore();
                rawFileStore.setFileId(file.getId().longValue());
                rawFileStore.write(script.getBytes(), 0L, script.getBytes().length);
                return file.getId();
            }
        });
    }

    private ScriptJobI buildJob(long id) throws ServerError {
        OriginalFileI file = new OriginalFileI(id, false);
        ScriptJobI job = new ScriptJobI();
        job.linkOriginalFile(file);
        return job;
    }

    private void deleteTempJob(final long id) throws ServerError {
        Boolean success = (Boolean)this.factory.executor.execute(this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "deleteTempJob", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                try {
                    IUpdate update = sf.getUpdateService();
                    update.deleteObject((IObject)new ScriptJob(Long.valueOf(id), false));
                }
                catch (ome.conditions.ValidationException ve) {
                    return false;
                }
                return true;
            }
        });
        if (success == null || !success.booleanValue()) {
            throw new ApiUsageException(null, null, "Cannot delete " + new ScriptJob(Long.valueOf(id), false) + "\nIs in use by other objects");
        }
    }

    private void deleteOriginalFile(final OriginalFile file) throws ServerError {
        Boolean success = (Boolean)this.factory.executor.execute(this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "deleteOriginalFile", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                IUpdate update = sf.getUpdateService();
                List links = sf.getQueryService().findAllByQuery("select link from JobOriginalFileLink link join link.child as file join link.parent as job where file.id = :id and job.message = :msg", new Parameters().addId(file.getId()).addString("msg", ScriptI.PARSING));
                try {
                    for (JobOriginalFileLink jobOriginalFileLink : links) {
                        update.deleteObject((IObject)jobOriginalFileLink);
                    }
                    update.deleteObject((IObject)file);
                }
                catch (ome.conditions.ValidationException ve) {
                    return false;
                }
                return true;
            }
        });
        if (success == null || !success.booleanValue()) {
            throw new ApiUsageException(null, null, "Cannot delete " + file + "\nIs in use by other objects");
        }
    }

    private boolean originalFileExists(String fileName) {
        final String queryString = "from OriginalFile as o where o.format.id = " + this.getFormat(PYTHONSCRIPT).getId() + " and o.name = '" + fileName + "'";
        List fileList = (List)this.factory.executor.execute(this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "originalFileExists", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getQueryService().findAllByQuery(queryString, null);
            }
        });
        if (fileList == null) {
            return false;
        }
        return fileList.size() != 0;
    }

    private OriginalFile getOriginalFileOrNull(String name) {
        try {
            final String queryString = "from OriginalFile as o where o.format.id = " + this.getFormat(PYTHONSCRIPT).getId() + " and o.name = '" + name + "'";
            OriginalFile file = (OriginalFile)this.factory.executor.execute(this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getOriginalFileOrNull", new Object[0]){

                @Transactional(readOnly=true)
                public Object doWork(Session session, ServiceFactory sf) {
                    return sf.getQueryService().findByQuery(queryString, null);
                }
            });
            return file;
        }
        catch (RuntimeException re) {
            return null;
        }
    }

    private OriginalFile getOriginalFileOrNull(long id) {
        try {
            final String queryString = "from OriginalFile as o where o.format.id = " + this.getFormat(PYTHONSCRIPT).getId() + " and o.id = " + id;
            OriginalFile file = (OriginalFile)this.factory.executor.execute(this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getOriginalFileOrNull", new Object[0]){

                @Transactional(readOnly=true)
                public Object doWork(Session session, ServiceFactory sf) {
                    return sf.getQueryService().findByQuery(queryString, null);
                }
            });
            return file;
        }
        catch (RuntimeException re) {
            return null;
        }
    }

    Format getFormat(String fmt) {
        return (Format)this.factory.executor.execute(this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getFormat", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getQueryService().findByQuery("from Format as f where f.value='text/x-python'", null);
            }
        });
    }

    private boolean validateScript(String script) {
        return true;
    }
}

