/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.measurements;

import omero.ServerError;
import omero.ValidationException;
import omero.grid.BoolColumn;
import omero.grid.Column;
import omero.grid.DoubleColumn;
import omero.grid.FileColumn;
import omero.grid.ImageColumn;
import omero.grid.LongColumn;
import omero.grid.RoiColumn;
import omero.grid.StringColumn;
import omero.grid.WellColumn;

public abstract class Helper {
    public static Helper fromLsid(String lsid) throws ServerError {
        if (lsid.contains("File")) {
            return new FileHelper();
        }
        if (lsid.contains("Roi")) {
            return new RoiHelper();
        }
        if (lsid.contains("Image")) {
            return new ImageHelper();
        }
        if (lsid.contains("Well")) {
            return new WellHelper();
        }
        throw new ValidationException(null, null, "Unknown id type: " + lsid);
    }

    public static Helper fromClass(Class kls) throws ServerError {
        if (Long.class.equals((Object)kls)) {
            return new LongHelper();
        }
        if (Double.class.equals((Object)kls)) {
            return new DoubleHelper();
        }
        if (Boolean.class.equals((Object)kls)) {
            return new BoolHelper();
        }
        if (String.class.equals((Object)kls)) {
            return new StringHelper();
        }
        throw new ValidationException(null, null, "Unknown column type: " + kls.getName());
    }

    abstract Column newInstance();

    abstract void setSize(Column var1, int var2);

    abstract void setValue(Column var1, int var2, Object var3);

    static class StringHelper
    extends Helper {
        StringHelper() {
        }

        Column newInstance() {
            return new StringColumn();
        }

        void setSize(Column col, int length) {
            ((StringColumn)col).values = new String[length];
        }

        void setValue(Column col, int rowIdx, Object value) {
            ((StringColumn)col).values[rowIdx] = (String)value;
        }
    }

    static class LongHelper
    extends Helper {
        LongHelper() {
        }

        Column newInstance() {
            return new LongColumn();
        }

        void setSize(Column col, int length) {
            ((LongColumn)col).values = new long[length];
        }

        void setValue(Column col, int rowIdx, Object value) {
            ((LongColumn)col).values[rowIdx] = (Long)value;
        }
    }

    static class DoubleHelper
    extends Helper {
        DoubleHelper() {
        }

        Column newInstance() {
            return new DoubleColumn();
        }

        void setSize(Column col, int length) {
            ((DoubleColumn)col).values = new double[length];
        }

        void setValue(Column col, int rowIdx, Object value) {
            ((DoubleColumn)col).values[rowIdx] = (Double)value;
        }
    }

    static class BoolHelper
    extends Helper {
        BoolHelper() {
        }

        Column newInstance() {
            return new BoolColumn();
        }

        void setSize(Column col, int length) {
            ((BoolColumn)col).values = new boolean[length];
        }

        void setValue(Column col, int rowIdx, Object value) {
            ((BoolColumn)col).values[rowIdx] = (Boolean)value;
        }
    }

    static class WellHelper
    extends Helper {
        WellHelper() {
        }

        Column newInstance() {
            return new WellColumn();
        }

        void setSize(Column col, int length) {
            ((WellColumn)col).values = new long[length];
        }

        void setValue(Column col, int rowIdx, Object value) {
            ((WellColumn)col).values[rowIdx] = (Long)value;
        }
    }

    static class ImageHelper
    extends Helper {
        ImageHelper() {
        }

        Column newInstance() {
            return new ImageColumn();
        }

        void setSize(Column col, int length) {
            ((ImageColumn)col).values = new long[length];
        }

        void setValue(Column col, int rowIdx, Object value) {
            ((ImageColumn)col).values[rowIdx] = (Long)value;
        }
    }

    static class RoiHelper
    extends Helper {
        RoiHelper() {
        }

        Column newInstance() {
            return new RoiColumn();
        }

        void setSize(Column col, int length) {
            ((RoiColumn)col).values = new long[length];
        }

        void setValue(Column col, int rowIdx, Object value) {
            ((RoiColumn)col).values[rowIdx] = (Long)value;
        }
    }

    static class FileHelper
    extends Helper {
        FileHelper() {
        }

        Column newInstance() {
            return new FileColumn();
        }

        void setSize(Column col, int length) {
            ((FileColumn)col).values = new long[length];
        }

        void setValue(Column col, int rowIdx, Object value) {
            ((FileColumn)col).values[rowIdx] = (Long)value;
        }
    }
}

