/*
 * Decompiled with CFR 0.152.
 */
package ome.services.roi;

import java.io.IOException;
import ome.api.IPixels;
import ome.conditions.ApiUsageException;
import ome.conditions.ResourceError;
import ome.conditions.ValidationException;
import ome.io.nio.DimensionsOutOfBoundsException;
import ome.io.nio.PixelBuffer;
import ome.io.nio.PixelsService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PixelData {
    protected Log log = LogFactory.getLog(PixelData.class);
    protected final PixelsService data;
    protected final IPixels meta;

    public PixelData(PixelsService data, IPixels meta) {
        this.data = data;
        this.meta = meta;
    }

    public double get(long pix, int x, int y, int z, int c, int t) {
        PixelBuffer buf = this.data.getPixelBuffer(this.meta.retrievePixDescription(pix), null, true);
        try {
            ome.io.nio.PixelData pd = buf.getRow(Integer.valueOf(y), Integer.valueOf(z), Integer.valueOf(c), Integer.valueOf(t));
            return pd.getPixelValue(x);
        }
        catch (IOException e) {
            throw new ResourceError("IOException: " + e);
        }
        catch (DimensionsOutOfBoundsException e) {
            throw new ApiUsageException("DimensionsOutOfBounds: " + (Object)((Object)e));
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new ValidationException("IndexOutOfBounds: " + iobe);
        }
    }
}

