/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.RTime;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.Node;
import omero.model.NodeAnnotationLink;
import omero.model.NodeAnnotationLinkI;
import omero.model.Session;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeI
extends Node
implements ModelBased {
    public static final String SESSIONS = "ome.model.meta.Node_sessions";
    public static final String UUID = "ome.model.meta.Node_uuid";
    public static final String CONN = "ome.model.meta.Node_conn";
    public static final String UP = "ome.model.meta.Node_up";
    public static final String DOWN = "ome.model.meta.Node_down";
    public static final String SCALE = "ome.model.meta.Node_scale";
    public static final String ANNOTATIONLINKS = "ome.model.meta.Node_annotationLinks";
    public static final String DETAILS = "ome.model.meta.Node_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.sessionsSeq = new ArrayList();
            this.sessionsLoaded = true;
        } else {
            this.sessionsSeq = null;
            this.sessionsLoaded = false;
        }
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public NodeI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public NodeI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public NodeI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadSessions();
        this.unloadUuid();
        this.unloadConn();
        this.unloadUp();
        this.unloadDown();
        this.unloadScale();
        this.unloadAnnotationLinks();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return true;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return true;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        NodeI copy = new NodeI();
        copy.id = this.id;
        copy.version = this.version;
        if (!this.sessionsLoaded) {
            copy.sessionsLoaded = false;
            copy.sessionsSeq = null;
        } else {
            copy.sessionsLoaded = true;
            copy.sessionsSeq = new ArrayList<Session>();
            for (IObject item : this.sessionsSeq) {
                copy.sessionsSeq.add(item == null ? null : (Session)item.proxy());
            }
        }
        copy.uuid = this.uuid;
        copy.conn = this.conn;
        copy.up = this.up;
        copy.down = this.down;
        copy.scale = this.scale;
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList<NodeAnnotationLink>();
            for (IObject item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (NodeAnnotationLink)item.proxy());
            }
        }
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new NodeI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    @Override
    public void unloadSessions(Current current) {
        this.sessionsLoaded = false;
        this.sessionsSeq = null;
    }

    protected List getSessions(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.sessionsSeq;
    }

    protected void setSessions(List sessions, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.sessionsSeq = sessions == null ? new ArrayList() : new ArrayList(sessions);
        this.sessionsLoaded = sessions != null;
    }

    private void copySessions(ome.model.meta.Node source, IceMapper mapper) {
        this.setSessions((List)mapper.findCollection((Collection)source.retrieve(SESSIONS)), null);
    }

    private void fillSessions(ome.model.meta.Node target, IceMapper mapper) {
        if (this.sessionsLoaded) {
            target.putAt(SESSIONS, (Object)mapper.reverse(this.sessionsSeq, Set.class));
        } else {
            target.putAt(SESSIONS, null);
        }
    }

    public boolean isSessionsLoaded() {
        return this.sessionsLoaded;
    }

    @Override
    public int sizeOfSessions(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.sessionsLoaded) {
            return -1;
        }
        return this.sessionsSeq.size();
    }

    public List copySessions(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.sessionsLoaded) {
            this.throwNullCollectionException("sessionsSeq");
        }
        ArrayList result = new ArrayList(this.sessionsSeq);
        return result;
    }

    public Iterator iterateSessions() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.sessionsLoaded) {
            this.throwNullCollectionException("sessionsSeq");
        }
        return this.sessionsSeq.iterator();
    }

    @Override
    public void addSession(Session target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.sessionsLoaded) {
            this.throwNullCollectionException("sessionsSeq");
        }
        this.sessionsSeq.add(target);
        target.setNode(this);
    }

    @Override
    public void addAllSessionSet(List<Session> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.sessionsLoaded) {
            this.throwNullCollectionException("sessionsSeq");
        }
        this.sessionsSeq.addAll(targets);
        for (Session target : targets) {
            target.setNode(this);
        }
    }

    @Override
    public void removeSession(Session target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.sessionsLoaded) {
            this.throwNullCollectionException("sessionsSeq");
        }
        this.sessionsSeq.remove(target);
        target.setNode(null);
    }

    @Override
    public void removeAllSessionSet(List<Session> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.sessionsLoaded) {
            this.throwNullCollectionException("sessionsSeq");
        }
        for (Session elt : targets) {
            elt.setNode(null);
            this.sessionsSeq.remove(elt);
        }
    }

    @Override
    public void clearSessions(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.sessionsLoaded) {
            this.throwNullCollectionException("sessionsSeq");
        }
        for (Session elt : this.sessionsSeq) {
            elt.setNode(null);
        }
        this.sessionsSeq.clear();
    }

    @Override
    public void reloadSessions(Node toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.sessionsLoaded) {
            throw new ClientError("Cannot reload active collection: sessionsSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<Session> copy = toCopy.copySessions();
        for (Session elt : copy) {
            elt.setNode(this);
        }
        this.sessionsSeq = new ArrayList<Session>(copy);
        toCopy.unloadSessions();
        this.sessionsLoaded = true;
    }

    public void unloadUuid() {
        this.uuid = null;
    }

    @Override
    public RString getUuid(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.uuid;
    }

    @Override
    public void setUuid(RString uuid, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.uuid = uuid;
    }

    private void copyUuid(ome.model.meta.Node source, IceMapper mapper) {
        this.uuid = source.getUuid() == null ? null : rtypes.rstring(source.getUuid());
    }

    private void fillUuid(ome.model.meta.Node target, IceMapper mapper) {
        try {
            target.setUuid((String)mapper.fromRType(this.getUuid()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadConn() {
        this.conn = null;
    }

    @Override
    public RString getConn(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.conn;
    }

    @Override
    public void setConn(RString conn, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.conn = conn;
    }

    private void copyConn(ome.model.meta.Node source, IceMapper mapper) {
        this.conn = source.getConn() == null ? null : rtypes.rstring(source.getConn());
    }

    private void fillConn(ome.model.meta.Node target, IceMapper mapper) {
        try {
            target.setConn((String)mapper.fromRType(this.getConn()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadUp() {
        this.up = null;
    }

    @Override
    public RTime getUp(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.up;
    }

    @Override
    public void setUp(RTime up, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.up = up;
    }

    private void copyUp(ome.model.meta.Node source, IceMapper mapper) {
        this.up = source.getUp() == null ? null : rtypes.rtime(source.getUp().getTime());
    }

    private void fillUp(ome.model.meta.Node target, IceMapper mapper) {
        try {
            target.setUp((Timestamp)mapper.fromRType(this.getUp()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadDown() {
        this.down = null;
    }

    @Override
    public RTime getDown(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.down;
    }

    @Override
    public void setDown(RTime down, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.down = down;
    }

    private void copyDown(ome.model.meta.Node source, IceMapper mapper) {
        this.down = source.getDown() == null ? null : rtypes.rtime(source.getDown().getTime());
    }

    private void fillDown(ome.model.meta.Node target, IceMapper mapper) {
        try {
            target.setDown((Timestamp)mapper.fromRType(this.getDown()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadScale() {
        this.scale = null;
    }

    @Override
    public RInt getScale(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.scale;
    }

    @Override
    public void setScale(RInt scale, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.scale = scale;
    }

    private void copyScale(ome.model.meta.Node source, IceMapper mapper) {
        this.scale = source.getScale() == null ? null : rtypes.rint(source.getScale());
    }

    private void fillScale(ome.model.meta.Node target, IceMapper mapper) {
        try {
            target.setScale((Integer)mapper.fromRType(this.getScale()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.meta.Node source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve(ANNOTATIONLINKS)), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.meta.Node target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt(ANNOTATIONLINKS, (Object)mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt(ANNOTATIONLINKS, null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addNodeAnnotationLink(NodeAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllNodeAnnotationLinkSet(List<NodeAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (NodeAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeNodeAnnotationLink(NodeAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllNodeAnnotationLinkSet(List<NodeAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (NodeAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (NodeAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(Node toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<NodeAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (NodeAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<NodeAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public NodeAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        NodeAnnotationLinkI link = new NodeAnnotationLinkI();
        link.link(this, addition);
        this.addNodeAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addNodeAnnotationLinkToBoth(NodeAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<NodeAnnotationLink> findNodeAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<NodeAnnotationLink> result = new ArrayList<NodeAnnotationLink>();
        for (NodeAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<NodeAnnotationLink> toRemove = this.findNodeAnnotationLink(removal);
        Iterator<NodeAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeNodeAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeNodeAnnotationLinkFromBoth(NodeAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (NodeAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.meta.Node) {
            ome.model.meta.Node source = (ome.model.meta.Node)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copySessions(source, mapper);
                this.copyUuid(source, mapper);
                this.copyConn(source, mapper);
                this.copyUp(source, mapper);
                this.copyDown(source, mapper);
                this.copyScale(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Node cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.meta.Node target = new ome.model.meta.Node();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillSessions(target, mapper);
            this.fillUuid(target, mapper);
            this.fillConn(target, mapper);
            this.fillUp(target, mapper);
            this.fillDown(target, mapper);
            this.fillScale(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<NodeI> cast(List list) {
        return list;
    }
}

