/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import loci.common.CBZip2InputStream;
import loci.common.CompressedRandomAccess;
import loci.common.HandleException;

public class BZip2Handle
extends CompressedRandomAccess {
    public BZip2Handle(String file) throws IOException {
        int skip;
        this.file = file;
        if (!BZip2Handle.isBZip2File(file)) {
            throw new HandleException(file + " is not a BZip2 file.");
        }
        this.resetStream();
        this.length = 0L;
        while ((skip = this.stream.skipBytes(1024)) > 0) {
            this.length += (long)skip;
        }
        this.resetStream();
    }

    public static boolean isBZip2File(String file) {
        return file.toLowerCase().endsWith(".bz2");
    }

    public void seek(long pos) throws IOException {
        block3: {
            long oldFP;
            block2: {
                oldFP = this.fp;
                this.fp = pos;
                if (this.fp <= oldFP) break block2;
                long diff = this.fp - oldFP;
                int skipped = this.stream.skipBytes((int)diff);
                while ((long)skipped < diff) {
                    skipped += this.stream.skipBytes((int)(diff - (long)skipped));
                }
                break block3;
            }
            if (this.fp >= oldFP) break block3;
            this.stream.close();
            this.resetStream();
            int skipped = this.stream.skipBytes((int)this.fp);
            while ((long)skipped < this.fp) {
                skipped += this.stream.skipBytes((int)(this.fp - (long)skipped));
            }
        }
    }

    private void resetStream() throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.file), 0x100000);
        int skipped = 0;
        while (skipped < 2) {
            skipped = (int)((long)skipped + bis.skip(2 - skipped));
        }
        this.stream = new DataInputStream(new CBZip2InputStream(bis));
    }
}

