/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Current;
import Ice.DispatchStatus;
import Ice.FacetNotExistException;
import Ice.LocalObjectHolder;
import Ice.Object;
import Ice.ObjectAdapterI;
import Ice.ObjectNotExistException;
import Ice.Request;
import Ice.ServantLocator;
import Ice.UserException;
import IceInternal.ServantManager;

public abstract class Direct
implements Request {
    private final Current _current;
    private Object _servant;
    private UserException _userException;
    private ServantLocator _locator;
    private LocalObjectHolder _cookie;

    public abstract DispatchStatus run(Object var1);

    public final boolean isCollocated() {
        return true;
    }

    public final Current getCurrent() {
        return this._current;
    }

    public Direct(Current current) throws UserException {
        this._current = current;
        ObjectAdapterI adapter = (ObjectAdapterI)this._current.adapter;
        assert (adapter != null);
        adapter.incDirectCount();
        ServantManager servantManager = adapter.getServantManager();
        assert (servantManager != null);
        this._servant = servantManager.findServant(this._current.id, this._current.facet);
        if (this._servant == null) {
            this._locator = servantManager.findServantLocator(this._current.id.category);
            if (this._locator == null && this._current.id.category.length() > 0) {
                this._locator = servantManager.findServantLocator("");
            }
            if (this._locator != null) {
                this._cookie = new LocalObjectHolder();
                try {
                    this._servant = this._locator.locate(this._current, this._cookie);
                }
                catch (UserException ex) {
                    adapter.decDirectCount();
                    throw ex;
                }
                catch (RuntimeException ex) {
                    adapter.decDirectCount();
                    throw ex;
                }
            }
        }
        if (this._servant == null) {
            adapter.decDirectCount();
            if (servantManager != null && servantManager.hasServant(this._current.id)) {
                FacetNotExistException ex = new FacetNotExistException();
                ex.id = this._current.id;
                ex.facet = this._current.facet;
                ex.operation = this._current.operation;
                throw ex;
            }
            ObjectNotExistException ex = new ObjectNotExistException();
            ex.id = this._current.id;
            ex.facet = this._current.facet;
            ex.operation = this._current.operation;
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws UserException {
        ObjectAdapterI adapter = (ObjectAdapterI)this._current.adapter;
        assert (adapter != null);
        try {
            if (this._locator != null && this._servant != null) {
                this._locator.finished(this._current, this._servant, this._cookie.value);
            }
        }
        finally {
            adapter.decDirectCount();
        }
    }

    public Object servant() {
        return this._servant;
    }

    public void throwUserException() throws UserException {
        assert (this._userException != null);
        throw this._userException;
    }

    public void setUserException(UserException ex) {
        this._userException = ex;
    }
}

