/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.FacetNotExistException;
import Ice.LocalException;
import Ice.ObjectNotExistException;
import Ice.OperationNotExistException;
import Ice.UnknownException;
import Ice.UnknownLocalException;
import Ice.UnknownUserException;
import Ice.UserException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LocalExceptionWrapper
extends Exception {
    private LocalException _ex;
    private boolean _retry;

    public LocalExceptionWrapper(LocalException ex, boolean retry) {
        this._ex = ex;
        this._retry = retry;
    }

    public LocalExceptionWrapper(LocalExceptionWrapper ex) {
        this._ex = ex.get();
        this._retry = ex._retry;
    }

    public LocalException get() {
        return this._ex;
    }

    public boolean retry() {
        return this._retry;
    }

    public static void throwWrapper(Throwable ex) throws LocalExceptionWrapper {
        if (ex instanceof UserException) {
            throw new LocalExceptionWrapper(new UnknownUserException(((UserException)ex).ice_name()), false);
        }
        if (ex instanceof LocalException) {
            if (ex instanceof UnknownException || ex instanceof ObjectNotExistException || ex instanceof OperationNotExistException || ex instanceof FacetNotExistException) {
                throw new LocalExceptionWrapper((LocalException)ex, false);
            }
            throw new LocalExceptionWrapper(new UnknownLocalException(((LocalException)ex).ice_name()), false);
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        throw new LocalExceptionWrapper(new UnknownException(sw.toString()), false);
    }
}

