/*
 * Decompiled with CFR 0.152.
 */
package ome.system;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpgradeCheck
implements Runnable {
    private static final Log log = LogFactory.getLog(UpgradeCheck.class);
    public static final int DEFAULT_TIMEOUT = 10000;
    final String url;
    final String version;
    final int timeout;
    final String agent;
    String upgradeUrl = null;
    Exception exc = null;

    public UpgradeCheck(String url, String version, String agent) {
        this(url, version, agent, 10000);
    }

    public UpgradeCheck(String url, String version, String agent, int timeout) {
        this.url = url;
        this.version = version;
        this.agent = "OMERO." + agent;
        this.timeout = timeout;
    }

    public boolean isUpgradeNeeded() {
        return this.upgradeUrl != null;
    }

    public String getUpgradeUrl() {
        return this.upgradeUrl;
    }

    public boolean isExceptionThrown() {
        return this.exc != null;
    }

    public Exception getExceptionThrown() {
        return this.exc;
    }

    private void set(String results, Exception e) {
        this.upgradeUrl = results;
        this.exc = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        URL _url;
        if (this.url == null || this.url.length() == 0) {
            return;
        }
        StringBuilder query = new StringBuilder();
        try {
            query.append(this.url);
            query.append("?version=");
            query.append(URLEncoder.encode(this.version, "UTF-8"));
            query.append(";os.name=");
            query.append(URLEncoder.encode(System.getProperty("os.name"), "UTF-8"));
            query.append(";os.arch=");
            query.append(URLEncoder.encode(System.getProperty("os.arch"), "UTF-8"));
            query.append(";os.version=");
            query.append(URLEncoder.encode(System.getProperty("os.version"), "UTF-8"));
            query.append(";java.runtime.version=");
            query.append(URLEncoder.encode(System.getProperty("java.runtime.version"), "UTF-8"));
            query.append(";java.vm.vendor=");
            query.append(URLEncoder.encode(System.getProperty("java.vm.vendor"), "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            this.set(null, uee);
            return;
        }
        try {
            _url = new URL(query.toString());
        }
        catch (Exception e) {
            this.set(null, e);
            log.error((Object)("Invalid URL: " + query.toString()));
            return;
        }
        BufferedInputStream bufIn = null;
        try {
            int data;
            URLConnection conn = _url.openConnection();
            conn.setUseCaches(false);
            conn.addRequestProperty("User-Agent", this.agent);
            conn.setConnectTimeout(this.timeout);
            conn.setReadTimeout(this.timeout);
            conn.connect();
            log.debug((Object)("Attempting to connect to " + query));
            InputStream in = conn.getInputStream();
            bufIn = new BufferedInputStream(in);
            StringBuilder sb = new StringBuilder();
            while ((data = bufIn.read()) != -1) {
                sb.append((char)data);
            }
            String result = sb.toString();
            if (result.length() == 0) {
                log.info((Object)"no update needed");
                this.set(null, null);
            } else {
                log.warn((Object)("UPGRADE AVAILABLE:" + result));
                this.set(result, null);
            }
        }
        catch (UnknownHostException uhe) {
            log.error((Object)("Unknown host:" + this.url));
            this.set(null, uhe);
        }
        catch (IOException ioe) {
            log.error((Object)String.format("Error reading from url: %s \"%s\"", query, ioe.getMessage()));
            this.set(null, ioe);
        }
        catch (Exception ex) {
            log.error((Object)"Unknown exception thrown on UpgradeCheck", (Throwable)ex);
            this.set(null, ex);
        }
        finally {
            if (bufIn != null) {
                try {
                    bufIn.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

