/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import omero.RString;
import omero.model.Detector;
import omero.model.Dichroic;
import omero.model.Filter;
import omero.model.IObject;
import omero.model.Instrument;
import omero.model.LightSource;
import omero.model.Microscope;
import omero.model.MicroscopeType;
import omero.model.Objective;
import pojos.DataObject;
import pojos.DetectorData;
import pojos.DichroicData;
import pojos.FilterData;
import pojos.LightSourceData;
import pojos.ObjectiveData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentData
extends DataObject {
    private List<ObjectiveData> objectives;
    private List<LightSourceData> lightSources;
    private List<FilterData> filters;
    private List<DichroicData> dichroics;
    private List<DetectorData> detectors;

    private void initialize() {
        this.objectives = new ArrayList<ObjectiveData>();
        this.lightSources = new ArrayList<LightSourceData>();
        this.filters = new ArrayList<FilterData>();
        this.dichroics = new ArrayList<DichroicData>();
        this.detectors = new ArrayList<DetectorData>();
    }

    public InstrumentData(Instrument instrument) {
        if (instrument == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(instrument);
        this.initialize();
    }

    public InstrumentData(List<IObject> components) {
        if (components == null || components.size() < 1) {
            throw new IllegalArgumentException("No components specified.");
        }
        this.initialize();
        Iterator<IObject> i = components.iterator();
        boolean instrument = false;
        while (i.hasNext()) {
            IObject obj = i.next();
            if (obj instanceof Instrument) {
                this.setValue(obj);
                instrument = true;
                continue;
            }
            if (obj instanceof Detector) {
                this.detectors.add(new DetectorData((Detector)obj));
                continue;
            }
            if (obj instanceof Objective) {
                this.objectives.add(new ObjectiveData((Objective)obj));
                continue;
            }
            if (obj instanceof Filter) {
                this.filters.add(new FilterData((Filter)obj));
                continue;
            }
            if (obj instanceof LightSource) {
                this.lightSources.add(new LightSourceData((LightSource)obj));
                continue;
            }
            if (!(obj instanceof Dichroic)) continue;
            this.dichroics.add(new DichroicData((Dichroic)obj));
        }
        if (!instrument) {
            throw new IllegalArgumentException("No instrument specified.");
        }
    }

    public String getMicroscopeType() {
        Microscope m = ((Instrument)this.asIObject()).getMicroscope();
        if (m == null) {
            return null;
        }
        MicroscopeType v = m.getType();
        if (v == null) {
            return "";
        }
        return v.getValue().getValue();
    }

    public String getMicroscopeModel() {
        Microscope m = ((Instrument)this.asIObject()).getMicroscope();
        if (m == null) {
            return null;
        }
        RString v = m.getModel();
        if (v == null) {
            return "";
        }
        return v.getValue();
    }

    public String getMicroscopeSerialNumber() {
        Microscope m = ((Instrument)this.asIObject()).getMicroscope();
        if (m == null) {
            return null;
        }
        RString v = m.getSerialNumber();
        if (v == null) {
            return "";
        }
        return v.getValue();
    }

    public String getMicroscopeLotNumber() {
        Microscope m = ((Instrument)this.asIObject()).getMicroscope();
        if (m == null) {
            return null;
        }
        RString v = m.getSerialNumber();
        if (v == null) {
            return "";
        }
        return v.getValue();
    }

    public String getMicroscopeManufacturer() {
        Microscope m = ((Instrument)this.asIObject()).getMicroscope();
        if (m == null) {
            return null;
        }
        RString v = m.getSerialNumber();
        if (v == null) {
            return "";
        }
        return v.getValue();
    }

    public List<ObjectiveData> getObjectives() {
        return this.objectives;
    }

    public List<FilterData> getFilters() {
        return this.filters;
    }

    public List<LightSourceData> getLightSources() {
        return this.lightSources;
    }

    public List<DetectorData> getDetectors() {
        return this.detectors;
    }

    public List<DichroicData> getDichroics() {
        return this.dichroics;
    }
}

