/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.util.Vector;
import loci.common.LogTools;
import loci.formats.IFormatHandler;
import loci.formats.StatusEvent;
import loci.formats.StatusListener;

public abstract class FormatHandler
implements IFormatHandler {
    public static final String[] COMPRESSION_SUFFIXES = new String[]{"bz2", "gz"};
    protected String format;
    protected String[] suffixes;
    protected Vector statusListeners;
    protected String currentId;

    public FormatHandler(String format, String suffix) {
        String[] stringArray;
        if (suffix == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = suffix;
        }
        this(format, stringArray);
    }

    public FormatHandler(String format, String[] suffixes) {
        this.statusListeners = new Vector();
        this.format = format;
        this.suffixes = suffixes == null ? new String[]{} : suffixes;
    }

    protected void warn(String message) {
        this.status(new StatusEvent("Warning: " + message, true));
    }

    protected void status(String message) {
        this.status(new StatusEvent(message));
    }

    protected void status(int progress, int maximum, String message) {
        this.status(new StatusEvent(progress, maximum, message));
    }

    protected void status(StatusEvent e) {
        StatusListener[] l = this.getStatusListeners();
        for (int i = 0; i < l.length; ++i) {
            l[i].statusUpdated(e);
        }
    }

    protected void debug(String s) {
        LogTools.debug(s);
    }

    protected void debug(String s, int minLevel) {
        LogTools.debug(s, minLevel);
    }

    protected void trace(String s) {
        LogTools.trace(s);
    }

    protected void trace(Throwable t) {
        LogTools.trace(t);
    }

    protected void traceDebug(String s) {
        LogTools.traceDebug(s);
    }

    protected void traceDebug(Throwable t) {
        LogTools.traceDebug(t);
    }

    protected void warnDebug(String message) {
        LogTools.warnDebug(message);
    }

    public boolean isThisType(String name) {
        return FormatHandler.checkSuffix(name, this.suffixes);
    }

    public String getFormat() {
        return this.format;
    }

    public String[] getSuffixes() {
        return this.suffixes;
    }

    public Class getNativeDataType() {
        return byte[].class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(StatusListener l) {
        Vector vector = this.statusListeners;
        synchronized (vector) {
            if (!this.statusListeners.contains(l)) {
                this.statusListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusListener(StatusListener l) {
        Vector vector = this.statusListeners;
        synchronized (vector) {
            this.statusListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusListener[] getStatusListeners() {
        Vector vector = this.statusListeners;
        synchronized (vector) {
            Object[] l = new StatusListener[this.statusListeners.size()];
            this.statusListeners.copyInto(l);
            return l;
        }
    }

    public static boolean checkSuffix(String name, String suffix) {
        return FormatHandler.checkSuffix(name, new String[]{suffix});
    }

    public static boolean checkSuffix(String name, String[] suffixList) {
        String lname = name.toLowerCase();
        for (int i = 0; i < suffixList.length; ++i) {
            String s = "." + suffixList[i];
            if (lname.endsWith(s)) {
                return true;
            }
            for (int j = 0; j < COMPRESSION_SUFFIXES.length; ++j) {
                if (!lname.endsWith(s + "." + COMPRESSION_SUFFIXES[j])) continue;
                return true;
            }
        }
        return false;
    }
}

