/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;

public class L2DReader
extends FormatReader {
    public static final String DATE_FORMAT = "yyyy, m, d";
    private Vector[] tiffs;
    private Vector[] metadataFiles;
    private MinimalTiffReader reader;

    public L2DReader() {
        super("Li-Cor L2D", new String[]{"l2d", "scn", "tif"});
        this.domains = new String[]{"Gel/Blot Imaging"};
    }

    public boolean isThisType(String name, boolean open) {
        String[] list;
        if (L2DReader.checkSuffix(name, "l2d") || L2DReader.checkSuffix(name, "scn")) {
            return true;
        }
        if (!open) {
            return false;
        }
        Location parent = new Location(name).getAbsoluteFile().getParentFile();
        for (String file : list = parent.list()) {
            if (!L2DReader.checkSuffix(file, "scn")) continue;
            return true;
        }
        return false;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.reader.setId((String)this.tiffs[this.series].get(no));
        return this.reader.openBytes(0, buf, x, y, w, h);
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        files.add(this.currentId);
        files.addAll(this.metadataFiles[this.getSeries()]);
        if (!noPixels) {
            files.addAll(this.tiffs[this.series]);
        }
        return files.toArray(new String[files.size()]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.reader != null) {
            this.reader.close(fileOnly);
        }
        if (!fileOnly) {
            this.tiffs = null;
            this.reader = null;
            this.metadataFiles = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("L2DReader.initFile(" + id + ")");
        if (!L2DReader.checkSuffix(id, "l2d")) {
            String[] list;
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            parent = parent.getParentFile();
            for (String file : list = parent.list()) {
                if (!L2DReader.checkSuffix(file, "l2d")) continue;
                this.initFile(new Location(parent, file).getAbsolutePath());
                return;
            }
            throw new FormatException("Could not find .l2d file");
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        Location parent = new Location(id).getAbsoluteFile().getParentFile();
        Vector<String> scans = new Vector<String>();
        String line = this.in.readLine().trim();
        while (line != null && line.length() > 0) {
            if (!line.startsWith("#")) {
                String key = line.substring(0, line.indexOf("="));
                String value = line.substring(line.indexOf("=") + 1);
                this.addGlobalMeta(key, value);
                if (key.equals("ScanNames")) {
                    StringTokenizer names = new StringTokenizer(value, ",");
                    while (names.hasMoreTokens()) {
                        scans.add(names.nextToken().trim());
                    }
                }
            }
            if (this.in.getFilePointer() < this.in.length()) {
                line = this.in.readLine().trim();
                continue;
            }
            line = null;
        }
        this.in.close();
        this.tiffs = new Vector[scans.size()];
        this.metadataFiles = new Vector[scans.size()];
        this.core = new CoreMetadata[scans.size()];
        Vector<String> comments = new Vector<String>();
        Vector<String> wavelengths = new Vector<String>();
        Vector<String> dates = new Vector<String>();
        String model = null;
        for (int i = 0; i < scans.size(); ++i) {
            this.setSeries(i);
            this.core[i] = new CoreMetadata();
            this.tiffs[i] = new Vector();
            this.metadataFiles[i] = new Vector();
            String scanName = (String)scans.get(i);
            Location scanDir = new Location(parent, scanName);
            String scanPath = new Location(scanDir, scanName + ".scn").getAbsolutePath();
            this.addDirectory(scanDir.getAbsolutePath(), i);
            RandomAccessInputStream scan = new RandomAccessInputStream(scanPath);
            line = scan.readLine().trim();
            while (line != null && line.length() > 0) {
                if (!line.startsWith("#")) {
                    String key = line.substring(0, line.indexOf("="));
                    String value = line.substring(line.indexOf("=") + 1);
                    this.addSeriesMeta(key, value);
                    if (!key.equals("ExperimentNames")) {
                        if (key.equals("ImageNames")) {
                            StringTokenizer names = new StringTokenizer(value, ",");
                            while (names.hasMoreTokens()) {
                                String path = names.nextToken().trim();
                                String tiff = new Location(scanDir, path).getAbsolutePath();
                                this.tiffs[i].add(tiff);
                            }
                        } else if (key.equals("Comments")) {
                            comments.add(value);
                        } else if (key.equals("ScanDate")) {
                            dates.add(value);
                        } else if (key.equals("ScannerName")) {
                            model = value;
                        } else if (key.equals("ScanChannels")) {
                            wavelengths.add(value);
                        }
                    }
                }
                if (scan.getFilePointer() < scan.length()) {
                    line = scan.readLine().trim();
                    continue;
                }
                line = null;
            }
            if (comments.size() == i) {
                comments.add(null);
            }
            if (dates.size() == i) {
                dates.add(null);
            }
            if (wavelengths.size() != i) continue;
            wavelengths.add(null);
        }
        this.setSeries(0);
        this.reader = new MinimalTiffReader();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        for (int i = 0; i < scans.size(); ++i) {
            this.core[i].imageCount = this.tiffs[i].size();
            this.core[i].sizeC = this.tiffs[i].size();
            this.core[i].sizeT = 1;
            this.core[i].sizeZ = 1;
            this.core[i].dimensionOrder = "XYCZT";
            for (int t = 0; t < this.tiffs[i].size(); ++t) {
                this.reader.setId((String)this.tiffs[i].get(t));
                if (t != 0) continue;
                this.core[i].sizeX = this.reader.getSizeX();
                this.core[i].sizeY = this.reader.getSizeY();
                this.core[i].sizeC *= this.reader.getSizeC();
                this.core[i].rgb = this.reader.isRGB();
                this.core[i].indexed = this.reader.isIndexed();
                this.core[i].littleEndian = this.reader.isLittleEndian();
                this.core[i].pixelType = this.reader.getPixelType();
            }
        }
        MetadataTools.populatePixels(store, this);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        for (int i = 0; i < scans.size(); ++i) {
            store.setImageInstrumentRef(instrumentID, i);
            store.setImageName((String)scans.get(i), i);
            store.setImageDescription((String)comments.get(i), i);
            String date = (String)dates.get(i);
            if (date != null) {
                date = DateTools.formatDate(date, DATE_FORMAT);
                store.setImageCreationDate(date, i);
            } else {
                MetadataTools.setDefaultCreationDate(store, id, i);
            }
            String c = (String)wavelengths.get(i);
            if (c == null) continue;
            String[] waves = c.split("[, ]");
            if (waves.length < this.getEffectiveSizeC()) {
                this.debug("Expected " + this.getEffectiveSizeC() + " wavelengths; got " + waves.length + " wavelengths.");
            }
            for (int q = 0; q < waves.length; ++q) {
                String lightSourceID = MetadataTools.createLSID("LightSource", 0, q);
                store.setLightSourceID(lightSourceID, 0, q);
                store.setLaserWavelength(new Integer(waves[q].trim()), 0, q);
                store.setLaserType("Unknown", 0, q);
                store.setLaserLaserMedium("Unknown", 0, q);
                store.setLogicalChannelLightSource(lightSourceID, i, q);
            }
        }
        store.setMicroscopeModel(model, 0);
        store.setMicroscopeType("Unknown", 0);
    }

    private void addDirectory(String path, int series) {
        Location dir = new Location(path);
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            Location file = new Location(path, files[i]);
            if (file.isDirectory()) {
                this.addDirectory(file.getAbsolutePath(), series);
                continue;
            }
            String check = files[i].toLowerCase();
            if (!check.endsWith(".scn")) continue;
            this.metadataFiles[series].add(file.getAbsolutePath());
        }
    }
}

