/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.PackbitsCodec;
import loci.formats.meta.FilterMetadata;

public class PSDReader
extends FormatReader {
    public static final String PSD_MAGIC_STRING = "8BPS";
    private byte[][] lut;
    private long offset;

    public PSDReader() {
        super("Adobe Photoshop", "psd");
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = PSD_MAGIC_STRING.length();
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        return stream.readString(blockLen).startsWith(PSD_MAGIC_STRING);
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        boolean compressed;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.offset);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int plane = this.getSizeX() * this.getSizeY() * bpp;
        int[][] lens = new int[this.getSizeC()][this.getSizeY()];
        boolean bl = compressed = this.in.readShort() == 1;
        if (compressed) {
            PackbitsCodec codec = new PackbitsCodec();
            for (int c = 0; c < this.getSizeC(); ++c) {
                for (int row = 0; row < this.getSizeY(); ++row) {
                    lens[c][row] = this.in.readShort();
                }
            }
            CodecOptions options = new CodecOptions();
            options.maxBytes = this.getSizeX() * bpp;
            int len = w * bpp;
            for (int c = 0; c < this.getSizeC(); ++c) {
                for (int row = 0; row < this.getSizeY(); ++row) {
                    if (row < y || row >= y + h) {
                        this.in.skipBytes(lens[c][row]);
                        continue;
                    }
                    byte[] b = codec.decompress(this.in, options);
                    System.arraycopy(b, x * bpp, buf, c * h * len + (row - y) * len, len);
                }
            }
        } else {
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.lut = null;
            this.offset = 0L;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("PSDReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.core[0].littleEndian = false;
        if (!this.in.readString(4).equals(PSD_MAGIC_STRING)) {
            throw new FormatException("Not a valid Photoshop file.");
        }
        this.addGlobalMeta("Version", this.in.readShort());
        this.in.skipBytes(6);
        this.core[0].sizeC = this.in.readShort();
        this.core[0].sizeY = this.in.readInt();
        this.core[0].sizeX = this.in.readInt();
        short bits = this.in.readShort();
        this.addGlobalMeta("Bits per pixel", (int)bits);
        this.core[0].pixelType = bits == 16 ? 3 : 1;
        short colorMode = this.in.readShort();
        String modeString = null;
        switch (colorMode) {
            case 0: {
                modeString = "monochrome";
                break;
            }
            case 1: {
                modeString = "gray-scale";
                break;
            }
            case 2: {
                modeString = "palette color";
                break;
            }
            case 3: {
                modeString = "RGB";
                break;
            }
            case 4: {
                modeString = "CMYK";
                break;
            }
            case 6: {
                modeString = "Duotone";
                break;
            }
            case 7: {
                modeString = "Multichannel color";
                break;
            }
            case 8: {
                modeString = "Duotone";
                break;
            }
            case 9: {
                modeString = "LAB color";
            }
        }
        this.addGlobalMeta("Color mode", modeString);
        int modeDataLength = this.in.readInt();
        long fp = this.in.getFilePointer();
        if (modeDataLength != 0) {
            if (colorMode == 2) {
                this.lut = new byte[3][256];
                for (int i = 0; i < this.lut.length; ++i) {
                    this.in.read(this.lut[i]);
                }
            }
            this.in.seek(fp + (long)modeDataLength);
        }
        this.in.skipBytes(4);
        while (this.in.readString(4).equals("8BIM")) {
            int size;
            short tag = this.in.readShort();
            int read = 1;
            while (this.in.read() != 0) {
                ++read;
            }
            if (read % 2 == 1) {
                this.in.skipBytes(1);
            }
            if ((size = this.in.readInt()) % 2 == 1) {
                ++size;
            }
            this.in.skipBytes(size);
        }
        this.in.seek(this.in.getFilePointer() - 4L);
        int blockLen = this.in.readInt();
        if (blockLen == 0) {
            this.offset = this.in.getFilePointer() + 2L;
        } else {
            int i;
            int layerLen = this.in.readInt();
            int layerCount = this.in.readShort();
            if (layerCount < 0) {
                throw new FormatException("Vector data is not supported.");
            }
            int[] w = new int[layerCount];
            int[] h = new int[layerCount];
            int[] c = new int[layerCount];
            for (i = 0; i < layerCount; ++i) {
                int top = this.in.readInt();
                int left = this.in.readInt();
                int bottom = this.in.readInt();
                int right = this.in.readInt();
                w[i] = right - left;
                h[i] = bottom - top;
                c[i] = this.in.readShort();
                this.in.skipBytes(c[i] * 6 + 12);
                int len = this.in.readInt();
                if (len % 2 == 1) {
                    ++len;
                }
                this.in.skipBytes(len);
            }
            for (i = 0; i < layerCount; ++i) {
                int[] lens = new int[h[i]];
                for (int cc = 0; cc < c[i]; ++cc) {
                    int y;
                    boolean compressed;
                    boolean bl = compressed = this.in.readShort() == 1;
                    if (!compressed) {
                        this.in.skipBytes(w[i] * h[i]);
                        continue;
                    }
                    for (y = 0; y < h[i]; ++y) {
                        lens[y] = this.in.readShort();
                    }
                    for (y = 0; y < h[i]; ++y) {
                        this.in.skipBytes(lens[y]);
                    }
                }
            }
            this.in.skipBytes((int)(this.in.getFilePointer() % 2L) + 4);
            while (this.in.read() != 56) {
            }
            this.in.skipBytes(7);
            int len = this.in.readInt();
            if (len % 4 != 0) {
                len += 4 - len % 4;
            }
            this.in.skipBytes(len);
            String s = this.in.readString(4);
            while (s.equals("8BIM")) {
                this.in.skipBytes(4);
                len = this.in.readInt();
                if (len % 4 != 0) {
                    len += 4 - len % 4;
                }
                this.in.skipBytes(len);
                s = this.in.readString(4);
            }
            this.offset = this.in.getFilePointer() - 4L;
        }
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        this.core[0].rgb = modeString.equals("RGB");
        this.core[0].imageCount = this.getSizeC() / (this.isRGB() ? 3 : 1);
        this.core[0].indexed = modeString.equals("palette color");
        this.core[0].falseColor = false;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].interleaved = false;
        this.core[0].metadataComplete = true;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

